/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.test;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.client.SCTE130SocketClient;
import com.ttv.SCTE130.messages.adm.PlacementRequest;
import com.ttv.SCTE130.utils.Args;
import com.ttv.SCTE130.utils.SCTE130MessageHolder;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.SOAPElement;
import org.w3c.dom.Document;

public class PlacementRequestStressTestSocket {
    public static void main(String[] args) {
        PlacementRequestStressTestSocket arst = new PlacementRequestStressTestSocket();
        Args.initialize(arst, args);
        arst.test(args);
    }

    public void test(String[] args) {
        int iterations = 0;
        String url = null;
        String file = null;
        boolean verbose = false;
        try {
            if (Args.isOption("?") || Args.isOption("help")) {
                this.usage();
            }
            if (!Args.isOption("url")) {
                this.usage();
            } else {
                url = Args.getOptionArg("url");
            }
            if (!Args.isOption("file")) {
                this.usage();
            } else {
                file = Args.getOptionArg("file");
                File theFile = new File(file);
                if (!theFile.exists()) {
                    System.out.println("ERROR: Failed to locate file: " + file);
                    this.usage();
                }
            }
            if (Args.isOption("iterations")) {
                iterations = Integer.parseInt(Args.getOptionArg("iterations"));
            }
            if (Args.isOption("verbose")) {
                verbose = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.usage();
        }
        URL theUrl = null;
        try {
            theUrl = new URL(url);
        }
        catch (Exception e) {
            System.out.println("Failed to create URL from string: " + url);
            this.usage();
        }
        SCTE130SocketClient socketClient = new SCTE130SocketClient(theUrl.getHost(), theUrl.getPort());
        try {
            socketClient.connect();
        }
        catch (Exception e) {
            System.out.println("Failed to connect to remote socket server.");
            e.printStackTrace();
        }
        Caller caller = new Caller(iterations, file, socketClient);
        ResponseReader reader = new ResponseReader(iterations, verbose, socketClient);
        Thread t1 = new Thread(caller);
        Thread t2 = new Thread(reader);
        t2.start();
        t1.start();
        try {
            t2.join();
        }
        catch (Exception e) {
            System.out.println("Failed to join the reader.");
            e.printStackTrace();
        }
        System.out.println("Done.");
    }

    private PlacementRequest parseFile(String file) throws Exception {
        PlacementRequest placementRequest = null;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(new FileInputStream(file));
        placementRequest = new PlacementRequest(doc.getDocumentElement());
        return placementRequest;
    }

    public void usage() {
        System.out.println("Usage: PlacementRequestStressTestSocket -url <SOCKET URL>");
        System.out.println("                                        -file <source file>");
        System.out.println("                                        -iterations <number of calls to make>");
        System.out.println("                                        -verbose");
        System.out.println("Example: PlacementRequestStressTestSocket -url verbatim://localhost:5659 -file myfile.xml -iterations 50");
        System.exit(1);
    }

    private class Caller
    implements Runnable {
        private int numberOfCalls = 0;
        private String file = null;
        private SCTE130SocketClient client = null;

        public Caller(int numberOfCalls, String file, SCTE130SocketClient client) {
            this.numberOfCalls = numberOfCalls;
            this.file = file;
            this.client = client;
        }

        public void run() {
            try {
                PlacementRequest placementRequest = PlacementRequestStressTestSocket.this.parseFile(this.file);
                SOAPElement msg = placementRequest.getSOAPElement();
                SCTE130Namespaces.getInstance().populateNamespace(msg, "adm");
                msg.addNamespaceDeclaration("", SCTE130Namespaces.getInstance().getURIForName("adm"));
                SCTE130MessageHolder outBoundMessage = new SCTE130MessageHolder(SCTE130Utils.SOAPElementToByteArray(msg));
                long startTime = System.currentTimeMillis();
                for (int indx = 0; indx < this.numberOfCalls; ++indx) {
                    this.client.sendMessageOneWay(outBoundMessage);
                }
                long endTime = System.currentTimeMillis();
                System.out.println("Time to send " + this.numberOfCalls + " messages = " + (endTime - startTime) + " milliseconds");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class ResponseReader
    implements Runnable {
        private int numResponses = 0;
        private boolean verbose = false;
        private SCTE130SocketClient client = null;

        public ResponseReader(int numResponses, boolean verbose, SCTE130SocketClient client) {
            this.numResponses = numResponses;
            this.verbose = verbose;
            this.client = client;
        }

        public void run() {
            int receivedResponses = 0;
            long startTime = System.currentTimeMillis();
            while (receivedResponses != this.numResponses) {
                try {
                    SCTE130MessageHolder message = this.client.getOneWayResponse();
                    ++receivedResponses;
                }
                catch (Exception e) {
                    ++receivedResponses;
                    e.printStackTrace();
                }
            }
            long endTime = System.currentTimeMillis();
            System.out.println("Retrieved " + this.numResponses + " calls in " + (endTime - startTime) + " milliseconds. Average = " + (endTime - startTime) / (long)this.numResponses);
        }
    }
}

