/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.test.junit;

import com.ttv.SCTE130.messages.adm.ADSRegistrationRequest;
import com.ttv.SCTE130.messages.adm.Channel;
import com.ttv.SCTE130.messages.adm.ContentProvider;
import com.ttv.SCTE130.messages.adm.Network;
import com.ttv.SCTE130.messages.adm.PlacementDecisionOwner;
import com.ttv.SCTE130.messages.adm.ProductType;
import com.ttv.SCTE130.messages.adm.Scope;
import com.ttv.SCTE130.messages.adm.Service;
import com.ttv.SCTE130.messages.adm.ServiceDescription;
import com.ttv.SCTE130.messages.adm.ServiceGroup;
import com.ttv.SCTE130.messages.adm.Session;
import com.ttv.SCTE130.messages.adm.SystemContext;
import com.ttv.SCTE130.messages.adm.Zone;
import com.ttv.SCTE130.messages.cis.FilterElement;
import com.ttv.SCTE130.messages.cis.QueryFilter;
import com.ttv.SCTE130.messages.core.AdType;
import com.ttv.SCTE130.messages.core.Address;
import com.ttv.SCTE130.messages.core.Callout;
import com.ttv.SCTE130.messages.core.ContentDataModel;
import com.ttv.SCTE130.messages.core.CurrentDateTime;
import com.ttv.SCTE130.messages.core.Program;
import java.util.ArrayList;
import java.util.Date;
import junit.framework.TestCase;
import org.w3c.dom.Element;

public class ADSRegistrationRequestTest
extends TestCase {
    public void setUp() {
    }

    public void tearDown() {
    }

    public void testADSRegistrationRequest() {
        ArrayList<FilterElement> filterElements = new ArrayList<FilterElement>();
        filterElements.add(new FilterElement("Name1", "Value1", true));
        filterElements.add(new FilterElement("Name2", "Value2", true));
        ArrayList<QueryFilter> filters = new ArrayList<QueryFilter>();
        filters.add(new QueryFilter("INCLUDE", filterElements));
        ProductType productType = new ProductType("ProductType");
        ContentProvider provider = new ContentProvider("ProviderId", new ContentDataModel("CLADI_1.1", "The URL"));
        Scope scope = new Scope("Scope");
        Network network = new Network("Network");
        Zone zone = new Zone("Zone");
        Program program = new Program(101, new CurrentDateTime(new Date()));
        AdType adType = new AdType("AdType");
        ServiceGroup serviceGroup = new ServiceGroup("ServiceGroup");
        Session session = new Session("Session");
        Channel channel = new Channel("11 Alive");
        SystemContext systemContext = new SystemContext(serviceGroup, network, channel, zone, session, null);
        PlacementDecisionOwner owner = new PlacementDecisionOwner("Owner");
        ArrayList<Service> serviceList = new ArrayList<Service>();
        serviceList.add(new Service("id", "interactive", "Pre-Bumper", program, adType, provider, productType, owner, scope, null));
        ArrayList<ServiceDescription> serviceDescriptionList = new ArrayList<ServiceDescription>();
        serviceDescriptionList.add(new ServiceDescription(serviceList, systemContext, null));
        ArrayList<Address> addressList = new ArrayList<Address>();
        addressList.add(new Address("URL", "Type"));
        addressList.add(new Address("URL", "Type"));
        ArrayList<Callout> callouts = new ArrayList<Callout>();
        callouts.add(new Callout("Message", addressList, null));
        try {
            ADSRegistrationRequest req1 = new ADSRegistrationRequest("Id", "System", "Identity", serviceDescriptionList, callouts, null);
            ADSRegistrationRequest req2 = new ADSRegistrationRequest((Element)req1.getSOAPElement());
            if (!req1.equals(req2)) {
                ADSRegistrationRequestTest.fail((String)"ADSRegistrationRequest messages don't match");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ADSRegistrationRequestTest.fail((String)"Caught exception");
        }
    }
}

