/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.test.junit;

import com.ttv.SCTE130.messages.adm.ADMData;
import com.ttv.SCTE130.messages.adm.Channel;
import com.ttv.SCTE130.messages.adm.Client;
import com.ttv.SCTE130.messages.adm.ContentProvider;
import com.ttv.SCTE130.messages.adm.DesiredDuration;
import com.ttv.SCTE130.messages.adm.EffectiveEndDateTime;
import com.ttv.SCTE130.messages.adm.EffectiveStartDateTime;
import com.ttv.SCTE130.messages.adm.Entertainment;
import com.ttv.SCTE130.messages.adm.EntertainmentNPT;
import com.ttv.SCTE130.messages.adm.MaxPlacementCount;
import com.ttv.SCTE130.messages.adm.MinPlacementCount;
import com.ttv.SCTE130.messages.adm.Network;
import com.ttv.SCTE130.messages.adm.OpportunityBinding;
import com.ttv.SCTE130.messages.adm.OpportunityConstraints;
import com.ttv.SCTE130.messages.adm.Placement;
import com.ttv.SCTE130.messages.adm.PlacementConstraints;
import com.ttv.SCTE130.messages.adm.PlacementControl;
import com.ttv.SCTE130.messages.adm.PlacementDateTime;
import com.ttv.SCTE130.messages.adm.PlacementDecisionOwner;
import com.ttv.SCTE130.messages.adm.PlacementOpportunity;
import com.ttv.SCTE130.messages.adm.PlacementRequest;
import com.ttv.SCTE130.messages.adm.ProductType;
import com.ttv.SCTE130.messages.adm.Scope;
import com.ttv.SCTE130.messages.adm.Service;
import com.ttv.SCTE130.messages.adm.ServiceGroup;
import com.ttv.SCTE130.messages.adm.Session;
import com.ttv.SCTE130.messages.adm.SystemContext;
import com.ttv.SCTE130.messages.adm.TargetCode;
import com.ttv.SCTE130.messages.adm.TerminalAddress;
import com.ttv.SCTE130.messages.adm.Zone;
import com.ttv.SCTE130.messages.core.AdType;
import com.ttv.SCTE130.messages.core.AssetRef;
import com.ttv.SCTE130.messages.core.Content;
import com.ttv.SCTE130.messages.core.ContentDataModel;
import com.ttv.SCTE130.messages.core.CurrentDateTime;
import com.ttv.SCTE130.messages.core.Duration;
import com.ttv.SCTE130.messages.core.Program;
import com.ttv.SCTE130.messages.core.Tracking;
import java.util.ArrayList;
import java.util.Date;
import junit.framework.TestCase;
import org.w3c.dom.Element;

public class PlacementRequestTest
extends TestCase {
    public void setUp() {
    }

    public void tearDown() {
    }

    public void testPlacementRequest() {
        ProductType productType = new ProductType("ProductType");
        ContentProvider provider = new ContentProvider("ProviderId", new ContentDataModel("dataModel", "URL"));
        Scope scope = new Scope("scope");
        Network network = new Network("Network");
        Zone zone = new Zone("Zone");
        Program program = new Program(101, new CurrentDateTime(new Date()));
        AdType adType = new AdType("AdType");
        PlacementDecisionOwner owner = new PlacementDecisionOwner("Owner");
        ArrayList<Service> serviceList = new ArrayList<Service>();
        serviceList.add(new Service("Id", "interactive", "pre-roll", program, adType, provider, productType, owner, scope, null));
        AssetRef assetRef = new AssetRef("AssetId", "ProviderId");
        DesiredDuration duration = new DesiredDuration("PT10.000S");
        Tracking tracking = new Tracking("Tracking");
        Content content = new Content("Id", assetRef, new Duration("PT10.00s"), adType, null, tracking, null);
        Entertainment entertainment = new Entertainment(content, new EntertainmentNPT("0", 1.0), null);
        CurrentDateTime currentTime = new CurrentDateTime(new Date());
        ArrayList<TargetCode> targetCodes = new ArrayList<TargetCode>();
        targetCodes.add(new TargetCode("key", "value"));
        TerminalAddress terminalAddress = new TerminalAddress("URL", "type");
        ServiceGroup serviceGroup = new ServiceGroup("ServiceGroup");
        Client client = new Client(currentTime, targetCodes, terminalAddress, null);
        Session session = new Session("Session");
        Channel channel = new Channel("11 Alive");
        SystemContext systemContext = new SystemContext(serviceGroup, network, channel, zone, session, null);
        ADMData admData = new ADMData("Hello World");
        MinPlacementCount minSpots = new MinPlacementCount(1);
        MaxPlacementCount maxSpots = new MaxPlacementCount(2);
        EffectiveStartDateTime start = new EffectiveStartDateTime(new Date());
        EffectiveEndDateTime end = new EffectiveEndDateTime(new Date());
        OpportunityConstraints constraints = new OpportunityConstraints();
        constraints.setAdType(adType);
        constraints.setDesiredDuration(duration);
        constraints.setMaxPlacementCount(maxSpots);
        constraints.setMinPlacementCount(minSpots);
        constraints.setEffectiveStart(start);
        constraints.setEffectiveEnd(end);
        constraints.setScope(scope);
        ArrayList<PlacementControl> placementControlList = new ArrayList<PlacementControl>();
        placementControlList.add(new PlacementControl("id", "action", 1, content, constraints, new PlacementDateTime(new Date()), null));
        PlacementConstraints pConstraints = new PlacementConstraints(new Duration("PT10.00s"), start, end, scope, null);
        ArrayList<Placement> placementList = new ArrayList<Placement>();
        placementList.add(new Placement("id", "Fill", "ControlRef", 1, tracking, content, pConstraints, null));
        ArrayList<Service> services = new ArrayList<Service>();
        services.add(new Service("Id", "interactive", "pre-roll", program, adType, provider, productType, owner, scope, null));
        PlacementDateTime placementDateTime = new PlacementDateTime(new Date());
        OpportunityBinding opBinding = new OpportunityBinding("Avail", 1, 1);
        ArrayList<PlacementOpportunity> oppies = new ArrayList<PlacementOpportunity>();
        oppies.add(new PlacementOpportunity("Id", "RegRef", "LocalRef", opBinding, constraints, placementDateTime, placementControlList, null));
        try {
            PlacementRequest placement1 = new PlacementRequest("MessageId", "identity", "System", false, systemContext, services, entertainment, client, admData, oppies, null);
            PlacementRequest placement2 = new PlacementRequest((Element)placement1.getSOAPElement());
            if (!placement1.equals(placement2)) {
                PlacementRequestTest.fail((String)"PlacementRequest messages don't match");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PlacementRequestTest.fail((String)"Caught exception");
        }
    }
}

