/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.test.junit;

import com.ttv.SCTE130.messages.adm.ADMCapabilities;
import com.ttv.SCTE130.messages.adm.ADMData;
import com.ttv.SCTE130.messages.adm.ADSDeregisterRequest;
import com.ttv.SCTE130.messages.adm.ADSDeregisterResponse;
import com.ttv.SCTE130.messages.adm.ADSDeregistrationAcknowledgement;
import com.ttv.SCTE130.messages.adm.ADSDeregistrationNotification;
import com.ttv.SCTE130.messages.adm.ADSRegistrationRequest;
import com.ttv.SCTE130.messages.adm.ADSRegistrationResponse;
import com.ttv.SCTE130.messages.adm.Channel;
import com.ttv.SCTE130.messages.adm.Client;
import com.ttv.SCTE130.messages.adm.ContentProvider;
import com.ttv.SCTE130.messages.adm.DesiredDuration;
import com.ttv.SCTE130.messages.adm.EffectiveEndDateTime;
import com.ttv.SCTE130.messages.adm.EffectiveStartDateTime;
import com.ttv.SCTE130.messages.adm.Entertainment;
import com.ttv.SCTE130.messages.adm.EntertainmentNPT;
import com.ttv.SCTE130.messages.adm.EntertainmentScopedEvents;
import com.ttv.SCTE130.messages.adm.Event;
import com.ttv.SCTE130.messages.adm.Events;
import com.ttv.SCTE130.messages.adm.ListADMServicesRequest;
import com.ttv.SCTE130.messages.adm.ListADMServicesResponse;
import com.ttv.SCTE130.messages.adm.ListADSRegistrationRequest;
import com.ttv.SCTE130.messages.adm.ListADSRegistrationResponse;
import com.ttv.SCTE130.messages.adm.MaxPlacementCount;
import com.ttv.SCTE130.messages.adm.MinPlacementCount;
import com.ttv.SCTE130.messages.adm.NPT;
import com.ttv.SCTE130.messages.adm.Network;
import com.ttv.SCTE130.messages.adm.OpportunityBinding;
import com.ttv.SCTE130.messages.adm.OpportunityConstraints;
import com.ttv.SCTE130.messages.adm.Placement;
import com.ttv.SCTE130.messages.adm.PlacementConstraints;
import com.ttv.SCTE130.messages.adm.PlacementControl;
import com.ttv.SCTE130.messages.adm.PlacementDateTime;
import com.ttv.SCTE130.messages.adm.PlacementDecision;
import com.ttv.SCTE130.messages.adm.PlacementDecisionOwner;
import com.ttv.SCTE130.messages.adm.PlacementOpportunity;
import com.ttv.SCTE130.messages.adm.PlacementRequest;
import com.ttv.SCTE130.messages.adm.PlacementResponse;
import com.ttv.SCTE130.messages.adm.PlacementStatusAcknowledgement;
import com.ttv.SCTE130.messages.adm.PlacementStatusNotification;
import com.ttv.SCTE130.messages.adm.PlayData;
import com.ttv.SCTE130.messages.adm.ProductType;
import com.ttv.SCTE130.messages.adm.Scope;
import com.ttv.SCTE130.messages.adm.Service;
import com.ttv.SCTE130.messages.adm.ServiceDescription;
import com.ttv.SCTE130.messages.adm.ServiceGroup;
import com.ttv.SCTE130.messages.adm.Session;
import com.ttv.SCTE130.messages.adm.SessionEvent;
import com.ttv.SCTE130.messages.adm.Spot;
import com.ttv.SCTE130.messages.adm.SpotNPT;
import com.ttv.SCTE130.messages.adm.SpotScopedEvents;
import com.ttv.SCTE130.messages.adm.SystemContext;
import com.ttv.SCTE130.messages.adm.TargetCode;
import com.ttv.SCTE130.messages.adm.TerminalAddress;
import com.ttv.SCTE130.messages.adm.Zone;
import com.ttv.SCTE130.messages.cis.AdvancedQueryLanguage;
import com.ttv.SCTE130.messages.cis.AdvancedQueryLanguageList;
import com.ttv.SCTE130.messages.cis.BasicQueryResultList;
import com.ttv.SCTE130.messages.cis.ContentNotification;
import com.ttv.SCTE130.messages.cis.ContentNotificationAcknowledgement;
import com.ttv.SCTE130.messages.cis.ContentNotificationDeregisterRequest;
import com.ttv.SCTE130.messages.cis.ContentNotificationDeregisterResponse;
import com.ttv.SCTE130.messages.cis.ContentNotificationRegistrationRequest;
import com.ttv.SCTE130.messages.cis.ContentNotificationRegistrationResponse;
import com.ttv.SCTE130.messages.cis.ContentNotificationSelector;
import com.ttv.SCTE130.messages.cis.ContentQuery;
import com.ttv.SCTE130.messages.cis.ContentQueryRequest;
import com.ttv.SCTE130.messages.cis.ContentQueryResponse;
import com.ttv.SCTE130.messages.cis.ContentQueryResult;
import com.ttv.SCTE130.messages.cis.DataModelList;
import com.ttv.SCTE130.messages.cis.DeregistrationAcknowledgement;
import com.ttv.SCTE130.messages.cis.DeregistrationNotification;
import com.ttv.SCTE130.messages.cis.FilterElement;
import com.ttv.SCTE130.messages.cis.ListContentNotificationRegistrationRequest;
import com.ttv.SCTE130.messages.cis.ListContentNotificationRegistrationResponse;
import com.ttv.SCTE130.messages.cis.ListSupportedFeaturesRequest;
import com.ttv.SCTE130.messages.cis.ListSupportedFeaturesResponse;
import com.ttv.SCTE130.messages.cis.QueryFilter;
import com.ttv.SCTE130.messages.core.AdType;
import com.ttv.SCTE130.messages.core.Address;
import com.ttv.SCTE130.messages.core.AssetRef;
import com.ttv.SCTE130.messages.core.Callout;
import com.ttv.SCTE130.messages.core.Content;
import com.ttv.SCTE130.messages.core.ContentDataModel;
import com.ttv.SCTE130.messages.core.ContentLocation;
import com.ttv.SCTE130.messages.core.CurrentDateTime;
import com.ttv.SCTE130.messages.core.Duration;
import com.ttv.SCTE130.messages.core.Note;
import com.ttv.SCTE130.messages.core.Program;
import com.ttv.SCTE130.messages.core.ServiceCheckRequest;
import com.ttv.SCTE130.messages.core.ServiceCheckResponse;
import com.ttv.SCTE130.messages.core.ServiceStatusAcknowledgement;
import com.ttv.SCTE130.messages.core.ServiceStatusNotification;
import com.ttv.SCTE130.messages.core.StatusCode;
import com.ttv.SCTE130.messages.core.Tracking;
import com.ttv.SCTE130.utils.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.scte.schemas.x1302.x2008.core.ServiceCheckRequestDocument;
import org.scte.schemas.x1302.x2008.core.ServiceCheckResponseDocument;
import org.scte.schemas.x1302.x2008.core.ServiceStatusAcknowledgementDocument;
import org.scte.schemas.x1302.x2008.core.ServiceStatusNotificationDocument;
import org.scte.schemas.x1303.x2008.adm.ADSDeregisterRequestDocument;
import org.scte.schemas.x1303.x2008.adm.ADSDeregisterResponseDocument;
import org.scte.schemas.x1303.x2008.adm.ADSDeregistrationAcknowledgementDocument;
import org.scte.schemas.x1303.x2008.adm.ADSDeregistrationNotificationDocument;
import org.scte.schemas.x1303.x2008.adm.ADSRegistrationRequestDocument;
import org.scte.schemas.x1303.x2008.adm.ADSRegistrationResponseDocument;
import org.scte.schemas.x1303.x2008.adm.ListADMServicesRequestDocument;
import org.scte.schemas.x1303.x2008.adm.ListADMServicesResponseDocument;
import org.scte.schemas.x1303.x2008.adm.ListADSRegistrationRequestDocument;
import org.scte.schemas.x1303.x2008.adm.ListADSRegistrationResponseDocument;
import org.scte.schemas.x1303.x2008.adm.PlacementRequestDocument;
import org.scte.schemas.x1303.x2008.adm.PlacementResponseDocument;
import org.scte.schemas.x1303.x2008.adm.PlacementStatusAcknowledgementDocument;
import org.scte.schemas.x1303.x2008.adm.PlacementStatusNotificationDocument;
import org.scte.schemas.x1304.x2008.cis.ContentNotificationAcknowledgementDocument;
import org.scte.schemas.x1304.x2008.cis.ContentNotificationDeregisterRequestDocument;
import org.scte.schemas.x1304.x2008.cis.ContentNotificationDeregisterResponseDocument;
import org.scte.schemas.x1304.x2008.cis.ContentNotificationDocument;
import org.scte.schemas.x1304.x2008.cis.ContentNotificationRegistrationRequestDocument;
import org.scte.schemas.x1304.x2008.cis.ContentNotificationRegistrationResponseDocument;
import org.scte.schemas.x1304.x2008.cis.ContentQueryRequestDocument;
import org.scte.schemas.x1304.x2008.cis.ContentQueryResponseDocument;
import org.scte.schemas.x1304.x2008.cis.DeregistrationAcknowledgementDocument;
import org.scte.schemas.x1304.x2008.cis.DeregistrationNotificationDocument;
import org.scte.schemas.x1304.x2008.cis.ListContentNotificationRegistrationRequestDocument;
import org.scte.schemas.x1304.x2008.cis.ListContentNotificationRegistrationResponseDocument;
import org.scte.schemas.x1304.x2008.cis.ListSupportedFeaturesRequestDocument;
import org.scte.schemas.x1304.x2008.cis.ListSupportedFeaturesResponseDocument;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLValidationTest
extends TestCase {
    public void setUp() {
    }

    public void tearDown() {
    }

    public void testValidation() {
        try {
            if (!this.validateDeregistrationNotification()) {
                XMLValidationTest.fail((String)"DeregistrationNotification failed to validate.");
            }
            if (!this.validateDeregistrationAcknowledgement()) {
                XMLValidationTest.fail((String)"DeregistrationAcknowledgement failed to validate.");
            }
            if (!this.validateContentNotification()) {
                XMLValidationTest.fail((String)"ContentNotification failed to validate.");
            }
            if (!this.validateContentNotificationAcknowledgement()) {
                XMLValidationTest.fail((String)"ContentNotificationAcknowledgement failed to validate.");
            }
            if (!this.validateContentNotificationRegistrationRequest()) {
                XMLValidationTest.fail((String)"ContentNotificationRegistrationRequest failed to validate.");
            }
            if (!this.validateContentNotificationRegistrationResponse()) {
                XMLValidationTest.fail((String)"ContentNotificationRegistrationResponse failed to validate.");
            }
            if (!this.validateContentNotificationUnregisterRequest()) {
                XMLValidationTest.fail((String)"ContentNotificationUnregisterRequest failed to validate.");
            }
            if (!this.validateContentNotificationUnregisterResponse()) {
                XMLValidationTest.fail((String)"ContentNotificationUnregisterResponse failed to validate.");
            }
            if (!this.validateContentQueryRequest()) {
                XMLValidationTest.fail((String)"ContentQueryRequest failed to validate.");
            }
            if (!this.validateContentQueryResponse()) {
                XMLValidationTest.fail((String)"ContentQueryResponse failed to validate.");
            }
            if (!this.validateListContentNotificationRegistrationRequest()) {
                XMLValidationTest.fail((String)"ListContentNotificationRegistrationRequest failed to validate.");
            }
            if (!this.validateListContentNotificationRegistrationResponse()) {
                XMLValidationTest.fail((String)"ListContentNotificationRegistrationResponse failed to validate.");
            }
            if (!this.validateListSupportedFeaturesRequest()) {
                XMLValidationTest.fail((String)"ListSupportedFeaturesRequest failed to validate.");
            }
            if (!this.validateListSupportedFeaturesResponse()) {
                XMLValidationTest.fail((String)"ListSupportedFeaturesRequest failed to validate.");
            }
            if (!this.validateServiceCheckRequest()) {
                XMLValidationTest.fail((String)"ServiceCheckRequest failed to validate.");
            }
            if (!this.validateServiceCheckResponse()) {
                XMLValidationTest.fail((String)"ServiceCheckResponse failed to validate.");
            }
            if (!this.validateServiceStatusNotification()) {
                XMLValidationTest.fail((String)"ServiceStatusNotification failed to validate.");
            }
            if (!this.validateServiceStatusAcknowledgement()) {
                XMLValidationTest.fail((String)"ServiceStatusAcknowledgement failed to validate.");
            }
            if (!this.validateADSDeregistrationNotification()) {
                XMLValidationTest.fail((String)"ADSDeregistrationNotification failed to validate.");
            }
            if (!this.validateADSDeregistrationAcknowledgement()) {
                XMLValidationTest.fail((String)"ADSDeregistrationAcknowledgement failed to validate.");
            }
            if (!this.validateADSRegistrationRequest()) {
                XMLValidationTest.fail((String)"ADSRegistrationRequest failed to validate.");
            }
            if (!this.validateADSRegistrationResponse()) {
                XMLValidationTest.fail((String)"ADSRegistrationResponse failed to validate.");
            }
            if (!this.validateADSUnregisterRequest()) {
                XMLValidationTest.fail((String)"ADSUnregisterRequest failed to validate.");
            }
            if (!this.validateADSUnregisterResponse()) {
                XMLValidationTest.fail((String)"ADSUnregisterResponse failed to validate.");
            }
            if (!this.validateListADMServicesRequest()) {
                XMLValidationTest.fail((String)"ListADMServicesRequest failed to validate.");
            }
            if (!this.validateListADMServicesResponse()) {
                XMLValidationTest.fail((String)"ListADMServicesResponse failed to validate.");
            }
            if (!this.validateListADSRegistrationRequest()) {
                XMLValidationTest.fail((String)"ListADSRegistrationRequest failed to validate.");
            }
            if (!this.validateListADSRegistrationResponse()) {
                XMLValidationTest.fail((String)"ListADSRegistrationResponse failed to validate.");
            }
            if (!this.validatePlacementRequest()) {
                XMLValidationTest.fail((String)"PlacementRequest failed to validate.");
            }
            if (!this.validatePlacementResponse()) {
                XMLValidationTest.fail((String)"PlacementResponse failed to validate.");
            }
            if (!this.validatePlacementStatusAcknowledgement()) {
                XMLValidationTest.fail((String)"PlacementStatusAcknowledgement failed to validate.");
            }
            if (!this.validatePlacementStatusNotification()) {
                XMLValidationTest.fail((String)"PlacementStatusNotification failed to validate.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            XMLValidationTest.fail((String)"Caught exception");
        }
    }

    private boolean validateDeregistrationNotification() throws Exception {
        DeregistrationNotification not = new DeregistrationNotification("id", "System", "Ident", "registrationRef", this.getStatusCode(), null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)not.getSOAPElement());
        DeregistrationNotificationDocument doc = DeregistrationNotificationDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateDeregistrationAcknowledgement() throws Exception {
        DeregistrationAcknowledgement ack = new DeregistrationAcknowledgement("Id", "identity", "System", "Messageref", this.getStatusCode(), null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)ack.getSOAPElement());
        DeregistrationAcknowledgementDocument doc = DeregistrationAcknowledgementDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validatePlacementStatusNotification() throws Exception {
        PlacementStatusNotification req = new PlacementStatusNotification("Id", "identity", "System", this.getPlayData(), null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)req.getSOAPElement());
        Serializer ser2 = new Serializer(System.out);
        ser2.serialize((Element)req.getSOAPElement());
        PlacementStatusNotificationDocument doc = PlacementStatusNotificationDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validatePlacementStatusAcknowledgement() throws Exception {
        PlacementStatusAcknowledgement req = new PlacementStatusAcknowledgement("Id", "identity", "System", "messageRef", this.getStatusCode(), null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)req.getSOAPElement());
        PlacementStatusAcknowledgementDocument doc = PlacementStatusAcknowledgementDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validatePlacementResponse() throws Exception {
        ADMData admData = new ADMData("Hello World");
        OpportunityBinding oppyBinding = new OpportunityBinding("avail", 1, 1);
        ArrayList<Placement> placements = new ArrayList<Placement>();
        placements.add(new Placement("id", "Fill", "ref", 1, new Tracking("tracking"), this.getContent(), this.getPlacementConstraints(), null));
        ArrayList<PlacementDecision> placementDecisionList = new ArrayList<PlacementDecision>();
        placementDecisionList.add(new PlacementDecision("Id", "oppyRef", "localServiceRef", oppyBinding, this.getPlacementConstraints(), placements, null));
        PlacementResponse resp = new PlacementResponse("Id", "identity", "System", "Ref", this.getStatusCode(), this.getSystemContext(), this.getServices(), this.getEntertainment(), this.getClient(), admData, placementDecisionList, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)resp.getSOAPElement());
        PlacementResponseDocument doc = PlacementResponseDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validatePlacementRequest() throws Exception {
        Content content = this.getContent();
        ArrayList<TargetCode> targetCodeList = new ArrayList<TargetCode>();
        targetCodeList.add(new TargetCode("key", "value"));
        targetCodeList.add(new TargetCode("key", "value"));
        CurrentDateTime currentDateTime = new CurrentDateTime(new Date());
        TerminalAddress terminalAddress = new TerminalAddress("URL", "Type");
        Client client = new Client(currentDateTime, targetCodeList, terminalAddress, null);
        ADMData admData = new ADMData("Hello World");
        ArrayList<PlacementControl> placementControlList = new ArrayList<PlacementControl>();
        placementControlList.add(new PlacementControl("Id", "Fill", 1, this.getContent(), this.getOpportunityConstraints(), new PlacementDateTime(new Date()), null));
        OpportunityBinding oppyBinding = new OpportunityBinding("avail", 1, 1);
        ArrayList<PlacementOpportunity> oppies = new ArrayList<PlacementOpportunity>();
        oppies.add(new PlacementOpportunity("Id", "RegRef", "LocalRef", oppyBinding, this.getOpportunityConstraints(), new PlacementDateTime(new Date()), placementControlList, null));
        PlacementRequest req = new PlacementRequest("Id", "identity", "system", false, this.getSystemContext(), this.getServices(), this.getEntertainment(), client, admData, oppies, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)req.getSOAPElement());
        PlacementRequestDocument doc = PlacementRequestDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateListADSRegistrationResponse() throws Exception {
        ArrayList<Service> serviceList = new ArrayList<Service>();
        serviceList.add(this.getService());
        ArrayList<ServiceDescription> serviceDescriptionList = new ArrayList<ServiceDescription>();
        serviceDescriptionList.add(new ServiceDescription(serviceList, this.getSystemContext(), null));
        ArrayList<ADSRegistrationRequest> adsRegistrationRequestList = new ArrayList<ADSRegistrationRequest>();
        adsRegistrationRequestList.add(new ADSRegistrationRequest("id", "system", "ident", serviceDescriptionList, this.getCallouts(), null));
        ListADSRegistrationResponse list = new ListADSRegistrationResponse("Id", "identity", "System", "messageRef", this.getStatusCode(), adsRegistrationRequestList, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)list.getSOAPElement());
        ListADSRegistrationResponseDocument doc = ListADSRegistrationResponseDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateListADSRegistrationRequest() throws Exception {
        ListADSRegistrationRequest list = new ListADSRegistrationRequest("Id", "System", "Ident", "registrationRef", null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)list.getSOAPElement());
        ListADSRegistrationRequestDocument doc = ListADSRegistrationRequestDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateListADMServicesResponse() throws Exception {
        ArrayList<Service> services = new ArrayList<Service>();
        services.add(this.getService());
        ArrayList<ServiceDescription> serviceDescriptionList = new ArrayList<ServiceDescription>();
        serviceDescriptionList.add(new ServiceDescription(services, this.getSystemContext(), null));
        ListADMServicesResponse list = new ListADMServicesResponse("Id", "identity", "System", "messageRef", this.getStatusCode(), this.getCapabilities(), serviceDescriptionList, this.getCallouts(), null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)list.getSOAPElement());
        ListADMServicesResponseDocument doc = ListADMServicesResponseDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateListADMServicesRequest() throws Exception {
        ListADMServicesRequest list = new ListADMServicesRequest("id", "identity", "system", null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)list.getSOAPElement());
        ListADMServicesRequestDocument doc = ListADMServicesRequestDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateADSUnregisterResponse() throws Exception {
        ADSDeregisterResponse resp = new ADSDeregisterResponse("id", "identity", "System", "messageRef", this.getStatusCode(), null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)resp.getSOAPElement());
        ADSDeregisterResponseDocument doc = ADSDeregisterResponseDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateADSUnregisterRequest() throws Exception {
        ADSDeregisterRequest req = new ADSDeregisterRequest("id", "identity", "system", "messageRef", null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)req.getSOAPElement());
        ADSDeregisterRequestDocument doc = ADSDeregisterRequestDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateADSRegistrationResponse() throws Exception {
        ADSRegistrationResponse resp = new ADSRegistrationResponse("id", "identity", "System", "messageRef", this.getStatusCode(), this.getCallouts(), null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)resp.getSOAPElement());
        ADSRegistrationResponseDocument doc = ADSRegistrationResponseDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateADSRegistrationRequest() throws Exception {
        ArrayList<Service> services = new ArrayList<Service>();
        services.add(this.getService());
        ArrayList<ServiceDescription> serviceDescriptionList = new ArrayList<ServiceDescription>();
        serviceDescriptionList.add(new ServiceDescription(services, this.getSystemContext(), null));
        ADSRegistrationRequest req = new ADSRegistrationRequest("id", "identity", "system", serviceDescriptionList, this.getCallouts(), null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)req.getSOAPElement());
        ADSRegistrationRequestDocument doc = ADSRegistrationRequestDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateADSDeregistrationAcknowledgement() throws Exception {
        ADSDeregistrationAcknowledgement ack = new ADSDeregistrationAcknowledgement("id", "identity", "System", "messageRef", this.getStatusCode(), null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)ack.getSOAPElement());
        ADSDeregistrationAcknowledgementDocument doc = ADSDeregistrationAcknowledgementDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateADSDeregistrationNotification() throws Exception {
        ADSDeregistrationNotification note = new ADSDeregistrationNotification("Id", "System", "Ident", "RegistrationRef", this.getStatusCode(), null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)note.getSOAPElement());
        ADSDeregistrationNotificationDocument doc = ADSDeregistrationNotificationDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateServiceStatusNotification() throws Exception {
        ServiceStatusNotification note = new ServiceStatusNotification("id", "identity", "system", this.getStatusCode(), null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)note.getSOAPElement());
        ServiceStatusNotificationDocument doc = ServiceStatusNotificationDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateServiceStatusAcknowledgement() throws Exception {
        ServiceStatusAcknowledgement ack = new ServiceStatusAcknowledgement("id", "identity", "System", "messageref", this.getStatusCode(), null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)ack.getSOAPElement());
        ServiceStatusAcknowledgementDocument doc = ServiceStatusAcknowledgementDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateServiceCheckResponse() throws Exception {
        ServiceCheckResponse resp = new ServiceCheckResponse("Id", "identity", "System", "messageRef", this.getStatusCode(), null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)resp.getSOAPElement());
        ServiceCheckResponseDocument doc = ServiceCheckResponseDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateServiceCheckRequest() throws Exception {
        ServiceCheckRequest resp = new ServiceCheckRequest("Id", "identity", "System", null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)resp.getSOAPElement());
        ServiceCheckRequestDocument doc = ServiceCheckRequestDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateListSupportedFeaturesResponse() throws Exception {
        ArrayList<ContentDataModel> models = new ArrayList<ContentDataModel>();
        models.add(this.getContentDataModel());
        DataModelList dml = new DataModelList(models);
        ArrayList<AdvancedQueryLanguage> languages = new ArrayList<AdvancedQueryLanguage>();
        languages.add(new AdvancedQueryLanguage("XPath"));
        AdvancedQueryLanguageList advancedQueryLanguageList = new AdvancedQueryLanguageList(languages);
        ListSupportedFeaturesResponse resp = new ListSupportedFeaturesResponse("Id", "identity", "System", "messageRef", this.getStatusCode(), this.getCallouts(), dml, advancedQueryLanguageList, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)resp.getSOAPElement());
        ListSupportedFeaturesResponseDocument doc = ListSupportedFeaturesResponseDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateListSupportedFeaturesRequest() throws Exception {
        ListSupportedFeaturesRequest req = new ListSupportedFeaturesRequest("Id", "identity", "System", null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)req.getSOAPElement());
        ListSupportedFeaturesRequestDocument doc = ListSupportedFeaturesRequestDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateListContentNotificationRegistrationResponse() throws Exception {
        ArrayList<FilterElement> filterList = new ArrayList<FilterElement>();
        filterList.add(new FilterElement("Name", "Value", true));
        ArrayList<QueryFilter> queryFilterList = new ArrayList<QueryFilter>();
        queryFilterList.add(new QueryFilter("include", filterList));
        ContentNotificationSelector contentSelector = new ContentNotificationSelector(this.getContentDataModel(), "QueryId", true, queryFilterList);
        ArrayList<ContentNotificationRegistrationRequest> regList = new ArrayList<ContentNotificationRegistrationRequest>();
        regList.add(new ContentNotificationRegistrationRequest("Id", "system", "ident", this.getCallouts(), contentSelector, null));
        ListContentNotificationRegistrationResponse resp = new ListContentNotificationRegistrationResponse("Id", "identity", "System", "MessageRe", this.getStatusCode(), regList, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)resp.getSOAPElement());
        ListContentNotificationRegistrationResponseDocument doc = ListContentNotificationRegistrationResponseDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateListContentNotificationRegistrationRequest() throws Exception {
        ListContentNotificationRegistrationRequest reg = new ListContentNotificationRegistrationRequest("Id", "System", "Ident", "RegistrationRef", null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)reg.getSOAPElement());
        ListContentNotificationRegistrationRequestDocument doc = ListContentNotificationRegistrationRequestDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateContentQueryResponse() throws Exception {
        BasicQueryResultList basicList = new BasicQueryResultList(this.getContentList());
        ContentQueryResult result = new ContentQueryResult("ContentQueryId", 1, basicList);
        ContentQueryResponse resp = new ContentQueryResponse("Id", "identity", "System", "messageRef", this.getStatusCode(), result, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)resp.getSOAPElement());
        ContentQueryResponseDocument doc = ContentQueryResponseDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateContentQueryRequest() throws Exception {
        ArrayList<FilterElement> filterList = new ArrayList<FilterElement>();
        filterList.add(new FilterElement("Name", "Value", true));
        ArrayList<QueryFilter> queryFilterList = new ArrayList<QueryFilter>();
        queryFilterList.add(new QueryFilter("include", filterList));
        ContentQuery contentQuery = new ContentQuery("ContentQueryId", this.getContentDataModel(), true, queryFilterList);
        ContentQueryRequest req = new ContentQueryRequest("Id", "identity", "System", contentQuery, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)req.getSOAPElement());
        ContentQueryRequestDocument doc = ContentQueryRequestDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateContentNotificationUnregisterResponse() throws Exception {
        ContentNotificationDeregisterResponse ack = new ContentNotificationDeregisterResponse("id", "identity", "system", "messageRef", this.getStatusCode(), null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)ack.getSOAPElement());
        ContentNotificationDeregisterResponseDocument doc = ContentNotificationDeregisterResponseDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateContentNotificationUnregisterRequest() throws Exception {
        ContentNotificationDeregisterRequest req = new ContentNotificationDeregisterRequest("Id", "System", "Ident", "RegistrationRef", null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)req.getSOAPElement());
        ContentNotificationDeregisterRequestDocument doc = ContentNotificationDeregisterRequestDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateContentNotificationRegistrationResponse() throws Exception {
        ContentNotificationRegistrationResponse ack = new ContentNotificationRegistrationResponse("id", "identity", "system", "messageRef", this.getStatusCode(), null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)ack.getSOAPElement());
        ContentNotificationRegistrationResponseDocument doc = ContentNotificationRegistrationResponseDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateContentNotificationRegistrationRequest() throws Exception {
        ArrayList<FilterElement> filterList = new ArrayList<FilterElement>();
        filterList.add(new FilterElement("Name", "Value", true));
        ArrayList<QueryFilter> queryFilterList = new ArrayList<QueryFilter>();
        queryFilterList.add(new QueryFilter("include", filterList));
        ContentNotificationSelector contentSelector = new ContentNotificationSelector(this.getContentDataModel(), "QueryId", true, queryFilterList);
        ContentNotificationRegistrationRequest req = new ContentNotificationRegistrationRequest("Id", "System", "Ident", this.getCallouts(), contentSelector, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)req.getSOAPElement());
        ContentNotificationRegistrationRequestDocument doc = ContentNotificationRegistrationRequestDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateContentNotificationAcknowledgement() throws Exception {
        ContentNotificationAcknowledgement ack = new ContentNotificationAcknowledgement("id", "identity", "system", this.getStatusCode(), "messageRef", null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)ack.getSOAPElement());
        ContentNotificationAcknowledgementDocument doc = ContentNotificationAcknowledgementDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    private boolean validateContentNotification() throws Exception {
        ArrayList<Content> contentList = new ArrayList<Content>();
        contentList.add(new Content("Id", new AssetRef("AssetId", "ProviderId"), new Duration("PT10S"), new AdType("AdType"), null, new Tracking("Tracking"), null));
        BasicQueryResultList basicList = new BasicQueryResultList(contentList);
        ContentQueryResult result = new ContentQueryResult("ContentQueryId", 1, basicList);
        ContentNotification cn = new ContentNotification("Id", "identity", "System", "new", result, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer ser = new Serializer(baos);
        ser.serialize((Element)cn.getSOAPElement());
        ContentNotificationDocument doc = ContentNotificationDocument.Factory.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return this.isValid((XmlObject)doc);
    }

    public boolean isValid(XmlObject object) {
        ArrayList validationErrors = new ArrayList();
        XmlOptions m_validationOptions = new XmlOptions();
        m_validationOptions.setErrorListener(validationErrors);
        if (!object.validate(m_validationOptions)) {
            this.printErrors(validationErrors);
            return false;
        }
        return true;
    }

    public List<Address> getAddresses() {
        ArrayList<Address> addresses = new ArrayList<Address>();
        addresses.add(new Address("URL", "HTTP"));
        return addresses;
    }

    public Callout getCallout() {
        Callout callout = new Callout("message", this.getAddresses(), null);
        return callout;
    }

    public ADMCapabilities getCapabilities() {
        ADMCapabilities capabilities = new ADMCapabilities(false, null);
        return capabilities;
    }

    public Events getEvents() {
        ArrayList<Event> eventList = new ArrayList<Event>();
        eventList.add(new SessionEvent("type", new Date(), "identityADM", "systemADM", "identityADS", "messageRef", this.getStatusCode(), this.getSystemContext(), this.getClient(), this.getEntertainment(), this.getSpot(), new NPT("00:00", 1.0), null));
        Events events = new Events(eventList, new Date(), new Date(), null);
        return events;
    }

    public List<PlayData> getPlayData() {
        ArrayList<PlayData> playList = new ArrayList<PlayData>();
        playList.add(new PlayData("identityADM", "systemADM", "identityADS", new Date(), new Date(), this.getSystemContext(), this.getClient(), this.getEntertainmentScopedEvents(), this.getSpotScopedEvents(), this.getEvents(), null));
        return playList;
    }

    public List<EntertainmentScopedEvents> getEntertainmentScopedEvents() {
        ArrayList<Events> events = new ArrayList<Events>();
        events.add(this.getEvents());
        ArrayList<EntertainmentScopedEvents> entertainmentEvents = new ArrayList<EntertainmentScopedEvents>();
        entertainmentEvents.add(new EntertainmentScopedEvents(new Date(), new Date(), this.getEntertainment(), events, this.getSpotScopedEvents()));
        return entertainmentEvents;
    }

    public List<SpotScopedEvents> getSpotScopedEvents() {
        ArrayList<SpotScopedEvents> spotEvents = new ArrayList<SpotScopedEvents>();
        spotEvents.add(new SpotScopedEvents(new Date(), new Date(), this.getSpot(), this.getEvents()));
        return spotEvents;
    }

    public OpportunityConstraints getOpportunityConstraints() {
        AdType adType = new AdType("AdType");
        DesiredDuration duration = new DesiredDuration("PT30M");
        MaxPlacementCount maxPlacementCount = new MaxPlacementCount(2);
        MinPlacementCount minPlacementCount = new MinPlacementCount(1);
        EffectiveStartDateTime start = new EffectiveStartDateTime(new Date());
        EffectiveEndDateTime end = new EffectiveEndDateTime(new Date());
        Scope scope = new Scope("Scope");
        OpportunityConstraints constraints = new OpportunityConstraints();
        constraints.setAdType(adType);
        constraints.setDesiredDuration(duration);
        constraints.setMaxPlacementCount(maxPlacementCount);
        constraints.setMinPlacementCount(minPlacementCount);
        constraints.setEffectiveStart(start);
        constraints.setEffectiveEnd(end);
        constraints.setScope(scope);
        return constraints;
    }

    public PlacementConstraints getPlacementConstraints() {
        Duration duration = new Duration("PT30S");
        EffectiveStartDateTime start = new EffectiveStartDateTime(new Date());
        EffectiveEndDateTime end = new EffectiveEndDateTime(new Date());
        return new PlacementConstraints(duration, start, end, new Scope("Local"), null);
    }

    public SystemContext getSystemContext() {
        ServiceGroup serviceGroup = new ServiceGroup("ServiceGroup");
        Network network = new Network("Network");
        Session session = new Session("Session");
        Channel channel = new Channel("11 Alive");
        Zone zone = new Zone("Zone");
        return new SystemContext(serviceGroup, network, channel, zone, session, null);
    }

    public List<Service> getServices() {
        ArrayList<Service> services = new ArrayList<Service>();
        services.add(this.getService());
        return services;
    }

    public Service getService() {
        ProductType productType = new ProductType("ProductType");
        ContentProvider provider = new ContentProvider("ProviderId", this.getContentDataModel());
        Scope scope = new Scope("National");
        Program program = new Program(101, new CurrentDateTime(new Date()));
        AdType adType = new AdType("Longform");
        PlacementDecisionOwner owner = new PlacementDecisionOwner("Owner");
        return new Service("Id", "interactive", "pre-roll", program, adType, provider, productType, owner, scope, null);
    }

    public Entertainment getEntertainment() {
        return new Entertainment(this.getContent(), new EntertainmentNPT("00:00", 1.0), null);
    }

    public Spot getSpot() {
        return new Spot(new Tracking("tracking"), this.getContent(), new SpotNPT("00:00", 1.0), null);
    }

    public Client getClient() {
        ArrayList<TargetCode> targetCodes = new ArrayList<TargetCode>();
        targetCodes.add(new TargetCode("key", "value"));
        TerminalAddress terminalAddress = new TerminalAddress("Address", "Type");
        return new Client(new CurrentDateTime(new Date()), targetCodes, terminalAddress, null);
    }

    public List<Content> getContentList() {
        ArrayList<Content> contentList = new ArrayList<Content>();
        contentList.add(new Content("Id", new AssetRef("AssetId", "providerId"), new Duration("PT10S"), new AdType("AdType"), new ContentLocation("Location", false), new Tracking("Tracking"), null));
        return contentList;
    }

    public Content getContent() {
        return new Content("Id", new AssetRef("AssetId", "providerId"), new Duration("PT10S"), new AdType("AdType"), new ContentLocation("Location", false), new Tracking("Tracking"), null);
    }

    public List<Callout> getCallouts() {
        ArrayList<Callout> callouts = new ArrayList<Callout>();
        callouts.add(this.getCallout());
        return callouts;
    }

    public ContentDataModel getContentDataModel() {
        return new ContentDataModel("CLADI_1.1", "URL");
    }

    public StatusCode getStatusCode() {
        return new StatusCode(0, 0, this.getNotes(), null);
    }

    public List<Note> getNotes() {
        ArrayList<Note> noteList = new ArrayList<Note>();
        noteList.add(new Note("A Note"));
        noteList.add(new Note("Another Note"));
        return noteList;
    }

    public void printErrors(ArrayList validationErrors) {
        System.out.println("Errors discovered during validation:");
        Iterator iter = validationErrors.iterator();
        while (iter.hasNext()) {
            System.out.println(">> " + iter.next() + "\n");
        }
    }
}

