/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.utils;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateUtils {
    private static String defaultDateTimeFormat = "MM/dd/yyyy hh:mm a";
    private static String defaultDateFormat = "MM/dd/yyyy";
    private static String defaultTimeFormat = "hh:mm:ss";
    private static String defaultTimeFormatampmZero = "MM/dd/yyyy HH:mm:ss:S";
    private static String defaultTimeFormatampm = "MM/dd/yyyy kk:mm:ss";
    private static String AMSDateFormat = "yyyy-MM-dd";

    public static void adjustTimeToLocalTimezone(String remoteTimeZone, Calendar target) {
        Calendar localCalendar = Calendar.getInstance();
        target.setTimeZone(TimeZone.getTimeZone(remoteTimeZone));
        boolean remoteInDST = false;
        boolean localInDST = false;
        int remoteOffset = target.get(15) / 60000;
        int localOffset = localCalendar.get(15) / 60000;
        int scalarOffset = 0;
        int direction = 0;
        if (target.getTimeZone().inDaylightTime(target.getTime())) {
            remoteInDST = true;
        }
        if (localCalendar.getTimeZone().inDaylightTime(target.getTime())) {
            localInDST = true;
        }
        scalarOffset = remoteOffset < 0 && localOffset < 0 || remoteOffset > 0 && localOffset > 0 ? (Math.abs(remoteOffset) > Math.abs(localOffset) ? Math.abs(remoteOffset) - Math.abs(localOffset) : Math.abs(localOffset) - Math.abs(remoteOffset)) : Math.abs(remoteOffset) + Math.abs(localOffset);
        direction = localOffset < 0 ? (Math.abs(localOffset) >= Math.abs(remoteOffset) ? 1 : -1) : (remoteOffset < 0 || remoteOffset < localOffset ? -1 : 1);
        target.add(12, scalarOffset * direction);
        if (!remoteInDST && localInDST) {
            target.add(12, -60);
        }
        if (remoteInDST && !localInDST) {
            target.add(12, 60);
        }
    }

    public static void adjustTimeToRemoteTimezone(String remoteTimeZone, Calendar localCalendar) {
        Calendar remoteCalendar = Calendar.getInstance();
        remoteCalendar.setTimeZone(TimeZone.getTimeZone(remoteTimeZone));
        boolean remoteInDST = false;
        boolean localInDST = false;
        int remoteOffset = remoteCalendar.get(15) / 60000;
        int localOffset = localCalendar.get(15) / 60000;
        int scalarOffset = 0;
        int direction = 0;
        if (remoteCalendar.getTimeZone().inDaylightTime(localCalendar.getTime())) {
            remoteInDST = true;
        }
        if (localCalendar.getTimeZone().inDaylightTime(localCalendar.getTime())) {
            localInDST = true;
        }
        scalarOffset = remoteOffset < 0 && localOffset < 0 || remoteOffset > 0 && localOffset > 0 ? (Math.abs(remoteOffset) > Math.abs(localOffset) ? Math.abs(remoteOffset) - Math.abs(localOffset) : Math.abs(localOffset) - Math.abs(remoteOffset)) : Math.abs(remoteOffset) + Math.abs(localOffset);
        direction = localOffset < 0 ? (Math.abs(localOffset) >= Math.abs(remoteOffset) ? -1 : 1) : (remoteOffset < 0 || remoteOffset < localOffset ? 1 : -1);
        localCalendar.add(12, scalarOffset * direction);
        if (!remoteInDST && localInDST) {
            localCalendar.add(12, 60);
        }
        if (remoteInDST && !localInDST) {
            localCalendar.add(12, -60);
        }
    }

    public static String formatXSDDateTime(Date dateTime) {
        SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        return dateTimeFormatter.format(dateTime);
    }

    public static Date parseXSDDateTime(String date) throws Exception {
        SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        return dateTimeFormatter.parse(date);
    }

    public static String formatAMSDateTime(Date tm) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(AMSDateFormat);
        return dateFormatter.format(tm);
    }

    public static Date parseAMSDateTime(String tm) throws Exception {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(AMSDateFormat);
        return dateFormatter.parse(tm);
    }

    public static String formatDateTime(Date tm) {
        SimpleDateFormat dateTimeFormatter = new SimpleDateFormat(defaultDateTimeFormat);
        return dateTimeFormatter.format(tm);
    }

    public static String formatDateTimeWithSeconds(Date tm) {
        SimpleDateFormat dateTimeWithSecondsFormatter = new SimpleDateFormat(defaultTimeFormatampmZero);
        return dateTimeWithSecondsFormatter.format(tm);
    }

    public static Date parseDateTimeWithSeconds(String tm) throws Exception {
        SimpleDateFormat dateTimeWithSecondsFormatter = new SimpleDateFormat(defaultTimeFormatampmZero);
        return dateTimeWithSecondsFormatter.parse(tm);
    }

    public static String formatDateTime(Timestamp tm) {
        return DateUtils.formatDateTime(new Date(tm.getTime()));
    }

    public static String formatDate(Date tm) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(defaultDateFormat);
        return dateFormatter.format(tm);
    }

    public static String formatDate(Timestamp tm) {
        return DateUtils.formatDate(new Date(tm.getTime()));
    }

    public static String formatTime(Date tm) {
        SimpleDateFormat timeFormatter = new SimpleDateFormat(defaultTimeFormat);
        return timeFormatter.format(tm);
    }

    public static String formatTime(Timestamp tm) {
        return DateUtils.formatTime(new Date(tm.getTime()));
    }

    public static String formatTimeampmZero(Timestamp tm) {
        SimpleDateFormat timeFormatterampmZero = new SimpleDateFormat(defaultTimeFormatampmZero);
        return timeFormatterampmZero.format(tm);
    }

    public static String formatTimeampm(Timestamp tm) {
        SimpleDateFormat timeFormatterampm = new SimpleDateFormat(defaultTimeFormatampm);
        return timeFormatterampm.format(tm);
    }

    public static String secondsToTime(long seconds) {
        long hours = seconds / 3600L;
        long minutes = (seconds -= hours * 60L * 60L) / 60L;
        seconds -= minutes * 60L;
        String tmp = new Long(hours).toString();
        if (tmp.length() == 1) {
            tmp = "0" + tmp;
        }
        String time = tmp + ":";
        tmp = new Long(minutes).toString();
        if (tmp.length() == 1) {
            tmp = "0" + tmp;
        }
        time = time + tmp + ":";
        tmp = new Long(seconds).toString();
        if (tmp.length() == 1) {
            tmp = "0" + tmp;
        }
        time = time + tmp;
        return time;
    }

    public static String getSQLTimeLiteral(Timestamp time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return "dt{'" + sdf.format(time) + "'}";
    }

    public static Timestamp getSQLNow() {
        return new Timestamp(DateUtils.now().getTime());
    }

    public static Date now() {
        return new Date();
    }

    public static Date setEndOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(10, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static Date setBeginningOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public static boolean timeComponentExists(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(10) != 0 || cal.get(12) != 0 || cal.get(13) != 0;
    }
}

