/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.utils;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.client.SCTE130Client;
import com.ttv.SCTE130.messages.core.ServiceCheckRequest;
import com.ttv.SCTE130.messages.core.ServiceCheckResponse;
import com.ttv.SCTE130.messages.core.StatusCode;
import com.ttv.SCTE130.utils.Args;
import org.w3c.dom.Element;

public class SCTE130ServiceCheck {
    public static void main(String[] args) {
        SCTE130ServiceCheck serviceCheck = new SCTE130ServiceCheck();
        Args.initialize(serviceCheck, args);
        serviceCheck.test(args);
    }

    public void test(String[] args) {
        String url = null;
        try {
            if (Args.isOption("?") || Args.isOption("help")) {
                this.usage();
            }
            if (!Args.isOption("url")) {
                this.usage();
            } else {
                url = Args.getOptionArg("url");
            }
        }
        catch (Exception e) {
            this.usage();
        }
        try {
            ServiceCheckResponse serviceCheckResponse;
            StatusCode statusCode;
            SCTE130Client client = new SCTE130Client(null, url, "login", "password");
            ServiceCheckRequest serviceCheckRequest = new ServiceCheckRequest("messageId", "identity", "system", null);
            Element response = client.invoke(serviceCheckRequest.getSOAPElement());
            SCTE130MessageFactory messageFactory = SCTE130MessageFactoryLocator.getMessageFactory(response);
            Object genericResponse = messageFactory.allocateSCTE130Message(response);
            if (genericResponse instanceof ServiceCheckResponse && (statusCode = (serviceCheckResponse = (ServiceCheckResponse)genericResponse).getStatusCode()) != null) {
                if (statusCode.getStatusClass() != 0) {
                    System.exit(1);
                } else {
                    System.exit(0);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Caught exception processing ServiceCheckResponse from address: " + url);
            e.printStackTrace();
            System.exit(1);
        }
        System.err.println("Failed to retrieve ServiceCheckResponse from address: " + url);
        System.exit(1);
    }

    public void usage() {
        System.out.println("Usage: CampaignManagerStatusCheck -url <System URL>");
        System.out.println("Example: CampaignManagerStatusCheck -url http://localhost/CampaignMessageWS/MessageService");
        System.exit(1);
    }
}

