/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex.ssl;

import java.io.IOException;
import java.net.Socket;
import java.util.Map;
import javax.net.SocketFactory;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.transport.multiplex.MultiplexClientInvoker;
import org.jboss.remoting.transport.multiplex.VirtualSocket;

public class SSLMultiplexClientInvoker
extends MultiplexClientInvoker {
    public SSLMultiplexClientInvoker(InvokerLocator locator) throws IOException {
        super(locator);
    }

    public SSLMultiplexClientInvoker(InvokerLocator locator, Map configuration) throws IOException {
        super(locator, configuration);
    }

    protected SocketFactory createSocketFactory(Map configuration) {
        SocketFactory sf = super.createSocketFactory(configuration);
        if (sf != null) {
            return sf;
        }
        try {
            SSLSocketBuilder server = new SSLSocketBuilder();
            sf = server.createSSLSocketFactory();
        }
        catch (Exception e) {
            this.log.error("Error creating SSL Socket Factory for client invoker.", e);
        }
        return sf;
    }

    protected Socket createSocket(String address, int port) throws IOException {
        SocketFactory sf = this.getSocketFactory();
        if (sf == null) {
            String message = "No SocketFactory has been created";
            this.log.error(message);
            throw new IOException(message);
        }
        VirtualSocket socket = new VirtualSocket();
        socket.setSocketFactory(sf);
        socket.connect(this.getConnectSocketAddress(), this.getBindSocketAddress(), this.timeout);
        return socket;
    }
}

