/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc.remote;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;

public class SerializableReader
extends Reader
implements Serializable {
    static final long serialVersionUID = 1244952470388397765L;
    private char[] data = null;
    protected char[] buf;
    protected int pos;
    protected int mark = 0;
    protected int count;

    public SerializableReader(Reader reader) throws IOException {
        BufferedReader in = new BufferedReader(reader);
        String line = in.readLine();
        while (line != null) {
            String current = this.data == null ? "" : new String(this.data);
            String newData = current + line;
            this.data = newData.toCharArray();
            line = in.readLine();
        }
        reader.close();
        this.buf = this.data;
        this.pos = 0;
        this.count = this.buf.length;
    }

    public void close() throws IOException {
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (cbuf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + len > this.count) {
            len = this.count - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, cbuf, off, len);
        this.pos += len;
        return len;
    }
}

