/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.metadata.jaxrpcmapping;

import java.io.Serializable;
import javax.xml.namespace.QName;
import org.jboss.webservice.metadata.jaxrpcmapping.MethodParamPartsMapping;

public class WsdlMessageMapping
implements Serializable {
    private static final long serialVersionUID = -3212852147033081838L;
    private MethodParamPartsMapping methodParamPartsMapping;
    private QName wsdlMessage;
    private String wsdlMessagePartName;
    private String parameterMode;
    private boolean soapHeader;

    public WsdlMessageMapping(MethodParamPartsMapping methodParamPartsMapping) {
        this.methodParamPartsMapping = methodParamPartsMapping;
    }

    public MethodParamPartsMapping getMethodParamPartsMapping() {
        return this.methodParamPartsMapping;
    }

    public String getParameterMode() {
        return this.parameterMode;
    }

    public void setParameterMode(String parameterMode) {
        if (!("IN".equals(parameterMode) || "OUT".equals(parameterMode) || "INOUT".equals(parameterMode))) {
            throw new IllegalArgumentException("Invalid parameter mode: " + parameterMode);
        }
        this.parameterMode = parameterMode;
    }

    public boolean isSoapHeader() {
        return this.soapHeader;
    }

    public void setSoapHeader(boolean soapHeader) {
        this.soapHeader = soapHeader;
    }

    public QName getWsdlMessage() {
        return this.wsdlMessage;
    }

    public void setWsdlMessage(QName wsdlMessage) {
        this.wsdlMessage = wsdlMessage;
    }

    public String getWsdlMessagePartName() {
        return this.wsdlMessagePartName;
    }

    public void setWsdlMessagePartName(String wsdlMessagePartName) {
        this.wsdlMessagePartName = wsdlMessagePartName;
    }

    public String serialize() {
        StringBuffer sb = new StringBuffer();
        sb.append(" <wsdl-message-mapping> <wsdl-message xmlns:");
        sb.append(this.wsdlMessage.getPrefix()).append("='").append(this.wsdlMessage.getNamespaceURI()).append("'>");
        sb.append(this.wsdlMessage.getPrefix()).append(":").append(this.wsdlMessage.getLocalPart()).append("</wsdl-message>");
        sb.append("<wsdl-message-part-name>").append(this.wsdlMessagePartName).append("</wsdl-message-part-name>");
        sb.append("<parameter-mode>").append(this.parameterMode).append("</parameter-mode>");
        if (this.soapHeader) {
            sb.append("<soap-header/>");
        }
        sb.append("</wsdl-message-mapping>");
        return sb.toString();
    }
}

