/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.deployment;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.deployment.UnifiedDeploymentInfo;
import org.jboss.ws.metadata.ServerEndpointMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedApplicationMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedBeanMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedMessageDrivenMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedWebMetaData;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.ws.metadata.wsse.WSSecurityConfigurationFactory;
import org.jboss.ws.server.ServiceEndpointManager;
import org.jboss.ws.server.ServiceEndpointManagerFactory;
import org.jboss.ws.utils.ObjectNameFactory;

public abstract class AbstractMetaDataBuilder {
    private static final Logger log = Logger.getLogger(AbstractMetaDataBuilder.class);
    protected ClassLoader classLoader;
    protected URLClassLoader resourceLoader;

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setResourceLoader(URLClassLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected ObjectName getServiceEndpointID(UnifiedDeploymentInfo udi, ServerEndpointMetaData sepMetaData) {
        String endpoint = sepMetaData.getLinkName();
        String context = sepMetaData.getContextRoot();
        if (context.startsWith("/")) {
            context = context.substring(1);
        }
        StringBuilder idstr = new StringBuilder("jboss.ws:");
        idstr.append("context=" + context);
        idstr.append(",endpoint=" + endpoint);
        if (udi.metaData instanceof UnifiedApplicationMetaData) {
            String ejbName = sepMetaData.getLinkName();
            if (ejbName == null) {
                throw new WSException("Cannot obtain ejb-link from port component");
            }
            UnifiedApplicationMetaData applMetaData = (UnifiedApplicationMetaData)udi.metaData;
            UnifiedBeanMetaData beanMetaData = applMetaData.getBeanByEjbName(ejbName);
            if (beanMetaData == null) {
                throw new WSException("Cannot obtain ejb meta data for: " + ejbName);
            }
            if (beanMetaData instanceof UnifiedMessageDrivenMetaData) {
                UnifiedMessageDrivenMetaData mdMetaData = (UnifiedMessageDrivenMetaData)beanMetaData;
                String jndiName = mdMetaData.getDestinationJndiName();
                idstr.append(",jms=" + jndiName);
            }
        }
        return ObjectNameFactory.create(idstr.toString());
    }

    public String getServiceEndpointAddress(String uriScheme, String servicePath) {
        if (servicePath == null || servicePath.length() == 0) {
            throw new WSException("Service path cannot be null");
        }
        if (servicePath.endsWith("/*")) {
            servicePath = servicePath.substring(0, servicePath.length() - 2);
        }
        if (uriScheme == null) {
            uriScheme = "http";
        }
        ServiceEndpointManagerFactory factory = ServiceEndpointManagerFactory.getInstance();
        ServiceEndpointManager epManager = factory.getServiceEndpointManager();
        String host = epManager.getWebServiceHost();
        int port = epManager.getWebServicePort();
        if ("https".equals(uriScheme)) {
            port = epManager.getWebServiceSecurePort();
        }
        String urlStr = uriScheme + "://" + host + ":" + port + servicePath;
        try {
            return new URL(urlStr).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new WSException("Malformed URL: " + urlStr);
        }
    }

    protected void replaceAddressLocation(ServerEndpointMetaData epMetaData) {
        WSDLDefinitions wsdlDefinitions = epMetaData.getServiceMetaData().getWsdlDefinitions();
        QName portName = epMetaData.getName();
        boolean endpointFound = false;
        for (WSDLService wsdlService : wsdlDefinitions.getServices()) {
            for (WSDLEndpoint wsdlEndpoint : wsdlService.getEndpoints()) {
                QName wsdlPortName = wsdlEndpoint.getQName();
                if (!wsdlPortName.equals(portName)) continue;
                endpointFound = true;
                String orgAddress = wsdlEndpoint.getAddress();
                String uriScheme = this.getUriScheme(orgAddress);
                String transportGuarantee = epMetaData.getTransportGuarantee();
                if ("CONFIDENTIAL".equals(transportGuarantee)) {
                    uriScheme = "https";
                }
                String servicePath = epMetaData.getContextRoot() + epMetaData.getURLPattern();
                String serviceEndpointURL = this.getServiceEndpointAddress(uriScheme, servicePath);
                ServiceEndpointManagerFactory factory = ServiceEndpointManagerFactory.getInstance();
                ServiceEndpointManager epManager = factory.getServiceEndpointManager();
                boolean alwaysModify = epManager.isAlwaysModifySOAPAddress();
                if (alwaysModify || uriScheme == null || orgAddress.indexOf("REPLACE_WITH_ACTUAL_URL") >= 0) {
                    log.debug((Object)("Replace service endpoint address '" + orgAddress + "' with '" + serviceEndpointURL + "'"));
                    wsdlEndpoint.setAddress(serviceEndpointURL);
                    epMetaData.setEndpointAddress(serviceEndpointURL);
                    if (wsdlDefinitions.getWsdlOneOneDefinition() == null) continue;
                    this.replaceWSDL11SOAPAddress(wsdlDefinitions, portName, serviceEndpointURL);
                    continue;
                }
                log.debug((Object)("Don't replace service endpoint address '" + orgAddress + "'"));
                try {
                    epMetaData.setEndpointAddress(new URL(orgAddress).toExternalForm());
                }
                catch (MalformedURLException e) {
                    throw new WSException("Malformed URL: " + orgAddress);
                }
            }
        }
        if (!endpointFound) {
            throw new WSException("Cannot find service endpoint '" + portName + "' in wsdl document");
        }
    }

    private void replaceWSDL11SOAPAddress(WSDLDefinitions wsdlDefinitions, QName portQName, String serviceEndpointURL) {
        Definition wsdlOneOneDefinition = wsdlDefinitions.getWsdlOneOneDefinition();
        String tnsURI = wsdlOneOneDefinition.getTargetNamespace();
        Port wsdlOneOnePort = this.modifyPortAddress(tnsURI, portQName, serviceEndpointURL, wsdlOneOneDefinition.getServices());
        if (wsdlOneOnePort == null && !wsdlOneOneDefinition.getImports().isEmpty()) {
            for (List l : wsdlOneOneDefinition.getImports().values()) {
                for (Import anImport : l) {
                    wsdlOneOnePort = this.modifyPortAddress(anImport.getNamespaceURI(), portQName, serviceEndpointURL, anImport.getDefinition().getServices());
                }
            }
        }
        if (wsdlOneOnePort == null) {
            throw new IllegalArgumentException("Cannot find port with name '" + portQName + "' in wsdl document");
        }
    }

    private Port modifyPortAddress(String tnsURI, QName portQName, String serviceEndpointURL, Map services) {
        Port wsdlOneOnePort = null;
        for (Service wsdlOneOneService : services.values()) {
            Map wsdlOneOnePorts = wsdlOneOneService.getPorts();
            for (String portLocalName : wsdlOneOnePorts.keySet()) {
                if (!portQName.equals(new QName(tnsURI, portLocalName))) continue;
                wsdlOneOnePort = (Port)wsdlOneOnePorts.get(portLocalName);
                for (Object obj : wsdlOneOnePort.getExtensibilityElements()) {
                    if (!(obj instanceof SOAPAddress)) continue;
                    SOAPAddress address = (SOAPAddress)obj;
                    address.setLocationURI(serviceEndpointURL);
                }
            }
        }
        return wsdlOneOnePort;
    }

    private String getUriScheme(String addrStr) {
        try {
            URI addrURI = new URI(addrStr);
            String scheme = addrURI.getScheme();
            return scheme;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    protected WSSecurityConfiguration getWsSecurityConfiguration(UnifiedDeploymentInfo udi) throws IOException {
        WSSecurityConfiguration config = null;
        String resource = WSSecurityConfigurationFactory.SERVER_RESOURCE_NAME;
        resource = udi.metaData instanceof UnifiedWebMetaData ? "WEB-INF/" + resource : "META-INF/" + resource;
        URL location = this.resourceLoader.getResource(resource);
        if (location != null) {
            config = WSSecurityConfigurationFactory.newInstance().parse(location);
            if (config.getKeyStoreFile() != null && (location = this.resourceLoader.getResource(config.getKeyStoreFile())) != null) {
                config.setKeyStoreURL(location);
            }
            if (config.getTrustStoreFile() != null && (location = this.resourceLoader.getResource(config.getTrustStoreFile())) != null) {
                config.setTrustStoreURL(location);
            }
        }
        return config;
    }
}

