/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jws.HandlerChain;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.InitParam;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPMessageHandler;
import javax.jws.soap.SOAPMessageHandlers;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.holders.Holder;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.addressing.AddressingPropertiesImpl;
import org.jboss.ws.addressing.metadata.AddressingOpMetaExt;
import org.jboss.ws.annotation.PortComponent;
import org.jboss.ws.deployment.AbstractMetaDataBuilder;
import org.jboss.ws.deployment.UnifiedDeploymentInfo;
import org.jboss.ws.jaxrpc.ParameterWrapping;
import org.jboss.ws.jaxrpc.Style;
import org.jboss.ws.jaxrpc.TypeMappingImpl;
import org.jboss.ws.jaxrpc.TypeMappingRegistryImpl;
import org.jboss.ws.jaxrpc.Use;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.FaultMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.metadata.ServerEndpointMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.TypeMappingMetaData;
import org.jboss.ws.metadata.TypesMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedHandlerMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedInitParamMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedWebMetaData;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.jsr181.HandlerChainMetaData;
import org.jboss.ws.metadata.jsr181.HandlerConfigFactory;
import org.jboss.ws.metadata.jsr181.HandlerConfigMetaData;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.ws.server.ServerConfig;
import org.jboss.ws.server.ServerConfigFactory;
import org.jboss.ws.tools.JavaToWSDL;
import org.jboss.ws.tools.ToolsUtils;
import org.jboss.ws.utils.HolderUtils;
import org.jboss.ws.utils.IOUtils;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSR181MetaDataBuilder
extends AbstractMetaDataBuilder {
    private final Logger log = Logger.getLogger(JSR181MetaDataBuilder.class);

    protected ServerEndpointMetaData setupEndpointFromAnnotations(UnifiedMetaData wsMetaData, UnifiedDeploymentInfo udi, Class sepClass, String linkName) throws ClassNotFoundException {
        String targetNS;
        String serviceName;
        WebService anWebService = sepClass.getAnnotation(WebService.class);
        if (anWebService == null) {
            throw new WSException("Cannot obtain @WebService annotaion from: " + sepClass.getName());
        }
        Class<?> seiClass = null;
        String seiName = null;
        if (anWebService.endpointInterface().length() > 0 && (anWebService = (seiClass = udi.annotationsCl.loadClass(seiName = anWebService.endpointInterface())).getAnnotation(WebService.class)) == null) {
            throw new WSException("Interface does not have a @WebService annotation: " + seiName);
        }
        Class<?> wsClass = seiClass != null ? seiClass : sepClass;
        WSDLUtils wsdlUtils = WSDLUtils.getInstance();
        String name = anWebService.name();
        if (name.length() == 0) {
            name = wsdlUtils.getJustClassName(wsClass);
        }
        if ((serviceName = anWebService.serviceName()).length() == 0) {
            serviceName = name + "Service";
        }
        if ((targetNS = anWebService.targetNamespace()).length() == 0) {
            targetNS = wsdlUtils.getTypeNamespace(wsClass);
        }
        String portName = name + "Port";
        ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, new QName(targetNS, serviceName));
        wsMetaData.addService(serviceMetaData);
        try {
            WSSecurityConfiguration securityConfiguration = this.getWsSecurityConfiguration(udi);
            serviceMetaData.setSecurityConfiguration(securityConfiguration);
        }
        catch (IOException e) {
            this.log.warn((Object)("Unable to process WSSecurityConfiguration: " + e.getMessage()));
        }
        QName portQName = new QName(targetNS, portName);
        ServerEndpointMetaData sepMetaData = new ServerEndpointMetaData(serviceMetaData, portQName);
        sepMetaData.setLinkName(linkName);
        sepMetaData.setAnnotated(true);
        sepMetaData.setServiceEndpointImplName(sepClass.getName());
        sepMetaData.setServiceEndpointInterfaceName(wsClass.getName());
        serviceMetaData.addEndpoint(sepMetaData);
        if (wsClass.isAnnotationPresent(SOAPBinding.class)) {
            this.processSOAPBinding(wsClass, sepMetaData);
        }
        int webMethodCount = 0;
        boolean includeAllMethods = wsClass == seiClass;
        for (Method method : wsClass.getMethods()) {
            if (!includeAllMethods && !method.isAnnotationPresent(WebMethod.class)) continue;
            this.processWebMethod(sepMetaData, method);
            ++webMethodCount;
        }
        if (seiClass != null && webMethodCount == 0) {
            for (Class<?> superClass = seiClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
                for (Method method : superClass.getMethods()) {
                    this.processWebMethod(sepMetaData, method);
                    ++webMethodCount;
                }
            }
        }
        if (webMethodCount == 0) {
            throw new WSException("At least one @WebMethod annotation is required");
        }
        if (sepClass.isAnnotationPresent(HandlerChain.class)) {
            this.processHandlerChain(sepClass, sepMetaData);
        } else if (wsClass.isAnnotationPresent(HandlerChain.class)) {
            this.processHandlerChain(wsClass, sepMetaData);
        }
        if (sepClass.isAnnotationPresent(SOAPMessageHandlers.class)) {
            this.processSOAPMessageHandlers(sepClass, sepMetaData);
        } else if (wsClass.isAnnotationPresent(SOAPMessageHandlers.class)) {
            this.processSOAPMessageHandlers(wsClass, sepMetaData);
        }
        this.processOrGenerateWSDL(wsClass, serviceMetaData, sepMetaData);
        WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
        JBossXSModel schemaModel = wsdlDefinitions.getWsdlTypes().getSchemaModel();
        serviceMetaData.getTypesMetaData().setSchemaModel(schemaModel);
        this.processPortComponent(udi, wsClass, linkName, sepMetaData);
        ObjectName sepID = this.getServiceEndpointID(udi, sepMetaData);
        sepMetaData.setServiceEndpointID(sepID);
        return sepMetaData;
    }

    private void processSOAPBinding(Class wsClass, ServerEndpointMetaData epMetaData) {
        SOAPBinding anSoapBinding = wsClass.getAnnotation(SOAPBinding.class);
        SOAPBinding.Style attrStyle = anSoapBinding.style();
        Style style = attrStyle == SOAPBinding.Style.RPC ? Style.RPC : Style.DOCUMENT;
        epMetaData.setStyle(style);
        SOAPBinding.Use attrUse = anSoapBinding.use();
        if (attrUse == SOAPBinding.Use.ENCODED) {
            throw new WSException("SOAP encoding is not supported for JSR-181 deployments. It is also disallowed by the WS-I Basic Profile 1.1. Please switch to literal encoding");
        }
        epMetaData.setEncodingStyle(Use.LITERAL);
        SOAPBinding.ParameterStyle attrParamStyle = anSoapBinding.parameterStyle();
        SOAPBinding.ParameterStyle paramStyle = attrParamStyle == SOAPBinding.ParameterStyle.BARE ? SOAPBinding.ParameterStyle.BARE : SOAPBinding.ParameterStyle.WRAPPED;
        epMetaData.setParameterStyle(paramStyle);
    }

    private void processOrGenerateWSDL(Class wsClass, ServiceMetaData serviceMetaData, EndpointMetaData endpointMetaData) {
        WebService anWebService = wsClass.getAnnotation(WebService.class);
        String wsdlLocation = anWebService.wsdlLocation();
        if (wsdlLocation.length() > 0) {
            serviceMetaData.setWsdlFile(wsdlLocation);
        } else {
            ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
            try {
                UnifiedMetaData wsMetaData = serviceMetaData.getUnifiedMetaData();
                Thread.currentThread().setContextClassLoader(wsMetaData.getClassLoader());
                String serviceName = serviceMetaData.getName().getLocalPart();
                JavaToWSDL javaToWSDL = new JavaToWSDL("http://schemas.xmlsoap.org/wsdl/");
                javaToWSDL.setUnifiedMetaData(wsMetaData);
                javaToWSDL.setQualifiedElements(true);
                WSDLDefinitions wsdlDefinitions = javaToWSDL.generate(wsClass);
                JavaWsdlMapping mapping = javaToWSDL.getJavaWsdlMapping();
                String fakeMappingName = serviceName + "-annotation-generated";
                serviceMetaData.setJaxrpcMappingFile(fakeMappingName);
                serviceMetaData.getUnifiedMetaData().addMappingDefinition(fakeMappingName, mapping);
                ServerConfigFactory factory = ServerConfigFactory.getInstance();
                ServerConfig config = factory.getServerConfig();
                File tmpdir = new File(config.getServerTempDir().getCanonicalPath() + "/jbossws");
                tmpdir.mkdirs();
                File wsdlTmpFile = File.createTempFile(serviceName, ".wsdl", tmpdir);
                wsdlTmpFile.deleteOnExit();
                Writer writer = IOUtils.getCharsetFileWriter(wsdlTmpFile, "UTF-8");
                wsdlDefinitions.write(writer, "UTF-8");
                writer.close();
                serviceMetaData.setWsdlFile(wsdlTmpFile.toURL().toExternalForm());
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (IOException e) {
                throw new WSException("Cannot write generated wsdl", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(ctxLoader);
            }
        }
    }

    private void processPortComponent(UnifiedDeploymentInfo udi, Class wsClass, String linkName, ServerEndpointMetaData epMetaData) {
        PortComponent anPortComponent;
        String contextRoot = null;
        if (udi.metaData instanceof UnifiedWebMetaData) {
            UnifiedWebMetaData webMetaData = (UnifiedWebMetaData)udi.metaData;
            contextRoot = webMetaData.getContextRoot();
        }
        if ((anPortComponent = wsClass.getAnnotation(PortComponent.class)) != null) {
            String transportGuarantee;
            if (anPortComponent.contextRoot().length() > 0) {
                contextRoot = anPortComponent.contextRoot();
            } else {
                String shortName = udi.shortName;
                contextRoot = "/" + shortName.substring(0, shortName.indexOf(46));
            }
            epMetaData.setContextRoot(contextRoot);
            String urlPattern = anPortComponent.urlPattern().length() > 0 ? anPortComponent.urlPattern() : "/" + linkName;
            epMetaData.setURLPattern(urlPattern);
            String servicePath = contextRoot + urlPattern;
            epMetaData.setEndpointAddress(this.getServiceEndpointAddress(null, servicePath));
            String authMethod = anPortComponent.authMethod();
            if (authMethod.length() > 0) {
                epMetaData.setAuthMethod(authMethod);
            }
            if ((transportGuarantee = anPortComponent.transportGuarantee()).length() > 0) {
                epMetaData.setTransportGuarantee(transportGuarantee);
            }
        } else {
            if (contextRoot == null) {
                String shortName = udi.shortName;
                contextRoot = "/" + shortName.substring(0, shortName.indexOf(46));
            }
            epMetaData.setContextRoot(contextRoot);
            String urlPattern = "/" + linkName;
            epMetaData.setURLPattern(urlPattern);
            String servicePath = contextRoot + urlPattern;
            epMetaData.setEndpointAddress(this.getServiceEndpointAddress(null, servicePath));
        }
        this.replaceAddressLocation(epMetaData);
    }

    private WebParam getWebParamAnnotation(Method method, int pos) {
        for (Annotation annotation : method.getParameterAnnotations()[pos]) {
            if (!(annotation instanceof WebParam)) continue;
            return (WebParam)annotation;
        }
        return null;
    }

    private void processWebMethod(ServerEndpointMetaData epMetaData, Method method) {
        ServiceMetaData serviceMetaData = epMetaData.getServiceMetaData();
        TypesMetaData typesMetaData = serviceMetaData.getTypesMetaData();
        String targetNS = epMetaData.getName().getNamespaceURI();
        String soapAction = "";
        String operationName = method.getName();
        if (method.isAnnotationPresent(WebMethod.class)) {
            WebMethod anWebMethod = method.getAnnotation(WebMethod.class);
            soapAction = anWebMethod.action();
            if (anWebMethod.operationName().length() > 0) {
                operationName = anWebMethod.operationName();
            }
        }
        String javaName = method.getName();
        OperationMetaData opMetaData = new OperationMetaData(epMetaData, new QName(targetNS, operationName), javaName);
        opMetaData.setOneWayOperation(method.isAnnotationPresent(Oneway.class));
        opMetaData.setSOAPAction(soapAction);
        epMetaData.addOperation(opMetaData);
        HashMap<String, Integer> typeIndexes = new HashMap<String, Integer>();
        ArrayList<QName> wrappedElementNames = null;
        ArrayList<String> wrappedVariables = null;
        ArrayList<String> wrappedTypes = null;
        ParameterMetaData wrappedParameter = null;
        String encStyle = opMetaData.getUse().toURI();
        TypeMappingRegistryImpl tmRegistry = new TypeMappingRegistryImpl();
        TypeMappingImpl typeMapping = (TypeMappingImpl)tmRegistry.getTypeMapping(encStyle);
        QName xmlName = null;
        QName xmlType = null;
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (opMetaData.isDocumentWrapped()) {
            xmlName = opMetaData.getXmlName();
            xmlType = opMetaData.getXmlName();
            String epName = epMetaData.getName().getLocalPart();
            if (epName.endsWith("Port")) {
                epName = epName.substring(0, epName.lastIndexOf("Port"));
            }
            wrappedParameter = new ParameterMetaData(opMetaData, xmlName, xmlType, null);
            wrappedElementNames = new ArrayList<QName>(parameterTypes.length);
            wrappedVariables = new ArrayList<String>(parameterTypes.length);
            wrappedTypes = new ArrayList<String>(parameterTypes.length);
            wrappedParameter.setWrappedElementNames(wrappedElementNames);
            wrappedParameter.setWrappedVariables(wrappedVariables);
            wrappedParameter.setWrappedTypes(wrappedTypes);
            opMetaData.addParameter(wrappedParameter);
            if (!opMetaData.isOneWayOperation()) {
                xmlName = new QName(targetNS, operationName + "Response");
                xmlType = new QName(targetNS, operationName + "Response");
                ParameterMetaData retMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, null);
                retMetaData.setWrappedVariables(new ArrayList<String>(1));
                retMetaData.setWrappedElementNames(new ArrayList<QName>(1));
                retMetaData.setWrappedTypes(new ArrayList<String>(1));
                opMetaData.setReturnParameter(retMetaData);
            }
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            boolean isWrapped;
            Class javaType = parameterTypes[i];
            String javaTypeName = javaType.getName();
            WebParam anWebParam = this.getWebParamAnnotation(method, i);
            boolean bl = isWrapped = opMetaData.isDocumentWrapped() && (anWebParam == null || !anWebParam.header());
            if (Holder.class.isAssignableFrom(javaType)) {
                javaType = HolderUtils.getValueType(javaType);
                javaTypeName = javaType.getName();
            }
            if ((xmlType = typeMapping.getXMLType(javaType)) == null) {
                xmlType = this.getWebParamType(opMetaData, javaType);
            }
            TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, javaTypeName);
            typesMetaData.addTypeMapping(tmMetaData);
            if (isWrapped) {
                QName wrappedElementName = this.getWebParamName(opMetaData, typeIndexes, javaType, anWebParam);
                wrappedElementNames.add(wrappedElementName);
                String variable = wrappedElementName.getLocalPart();
                if (variable.length() == 0) {
                    throw new WSException("A web parameter had a name with 0 length");
                }
                variable = this.convertToProperty(variable);
                wrappedVariables.add(variable);
                wrappedTypes.add(javaTypeName);
                continue;
            }
            xmlName = this.getWebParamName(opMetaData, typeIndexes, javaType, anWebParam);
            xmlType = typeMapping.getXMLType(javaType);
            if (xmlType == null) {
                xmlType = this.getWebParamType(opMetaData, javaType);
            }
            ParameterMetaData paramMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
            if (anWebParam != null) {
                if (anWebParam.mode() == WebParam.Mode.INOUT) {
                    paramMetaData.setMode(ParameterMode.INOUT);
                }
                if (anWebParam.mode() == WebParam.Mode.OUT) {
                    paramMetaData.setMode(ParameterMode.OUT);
                }
                if (anWebParam.header()) {
                    paramMetaData.setInHeader(true);
                }
            }
            opMetaData.addParameter(paramMetaData);
        }
        Class<?> returnType = method.getReturnType();
        String returnTypeName = returnType.getName();
        if (!(returnType == Void.TYPE)) {
            if (opMetaData.isOneWayOperation()) {
                throw new IllegalArgumentException("[JSR-181 2.5.1] The method '" + method.getName() + "' can not have a return value if it is marked OneWay");
            }
            xmlType = typeMapping.getXMLType(returnType);
            if (xmlType == null) {
                xmlType = this.getWebResultType(targetNS, returnType);
            }
            TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, returnTypeName);
            typesMetaData.addTypeMapping(tmMetaData);
            if (opMetaData.isDocumentWrapped()) {
                QName elementName = this.getWebResultName(opMetaData, returnType, method.getAnnotation(WebResult.class));
                ParameterMetaData retMetaData = opMetaData.getReturnParameter();
                retMetaData.getWrappedElementNames().add(elementName);
                retMetaData.getWrappedVariables().add(this.convertToProperty(elementName.getLocalPart()));
                retMetaData.getWrappedTypes().add(returnTypeName);
            } else {
                xmlName = this.getWebResultName(opMetaData, returnType, method.getAnnotation(WebResult.class));
                ParameterMetaData retMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, returnTypeName);
                opMetaData.setReturnParameter(retMetaData);
            }
        }
        if (opMetaData.isDocumentWrapped()) {
            ParameterWrapping.generateWrapper(wrappedParameter, false);
            if (!opMetaData.isOneWayOperation()) {
                ParameterWrapping.generateWrapper(opMetaData.getReturnParameter(), false);
            }
        }
        for (Class<?> exClass : method.getExceptionTypes()) {
            if (RemoteException.class.isAssignableFrom(exClass)) continue;
            this.addFault(opMetaData, typesMetaData, exClass);
        }
        this.processOpMetaExtensions(epMetaData, opMetaData);
    }

    private String convertToProperty(String variable) {
        if (Character.isUpperCase(variable.charAt(0))) {
            char c = Character.toLowerCase(variable.charAt(0));
            StringBuilder builder = new StringBuilder(variable);
            builder.setCharAt(0, c);
            variable = builder.toString();
        }
        return variable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processHandlerChain(Class wsClass, ServerEndpointMetaData epMetaData) {
        if (wsClass.isAnnotationPresent(SOAPMessageHandlers.class)) {
            throw new WSException("Cannot combine @HandlerChain with @SOAPMessageHandlers");
        }
        HandlerChain anHandlerChain = wsClass.getAnnotation(HandlerChain.class);
        String handlerChainFile = anHandlerChain.file();
        try {
            HandlerConfigMetaData handlerConfigMetaData = null;
            URL fileURL = null;
            String filename = anHandlerChain.file();
            try {
                fileURL = new URL(filename);
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
            if (fileURL == null) {
                try {
                    File file = new File(filename);
                    if (file.exists()) {
                        fileURL = file.toURL();
                    }
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            if (fileURL == null) {
                fileURL = epMetaData.getResourceLoader().getResource(filename);
            }
            if (fileURL == null) {
                throw new WSException("Cannot resolve URL to handler file: " + filename);
            }
            InputStream is = fileURL.openStream();
            try {
                Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
                HandlerConfigFactory factory = new HandlerConfigFactory(fileURL);
                handlerConfigMetaData = (HandlerConfigMetaData)unmarshaller.unmarshal(is, (ObjectModelFactory)factory, null);
            }
            finally {
                is.close();
            }
            for (HandlerChainMetaData handlerChainMetaData : handlerConfigMetaData.getHandlerChains()) {
                String hcName = handlerChainMetaData.getHandlerChainName();
                if (!hcName.equals(anHandlerChain.name()) && anHandlerChain.name() != null) continue;
                for (UnifiedHandlerMetaData handlerMetaData : handlerChainMetaData.getHandlers()) {
                    epMetaData.addHandler(handlerMetaData);
                }
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException("Cannot process handler chain: " + handlerChainFile, ex);
        }
    }

    private void processSOAPMessageHandlers(Class wsClass, ServerEndpointMetaData epMetaData) {
        if (wsClass.isAnnotationPresent(HandlerChain.class)) {
            throw new WSException("Cannot combine @SOAPMessageHandlers with @HandlerChain");
        }
        SOAPMessageHandlers anSOAPMessageHandlers = wsClass.getAnnotation(SOAPMessageHandlers.class);
        for (SOAPMessageHandler handler : anSOAPMessageHandlers.value()) {
            UnifiedHandlerMetaData handlerMetaData = new UnifiedHandlerMetaData();
            handlerMetaData.setHandlerName(handler.name());
            handlerMetaData.setHandlerClass(handler.className());
            for (InitParam initParam : handler.initParams()) {
                UnifiedInitParamMetaData initParamMetaData = new UnifiedInitParamMetaData();
                initParamMetaData.setParamName(initParam.name());
                initParamMetaData.setParamValue(initParam.value());
                handlerMetaData.addInitParam(initParamMetaData);
            }
            for (String role : handler.roles()) {
                handlerMetaData.addSoapRole(role);
            }
            for (String header : handler.headers()) {
                handlerMetaData.addSoapHeader(QName.valueOf(header));
            }
            epMetaData.addHandler(handlerMetaData);
        }
    }

    private QName getWebParamName(OperationMetaData opMetaData, Map<String, Integer> typeIndexes, Class javaType, WebParam webParam) {
        QName xmlName = null;
        String namespaceURI = opMetaData.getXmlName().getNamespaceURI();
        if (webParam != null) {
            if (webParam.targetNamespace().length() > 0) {
                namespaceURI = webParam.targetNamespace();
            }
            if (webParam.name().length() > 0) {
                xmlName = opMetaData.getStyle() != Style.RPC || webParam.header() ? new QName(namespaceURI, webParam.name()) : new QName(webParam.name());
            }
        }
        if (xmlName == null && opMetaData.isDocumentBare()) {
            xmlName = new QName(namespaceURI, opMetaData.getXmlName().getLocalPart());
        }
        if (xmlName == null) {
            WSDLUtils wsdlUtils = WSDLUtils.getInstance();
            String shortName = wsdlUtils.getJustClassName(javaType);
            Integer index = typeIndexes.get(shortName);
            index = index != null ? new Integer(index + 1) : new Integer(1);
            typeIndexes.put(shortName, index);
            xmlName = opMetaData.isDocumentWrapped() ? new QName(namespaceURI, shortName + "_" + index) : new QName(shortName + "_" + index);
        }
        return xmlName;
    }

    private QName getWebParamType(OperationMetaData opMetaData, Class javaType) {
        String namespaceURI = opMetaData.getXmlName().getNamespaceURI();
        return ToolsUtils.getXMLType(javaType, namespaceURI);
    }

    private QName getWebResultName(OperationMetaData opMetaData, Class javaType, WebResult anWebResult) {
        QName xmlName = null;
        String namespaceURI = opMetaData.getXmlName().getNamespaceURI();
        if (anWebResult != null) {
            if (anWebResult.targetNamespace().length() > 0) {
                namespaceURI = anWebResult.targetNamespace();
            }
            if (anWebResult.name().length() > 0) {
                xmlName = opMetaData.getStyle() != Style.RPC ? new QName(namespaceURI, anWebResult.name()) : new QName(anWebResult.name());
            }
        }
        if (xmlName == null && opMetaData.isDocumentBare()) {
            xmlName = new QName(namespaceURI, opMetaData.getResponseName().getLocalPart());
        }
        if (xmlName == null) {
            xmlName = new QName("result");
        }
        return xmlName;
    }

    private void addFault(OperationMetaData omd, TypesMetaData tmd, Class<?> exception) {
        if (omd.isOneWayOperation()) {
            throw new IllegalStateException("JSR-181 4.3.1 - A JSR-181 processor is REQUIRED to report an error if an operation marked @Oneway has a return value, declares any checked exceptions or has any INOUT or OUT parameters.");
        }
        String name = WSDLUtils.getInstance().getJustClassName(exception);
        QName xmlName = new QName(omd.getXmlName().getNamespaceURI(), name);
        FaultMetaData fmd = new FaultMetaData(omd, xmlName, xmlName, exception.getName());
        omd.addFault(fmd);
        TypeMappingMetaData mapping = new TypeMappingMetaData(tmd, xmlName, exception.getName());
        tmd.addTypeMapping(mapping);
    }

    private QName getWebResultType(String defaultNS, Class javaType) {
        return ToolsUtils.getXMLType(javaType, defaultNS);
    }

    private void processOpMetaExtensions(ServerEndpointMetaData epMetaData, OperationMetaData opMetaData) {
        String tns = epMetaData.getName().getNamespaceURI();
        String portTypeName = epMetaData.getName().getLocalPart();
        AddressingPropertiesImpl ADDR = new AddressingPropertiesImpl();
        AddressingOpMetaExt addrExt = new AddressingOpMetaExt(ADDR.getNamespaceURI());
        addrExt.setInboundAction(tns + "/" + portTypeName + "/IN");
        if (!opMetaData.isOneWayOperation()) {
            addrExt.setOutboundAction(tns + "/" + portTypeName + "/OUT");
        }
        opMetaData.addExtension(addrExt);
    }
}

