/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.deployment;

import java.util.Iterator;
import javax.jws.WebService;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.deployment.JSR181MetaDataBuilder;
import org.jboss.ws.deployment.UnifiedDeploymentInfo;
import org.jboss.ws.metadata.UnifiedMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedApplicationMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedBeanMetaData;

public class JSR181MetaDataBuilderEJB21
extends JSR181MetaDataBuilder {
    private final Logger log = Logger.getLogger(JSR181MetaDataBuilderEJB21.class);

    public UnifiedMetaData buildMetaData(UnifiedDeploymentInfo udi) {
        this.log.debug((Object)("START buildMetaData: [name=" + udi.getCanonicalName() + "]"));
        try {
            UnifiedMetaData wsMetaData = new UnifiedMetaData();
            wsMetaData.setResourceLoader(this.resourceLoader);
            wsMetaData.setClassLoader(this.classLoader);
            if (udi.annotationsCl == null) {
                throw new WSException("Annotations class loader not initialized");
            }
            UnifiedApplicationMetaData appMetaData = (UnifiedApplicationMetaData)udi.metaData;
            Iterator<UnifiedBeanMetaData> it = appMetaData.getEnterpriseBeans();
            while (it.hasNext()) {
                UnifiedBeanMetaData beanMetaData = it.next();
                String ejbName = beanMetaData.getEjbName();
                String ejbClassName = beanMetaData.getEjbClass();
                Class<?> beanClass = udi.annotationsCl.loadClass(ejbClassName);
                if (!beanClass.isAnnotationPresent(WebService.class)) continue;
                this.setupEndpointFromAnnotations(wsMetaData, udi, beanClass, ejbName);
            }
            this.log.debug((Object)("END buildMetaData: " + wsMetaData));
            return wsMetaData;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
        }
    }
}

