/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.eventing.mgmt;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.ws.WSException;
import org.jboss.ws.eventing.EventingConstants;
import org.jboss.ws.eventing.deployment.EventingEndpointDI;
import org.jboss.ws.eventing.mgmt.EventSource;

public class EventingBuilder {
    private EventingBuilder() {
    }

    public static EventingBuilder createEventingBuilder() {
        return new EventingBuilder();
    }

    public EventSource newEventSource(EventingEndpointDI desc) {
        URI eventSourceNS = this.newEventSourceURI(desc.getName());
        EventSource eventSource = new EventSource(desc.getName(), eventSourceNS, (String)desc.getSchema());
        eventSource.getSupportedFilterDialects().add(EventingConstants.getDefaultFilterDialect());
        return eventSource;
    }

    public URI newEventSourceURI(String name) {
        try {
            return new URI(name);
        }
        catch (URISyntaxException e) {
            throw new WSException("Failed to create eventsource URI: " + e.getMessage());
        }
    }
}

