/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerRegistry;
import org.jboss.ws.deployment.JSR109ClientMetaDataBuilder;
import org.jboss.ws.jaxrpc.CallImpl;
import org.jboss.ws.jaxrpc.CallProxy;
import org.jboss.ws.jaxrpc.HandlerRegistryImpl;
import org.jboss.ws.jaxrpc.MetaDataSynchronization;
import org.jboss.ws.jaxrpc.ServiceExt;
import org.jboss.ws.jaxrpc.StubExt;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedServiceRefMetaData;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;

public class ServiceImpl
implements ServiceExt {
    private ServiceMetaData serviceMetaData;
    private URL wsdlLocation;
    private HandlerRegistryImpl handlerRegistry;

    ServiceImpl(QName serviceName) {
        UnifiedMetaData wsMetaData = new UnifiedMetaData();
        this.serviceMetaData = new ServiceMetaData(wsMetaData, serviceName);
        this.handlerRegistry = new HandlerRegistryImpl();
    }

    ServiceImpl(QName serviceName, URL wsdlURL, URL mappingURL, URL securityURL) {
        this.wsdlLocation = wsdlURL;
        JSR109ClientMetaDataBuilder builder = new JSR109ClientMetaDataBuilder();
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        builder.setResourceLoader(new URLClassLoader(new URL[0], ctxClassLoader));
        builder.setClassLoader(ctxClassLoader);
        this.serviceMetaData = builder.buildMetaData(serviceName, wsdlURL, mappingURL, securityURL, null);
        this.handlerRegistry = new HandlerRegistryImpl();
    }

    ServiceImpl(QName serviceName, URL wsdlURL, JavaWsdlMapping mappingURL, WSSecurityConfiguration securityConfig, UnifiedServiceRefMetaData serviceRefMetaData) {
        this.wsdlLocation = wsdlURL;
        JSR109ClientMetaDataBuilder builder = new JSR109ClientMetaDataBuilder();
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        builder.setResourceLoader(new URLClassLoader(new URL[0], ctxClassLoader));
        builder.setClassLoader(ctxClassLoader);
        this.serviceMetaData = builder.buildMetaData(serviceName, wsdlURL, mappingURL, securityConfig, serviceRefMetaData);
        this.handlerRegistry = new HandlerRegistryImpl();
    }

    public ServiceMetaData getServiceMetaData() {
        return this.serviceMetaData;
    }

    public URL getWSDLDocumentLocation() {
        return this.wsdlLocation;
    }

    public QName getServiceName() {
        return this.serviceMetaData.getName();
    }

    public Call createCall(QName portName) throws ServiceException {
        String nsURI = portName.getNamespaceURI();
        this.serviceMetaData.assertTargetNamespace(nsURI);
        return new CallImpl(this, portName, null);
    }

    public Call createCall(QName portName, String operationName) throws ServiceException {
        String nsURI = portName.getNamespaceURI();
        this.serviceMetaData.assertTargetNamespace(nsURI);
        QName opName = new QName(nsURI, operationName);
        return new CallImpl(this, portName, opName);
    }

    public Call createCall(QName portName, QName opName) throws ServiceException {
        this.serviceMetaData.assertTargetNamespace(portName.getNamespaceURI());
        this.serviceMetaData.assertTargetNamespace(opName.getNamespaceURI());
        return new CallImpl(this, portName, opName);
    }

    public Call createCall() throws ServiceException {
        return new CallImpl(this);
    }

    public Call[] getCalls(QName portName) throws ServiceException {
        EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(portName);
        if (epMetaData == null) {
            throw new ServiceException("Cannot find endpoint for name: " + portName);
        }
        ArrayList<Call> calls = new ArrayList<Call>();
        for (OperationMetaData opMetaData : epMetaData.getOperations()) {
            Call call = this.createCall(portName, opMetaData.getXmlName());
            calls.add(call);
        }
        Call[] callArr = new Call[calls.size()];
        calls.toArray(callArr);
        return callArr;
    }

    public HandlerRegistry getHandlerRegistry() {
        throw new UnsupportedOperationException("Components should not use the getHandlerRegistry() method.");
    }

    public HandlerRegistry getDynamicHandlerRegistry() {
        return this.handlerRegistry;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        throw new UnsupportedOperationException("Components should not use the getTypeMappingRegistry() method.");
    }

    public Iterator getPorts() throws ServiceException {
        ArrayList<QName> list = new ArrayList<QName>();
        if (this.serviceMetaData != null) {
            for (EndpointMetaData epMetaData : this.serviceMetaData.getEndpoints()) {
                list.add(epMetaData.getName());
            }
        }
        return list.iterator();
    }

    public Remote getPort(Class seiClass) throws ServiceException {
        if (seiClass == null) {
            throw new IllegalArgumentException("SEI class cannot be null");
        }
        String seiName = seiClass.getName();
        if (!Remote.class.isAssignableFrom(seiClass)) {
            throw new ServiceException("SEI does not implement java.rmi.Remote: " + seiName);
        }
        if (this.serviceMetaData == null) {
            throw new ServiceException("Service meta data not available");
        }
        EndpointMetaData epMetaData = this.serviceMetaData.getEndpointByServiceEndpointInterface(seiName);
        if (epMetaData == null && this.serviceMetaData.getEndpoints().size() == 1) {
            epMetaData = this.serviceMetaData.getEndpoints().get(0);
            epMetaData.setServiceEndpointInterfaceName(seiName);
        }
        if (epMetaData == null) {
            throw new ServiceException("Cannot find endpoint meta data for: " + seiName);
        }
        return this.createProxy(seiClass, epMetaData);
    }

    public Remote getPort(QName portName, Class seiClass) throws ServiceException {
        if (seiClass == null) {
            throw new IllegalArgumentException("SEI class cannot be null");
        }
        if (this.serviceMetaData == null) {
            throw new ServiceException("Service meta data not available");
        }
        String seiName = seiClass.getName();
        if (!Remote.class.isAssignableFrom(seiClass)) {
            throw new ServiceException("SEI does not implement java.rmi.Remote: " + seiName);
        }
        EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(portName);
        if (epMetaData == null) {
            throw new ServiceException("Cannot obtain endpoint meta data for: " + portName);
        }
        if (epMetaData.getServiceEndpointInterfaceName() == null) {
            epMetaData.setServiceEndpointInterfaceName(seiName);
        }
        return this.createProxy(seiClass, epMetaData);
    }

    private Remote createProxy(Class seiClass, EndpointMetaData epMetaData) throws ServiceException {
        try {
            MetaDataSynchronization.synchronizeServiceEndpointInterface(epMetaData, seiClass);
            CallImpl call = new CallImpl(this, epMetaData);
            CallProxy handler = new CallProxy(call);
            ClassLoader cl = epMetaData.getClassLoader();
            Remote proxy = (Remote)Proxy.newProxyInstance(cl, new Class[]{seiClass, StubExt.class}, (InvocationHandler)handler);
            return proxy;
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServiceException("Cannot create proxy", ex);
        }
    }

    public HandlerChain getHandlerChain(QName portName) {
        return this.handlerRegistry.getHandlerChainInstance(portName);
    }

    public void registerHandlerChain(QName portName, List infos, Set roles) {
        this.handlerRegistry.registerClientHandlerChain(portName, infos, roles);
    }
}

