/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Service;
import javax.xml.rpc.handler.HandlerInfo;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.ServiceExt;
import org.jboss.ws.jaxrpc.ServiceImpl;
import org.jboss.ws.jaxrpc.ServiceProxy;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedHandlerMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedInitParamMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedPortComponentRefMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedServiceRefMetaData;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.ws.server.ServiceEndpoint;
import org.jboss.ws.server.ServiceEndpointManager;
import org.jboss.ws.server.ServiceEndpointManagerFactory;

public class ServiceObjectFactory
implements ObjectFactory {
    private static final Logger log = Logger.getLogger(ServiceObjectFactory.class);

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        try {
            Class<?> siClass;
            ClassLoader contextCL;
            ByteArrayInputStream bais;
            UnifiedServiceRefMetaData serviceRefMetaData;
            Reference ref;
            block23: {
                ref = (Reference)obj;
                serviceRefMetaData = null;
                RefAddr metaRefAddr = ref.get("SERVICE_REF_META_DATA");
                bais = new ByteArrayInputStream((byte[])metaRefAddr.getContent());
                try {
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    serviceRefMetaData = (UnifiedServiceRefMetaData)ois.readObject();
                    ois.close();
                }
                catch (IOException e) {
                    throw new NamingException("Cannot unmarshall service ref meta data, cause: " + e.toString());
                }
                contextCL = Thread.currentThread().getContextClassLoader();
                URL url = new URL((String)ref.get("DEPLOYMENT_URL").getContent());
                URLClassLoader resourceCL = new URLClassLoader(new URL[]{url}, contextCL);
                serviceRefMetaData.setResourceCL(resourceCL);
                String configFile = serviceRefMetaData.getConfigFile();
                if (configFile != null) {
                    try {
                        new URL(configFile);
                    }
                    catch (MalformedURLException ex) {
                        URL configURL = resourceCL.getResource(configFile);
                        if (configURL == null) break block23;
                        configFile = configURL.toExternalForm();
                        serviceRefMetaData.setConfigFile(configFile);
                    }
                }
            }
            WSSecurityConfiguration securityConfig = null;
            RefAddr wsseRefAddr = ref.get("SECURITY_CONFIG");
            if (wsseRefAddr != null) {
                bais = new ByteArrayInputStream((byte[])wsseRefAddr.getContent());
                try {
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    securityConfig = (WSSecurityConfiguration)ois.readObject();
                    ois.close();
                }
                catch (IOException e) {
                    throw new NamingException("Cannot unmarshall security config, cause: " + e.toString());
                }
            }
            ServiceImpl jaxrpcService = null;
            URL wsdlURL = serviceRefMetaData.getWsdlURL();
            if (wsdlURL != null) {
                log.debug((Object)"Create jaxrpc service from wsdl");
                QName serviceName = serviceRefMetaData.getServiceQName();
                JavaWsdlMapping javaWsdlMapping = (JavaWsdlMapping)serviceRefMetaData.getJavaWsdlMapping();
                jaxrpcService = new ServiceImpl(serviceName, wsdlURL, javaWsdlMapping, securityConfig, serviceRefMetaData);
                ServiceMetaData serviceMetaData = jaxrpcService.getServiceMetaData();
                for (UnifiedPortComponentRefMetaData pcRefMetaData : serviceRefMetaData.getPortComponentRefs()) {
                    String seiName = pcRefMetaData.getServiceEndpointInterface();
                    for (EndpointMetaData epMetaData : serviceMetaData.getEndpoints()) {
                        String epSEIName = epMetaData.getServiceEndpointInterfaceName();
                        if (!seiName.equals(epSEIName) && epSEIName != null) continue;
                        epMetaData.setServiceEndpointInterfaceName(seiName);
                        epMetaData.setProperties(pcRefMetaData.getCallProperties());
                    }
                }
            } else {
                log.debug((Object)"Create jaxrpc service with no wsdl");
                jaxrpcService = new ServiceImpl(new QName("http://www.jboss.org/jbossws", "AnonymousService"));
            }
            ServiceMetaData serviceMetaData = jaxrpcService.getServiceMetaData();
            serviceMetaData.setProperties(serviceRefMetaData.getCallProperties());
            RefAddr pcLinkRef = ref.get("PORT_COMPONENT_LINK");
            if (pcLinkRef != null) {
                String pcLink = (String)pcLinkRef.getContent();
                log.debug((Object)("Resolving port-component-link: " + pcLink));
                String endpointAddress = null;
                try {
                    ServiceEndpointManagerFactory factory = ServiceEndpointManagerFactory.getInstance();
                    ServiceEndpointManager epManager = factory.getServiceEndpointManager();
                    ServiceEndpoint serviceEndpoint = epManager.resolvePortComponentLink(pcLink);
                    if (serviceEndpoint == null) {
                        throw new WSException("Cannot resolve port-component-link: " + pcLink);
                    }
                    endpointAddress = serviceEndpoint.getServiceEndpointInfo().getServerEndpointMetaData().getEndpointAddress();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (endpointAddress == null) {
                    String servletPath = (String)ref.get("PORT_COMPONENT_LINK_SERVLET").getContent();
                    servletPath = servletPath + "?pcLink=" + URLEncoder.encode(pcLink, "UTF-8");
                    InputStream is = new URL(servletPath).openStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    endpointAddress = br.readLine();
                    is.close();
                }
                log.debug((Object)("Resolved to: " + endpointAddress));
                if (serviceMetaData.getEndpoints().size() == 1) {
                    EndpointMetaData epMetaData = serviceMetaData.getEndpoints().get(0);
                    epMetaData.setEndpointAddress(endpointAddress);
                } else {
                    log.warn((Object)"Cannot set endpoint address for port-component-link, unsuported number of endpoints");
                }
            }
            if (!Service.class.isAssignableFrom(siClass = contextCL.loadClass(serviceRefMetaData.getServiceInterface()))) {
                throw new JAXRPCException("The service interface does not implement javax.xml.rpc.Service: " + siClass.getName());
            }
            UnifiedPortComponentRefMetaData[] pcrArray = serviceRefMetaData.getPortComponentRefs();
            for (int i = 0; i < pcrArray.length; ++i) {
                UnifiedPortComponentRefMetaData pcr = pcrArray[i];
                Class<?> seiClass = contextCL.loadClass(pcr.getServiceEndpointInterface());
                if (Remote.class.isAssignableFrom(seiClass)) continue;
                throw new IllegalArgumentException("The SEI does not implement java.rmi.Remote: " + seiClass.getName());
            }
            this.setupHandlerChain(jaxrpcService, serviceRefMetaData);
            ServiceProxy handler = new ServiceProxy(jaxrpcService, siClass);
            return Proxy.newProxyInstance(contextCL, new Class[]{siClass, ServiceExt.class}, (InvocationHandler)handler);
        }
        catch (Exception ex) {
            log.error((Object)"Cannot create service", (Throwable)ex);
            throw ex;
        }
    }

    private void setupHandlerChain(ServiceImpl jaxrpcService, UnifiedServiceRefMetaData serviceRefMetaData) throws Exception {
        List<EndpointMetaData> endpoints = jaxrpcService.getServiceMetaData().getEndpoints();
        for (EndpointMetaData epMetaData : endpoints) {
            QName portName = epMetaData.getName();
            HashSet<String> handlerRoles = new HashSet<String>();
            ArrayList<HandlerInfo> handlerInfos = new ArrayList<HandlerInfo>();
            for (UnifiedHandlerMetaData hMetaData : epMetaData.getHandlers(UnifiedHandlerMetaData.HandlerType.ALL)) {
                handlerRoles.addAll(Arrays.asList(hMetaData.getSoapRoles()));
                ClassLoader cl = epMetaData.getClassLoader();
                Class<?> hClass = cl.loadClass(hMetaData.getHandlerClass());
                HashMap<String, String> hConfig = new HashMap<String, String>();
                UnifiedInitParamMetaData[] params = hMetaData.getInitParams();
                for (int k = 0; k < params.length; ++k) {
                    UnifiedInitParamMetaData param = params[k];
                    hConfig.put(param.getParamName(), param.getParamValue());
                }
                QName[] hHeaders = hMetaData.getSoapHeaders();
                HandlerInfo info = new HandlerInfo(hClass, hConfig, hHeaders);
                log.debug((Object)("Adding client side handler to endpoint '" + portName + "': " + info));
                handlerInfos.add(info);
                if (handlerInfos.size() <= 0) continue;
                jaxrpcService.registerHandlerChain(portName, handlerInfos, handlerRoles);
            }
        }
    }
}

