/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc.encoding;

import java.io.StringWriter;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSModel;
import org.jboss.logging.Logger;
import org.jboss.ws.binding.BindingException;
import org.jboss.ws.jaxb.JAXBMarshaller;
import org.jboss.ws.jaxb.JBossXBMarshallerImpl;
import org.jboss.ws.jaxb.XercesXSMarshallerImpl;
import org.jboss.ws.jaxrpc.encoding.SerializationContextImpl;
import org.jboss.ws.jaxrpc.encoding.SerializerSupport;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.w3c.dom.NamedNodeMap;

public class JAXBSerializer
extends SerializerSupport {
    private static final Logger log = Logger.getLogger(JAXBSerializer.class);
    private JAXBMarshaller marshaller = new JBossXBMarshallerImpl();

    public String serialize(QName xmlName, QName xmlType, Object value, SerializationContextImpl serContext, NamedNodeMap attributes) throws BindingException {
        log.debug((Object)("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]"));
        try {
            String xmlFragment = null;
            XSModel model = serContext.getXsModel();
            JavaWsdlMapping jaxrpcMapping = serContext.getJavaWsdlMapping();
            StringWriter strwr = new StringWriter();
            JAXBMarshaller delegate = this.marshaller;
            if (value instanceof Exception) {
                delegate = new XercesXSMarshallerImpl();
            }
            delegate.setProperty("org.jboss.jaxb.xsd.xsmodel", model);
            delegate.setProperty("org.jboss.jaxb.type.qname", xmlType);
            delegate.setProperty("org.jboss.jaxb.root.qname", xmlName);
            delegate.setProperty("org.jboss.jaxb.java.mapping", jaxrpcMapping);
            delegate.marshal(value, strwr);
            xmlFragment = strwr.toString();
            log.debug((Object)("serialized: " + xmlFragment));
            return xmlFragment;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }
}

