/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc.encoding;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMUtils;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.WSException;
import org.jboss.ws.binding.BindingException;
import org.jboss.ws.jaxrpc.TypeMappingImpl;
import org.jboss.ws.jaxrpc.encoding.DeserializerFactoryBase;
import org.jboss.ws.jaxrpc.encoding.DeserializerSupport;
import org.jboss.ws.jaxrpc.encoding.SerializationContextImpl;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.utils.JavaUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPArrayDeserializer
extends DeserializerSupport {
    private static final Logger log = Logger.getLogger(SOAPArrayDeserializer.class);
    private DeserializerSupport compDeserializer;

    public Object deserialize(QName xmlName, QName xmlType, String xmlFragment, SerializationContextImpl serContext) throws BindingException {
        log.debug((Object)("deserialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]"));
        try {
            ParameterMetaData paramMetaData = (ParameterMetaData)serContext.getProperty("org.jboss.ws.metadata.ParameterMetaData");
            QName compXmlType = paramMetaData.getSOAPArrayCompType();
            QName compXmlName = paramMetaData.getXmlName();
            Element arrayElement = DOMUtils.parse((String)xmlFragment);
            int[] arrDims = this.getDimensionsFromAttribute(arrayElement);
            Class compJavaType = this.getComponentTypeFromAttribute(arrayElement, serContext);
            Object[] retArray = (Object[])Array.newInstance(compJavaType, arrDims);
            TypeMappingImpl typeMapping = serContext.getTypeMapping();
            if (compXmlType == null) {
                compXmlType = typeMapping.getXMLType(compJavaType);
                paramMetaData.setSOAPArrayCompType(compXmlType);
            }
            if (compXmlType == null) {
                throw new WSException("Cannot obtain component xmlType for: " + compJavaType);
            }
            log.debug((Object)("Get component deserializer for: [javaType=" + compJavaType.getName() + ",xmlType=" + compXmlType + "]"));
            DeserializerFactoryBase compDeserializerFactory = (DeserializerFactoryBase)typeMapping.getDeserializer(compJavaType, compXmlType);
            if (compDeserializerFactory == null) {
                log.warn((Object)("Cannot obtain component deserializer for: [javaType=" + compJavaType.getName() + ",xmlType=" + compXmlType + "]"));
                compDeserializerFactory = (DeserializerFactoryBase)typeMapping.getDeserializer(null, compXmlType);
            }
            if (compDeserializerFactory == null) {
                throw new WSException("Cannot obtain component deserializer for: " + compXmlType);
            }
            this.compDeserializer = compDeserializerFactory.getDeserializer();
            if (arrDims.length < 1 || 2 < arrDims.length) {
                throw new WSException("Unsupported array dimensions: " + Arrays.asList(new int[][]{arrDims}));
            }
            Iterator it = DOMUtils.getChildElements((Node)arrayElement);
            if (arrDims.length == 1) {
                Object[] subArr = retArray;
                this.deserializeMemberValues(compXmlName, compXmlType, serContext, it, subArr);
            }
            if (arrDims.length == 2) {
                for (int i = 0; i < arrDims[0]; ++i) {
                    Object[] subArr = (Object[])retArray[i];
                    this.deserializeMemberValues(compXmlName, compXmlType, serContext, it, subArr);
                }
            }
            log.debug((Object)("deserialized: " + retArray.getClass().getName()));
            return retArray;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    private void deserializeMemberValues(QName compXmlName, QName compXmlType, SerializationContextImpl serContext, Iterator it, Object[] subArr) throws BindingException {
        int dim = subArr.length;
        for (int i = 0; i < dim; ++i) {
            Object compValue = null;
            if (it.hasNext()) {
                Element childElement = (Element)it.next();
                String compXMLFragment = DOMWriter.printNode((Node)childElement, (boolean)false);
                compValue = this.compDeserializer.deserialize(compXmlName, compXmlType, compXMLFragment, serContext);
                compValue = JavaUtils.getWrapperValue(compValue);
            }
            subArr[i] = compValue;
        }
    }

    private int[] getDimensionsFromAttribute(Element arrayElement) {
        QName attrQName = new QName("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
        QName arrayType = DOMUtils.getAttributeValueAsQName((Element)arrayElement, (QName)attrQName);
        if (arrayType == null) {
            throw new WSException("Cannot obtain attribute: " + attrQName);
        }
        String localPart = arrayType.getLocalPart();
        int dimIndex = localPart.indexOf("[");
        String dimStr = localPart.substring(dimIndex);
        StringTokenizer st = new StringTokenizer(dimStr, "[,]");
        int[] arrDims = new int[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            arrDims[i] = new Integer(st.nextToken());
            ++i;
        }
        return arrDims;
    }

    private Class getComponentTypeFromAttribute(Element arrayElement, SerializationContextImpl serContext) {
        QName attrQName = new QName("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
        QName arrayType = DOMUtils.getAttributeValueAsQName((Element)arrayElement, (QName)attrQName);
        if (arrayType == null) {
            throw new WSException("Cannot obtain attribute: " + attrQName);
        }
        String nsURI = arrayType.getNamespaceURI();
        String localPart = arrayType.getLocalPart();
        int dimIndex = localPart.indexOf("[");
        QName compXmlType = new QName(nsURI, localPart.substring(0, dimIndex));
        TypeMappingImpl typeMapping = serContext.getTypeMapping();
        Class javaType = typeMapping.getJavaType(compXmlType);
        if (javaType == null) {
            throw new WSException("Cannot obtain javaType for: " + compXmlType);
        }
        return JavaUtils.getWrapperType(javaType);
    }
}

