/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.Style;
import org.jboss.ws.jaxrpc.Use;
import org.jboss.ws.metadata.ExtensibleMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedHandlerMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EndpointMetaData
extends ExtensibleMetaData {
    private static Logger log = Logger.getLogger(EndpointMetaData.class);
    private ServiceMetaData service;
    private QName name;
    private String configName;
    private String configFile;
    private String endpointAddress;
    private String seiName;
    private String authMethod;
    private String transportGuarantee;
    private Properties properties;
    private Style style;
    private Use use;
    private SOAPBinding.ParameterStyle parameterStyle;
    private List<OperationMetaData> operations = new ArrayList<OperationMetaData>();
    private List<UnifiedHandlerMetaData> jaxrpcHandlers = new ArrayList<UnifiedHandlerMetaData>();

    public EndpointMetaData(ServiceMetaData service, QName name) {
        this.service = service;
        this.name = name;
    }

    public ServiceMetaData getServiceMetaData() {
        return this.service;
    }

    public QName getName() {
        return this.name;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public String getEndpointAddress() {
        return this.endpointAddress;
    }

    public void setEndpointAddress(String endpointAddress) {
        this.endpointAddress = endpointAddress;
    }

    public String getServiceEndpointInterfaceName() {
        return this.seiName;
    }

    public void setServiceEndpointInterfaceName(String endpointInterfaceName) {
        this.seiName = endpointInterfaceName;
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader = this.getServiceMetaData().getUnifiedMetaData().getClassLoader();
        return classLoader;
    }

    public URLClassLoader getResourceLoader() {
        URLClassLoader classLoader = this.getServiceMetaData().getUnifiedMetaData().getResourceLoader();
        return classLoader;
    }

    public Class getServiceEndpointInterface() {
        String seiName = this.getServiceEndpointInterfaceName();
        if (seiName == null) {
            throw new WSException("ServiceEndpointInterface name not available");
        }
        Class<?> seiClass = null;
        try {
            ClassLoader classLoader = this.getClassLoader();
            if (classLoader == null) {
                throw new WSException("Class loader not available");
            }
            seiClass = classLoader.loadClass(seiName);
        }
        catch (ClassNotFoundException ex) {
            throw new WSException("Cannot load SEI: " + seiName, ex);
        }
        return seiClass;
    }

    public Use getEncodingStyle() {
        if (this.use == null) {
            this.use = Use.getDefaultUse();
        }
        return this.use;
    }

    public void setEncodingStyle(Use encStyle) {
        if (this.use != null && !this.use.equals(encStyle)) {
            throw new WSException("Mixed encoding styles not supported");
        }
        this.use = encStyle;
    }

    public Style getStyle() {
        if (this.style == null) {
            this.style = Style.getDefaultStyle();
            log.warn((Object)("Cannot obtain style, using default: " + this.style));
        }
        return this.style;
    }

    public void setStyle(Style styleValue) {
        if (this.style != null && !this.style.equals(styleValue)) {
            throw new WSException("Mixed styles not supported");
        }
        this.style = styleValue;
    }

    public SOAPBinding.ParameterStyle getParameterStyle() {
        if (this.parameterStyle == null) {
            this.parameterStyle = SOAPBinding.ParameterStyle.WRAPPED;
        }
        return this.parameterStyle;
    }

    public void setParameterStyle(SOAPBinding.ParameterStyle styleValue) {
        if (this.parameterStyle != null && !this.parameterStyle.equals((Object)styleValue)) {
            throw new WSException("Mixed SOAP parameter styles not supported");
        }
        this.parameterStyle = styleValue;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public String getTransportGuarantee() {
        return this.transportGuarantee;
    }

    public void setTransportGuarantee(String transportGuarantee) {
        this.transportGuarantee = transportGuarantee;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public List<OperationMetaData> getOperations() {
        return new ArrayList<OperationMetaData>(this.operations);
    }

    public OperationMetaData getOperation(QName xmlName) {
        OperationMetaData opMetaData = null;
        for (OperationMetaData auxOperation : this.operations) {
            QName opQName = auxOperation.getXmlName();
            if (!opQName.equals(xmlName)) continue;
            if (opMetaData == null) {
                opMetaData = auxOperation;
                continue;
            }
            throw new WSException("Cannot uniquely indetify operation: " + xmlName);
        }
        if (opMetaData == null && this.getStyle() == Style.DOCUMENT) {
            for (OperationMetaData auxOperation : this.operations) {
                ParameterMetaData paramMetaData = null;
                for (ParameterMetaData auxParam : auxOperation.getParameters()) {
                    ParameterMode mode = auxParam.getMode();
                    if (auxParam.isInHeader() || mode != ParameterMode.IN) continue;
                    paramMetaData = auxParam;
                    break;
                }
                if (paramMetaData == null || !paramMetaData.getXmlName().equals(xmlName)) continue;
                if (opMetaData == null) {
                    opMetaData = auxOperation;
                    continue;
                }
                throw new WSException("Cannot uniquely indetify operation: " + xmlName);
            }
        }
        return opMetaData;
    }

    public OperationMetaData getOperation(Method method) {
        OperationMetaData opMetaData = null;
        for (OperationMetaData aux : this.operations) {
            if (!aux.getJavaMethod().equals(method)) continue;
            opMetaData = aux;
        }
        return opMetaData;
    }

    public void addOperation(OperationMetaData opMetaData) {
        this.operations.add(opMetaData);
    }

    public void addHandler(UnifiedHandlerMetaData handler) {
        this.jaxrpcHandlers.add(handler);
    }

    public List<UnifiedHandlerMetaData> getHandlers(UnifiedHandlerMetaData.HandlerType type) {
        if (type == UnifiedHandlerMetaData.HandlerType.PRE || type == UnifiedHandlerMetaData.HandlerType.POST) {
            throw new IllegalArgumentException("Illegal handler type: " + (Object)((Object)type));
        }
        return new ArrayList<UnifiedHandlerMetaData>(this.jaxrpcHandlers);
    }

    public void eagerInitialize() {
        for (OperationMetaData operation : this.operations) {
            operation.eagerInitialize();
        }
    }
}

