/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.jsr109;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.metadata.j2ee.UnifiedHandlerMetaData;
import org.jboss.ws.metadata.jsr109.WebserviceDescriptionMetaData;

public class PortComponentMetaData {
    public static final String PARAMETER_WEBSERVICE_ID = "webserviceID";
    private static final Logger log = Logger.getLogger(PortComponentMetaData.class);
    private WebserviceDescriptionMetaData webserviceDescription;
    private String portComponentName;
    private QName wsdlPort;
    private String serviceEndpointInterface;
    private String ejbLink;
    private String servletLink;
    private List<UnifiedHandlerMetaData> handlers = new ArrayList<UnifiedHandlerMetaData>();
    private String contextRoot;

    public PortComponentMetaData(WebserviceDescriptionMetaData webserviceDescription) {
        this.webserviceDescription = webserviceDescription;
    }

    public WebserviceDescriptionMetaData getWebserviceDescription() {
        return this.webserviceDescription;
    }

    public String getPortComponentName() {
        return this.portComponentName;
    }

    public void setPortComponentName(String portComponentName) {
        this.portComponentName = portComponentName;
    }

    public QName getWsdlPort() {
        return this.wsdlPort;
    }

    public void setWsdlPort(QName wsdlPort) {
        if (wsdlPort.getNamespaceURI().length() == 0) {
            log.warn((Object)("<wsdl-port> element in webservices.xml not namespace qualified: " + wsdlPort));
        }
        this.wsdlPort = wsdlPort;
    }

    public String getEjbLink() {
        return this.ejbLink;
    }

    public void setEjbLink(String ejbLink) {
        this.ejbLink = ejbLink;
    }

    public String getServletLink() {
        return this.servletLink;
    }

    public void setServletLink(String servletLink) {
        this.servletLink = servletLink;
    }

    public String getServiceEndpointInterface() {
        return this.serviceEndpointInterface;
    }

    public void setServiceEndpointInterface(String serviceEndpointInterface) {
        this.serviceEndpointInterface = serviceEndpointInterface;
    }

    public void addHandler(UnifiedHandlerMetaData handler) {
        this.handlers.add(handler);
    }

    public UnifiedHandlerMetaData[] getHandlers() {
        UnifiedHandlerMetaData[] array = new UnifiedHandlerMetaData[this.handlers.size()];
        this.handlers.toArray(array);
        return array;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public String serialize() {
        StringBuilder builder = new StringBuilder("<port-component> <port-component-name>");
        builder.append(this.portComponentName + "</port-component-name><wsdl-port>impl:");
        builder.append(this.wsdlPort.getLocalPart() + "</wsdl-port><service-endpoint-interface>");
        builder.append(this.serviceEndpointInterface);
        builder.append("</service-endpoint-interface>");
        builder.append("<service-impl-bean>");
        if (this.ejbLink != null) {
            builder.append("<ejb-link>");
            builder.append(this.ejbLink);
            builder.append("</ejb-link>");
        } else {
            builder.append("<servlet-link>");
            builder.append(this.servletLink);
            builder.append("</servlet-link>");
        }
        builder.append("</service-impl-bean>");
        builder.append("</port-component>");
        return builder.toString();
    }
}

