/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.ws.metadata.wsdl.WSDLFeature;
import org.jboss.ws.metadata.wsdl.WSDLProperty;

public abstract class Extendable
implements Serializable {
    private Logger log = Logger.getLogger(this.getClass());
    private Map features = new LinkedHashMap();
    private Map properties = new LinkedHashMap();

    public WSDLFeature[] getFeatures() {
        WSDLFeature[] arr = new WSDLFeature[this.features.size()];
        new ArrayList(this.features.values()).toArray(arr);
        return arr;
    }

    public void addFeature(WSDLFeature feature) {
        this.log.trace((Object)("addFeature: " + feature));
        String uri = feature.getURI();
        this.features.put(uri, feature);
    }

    public WSDLFeature getFeature(String uri) {
        WSDLFeature feature = (WSDLFeature)this.features.get(uri);
        return feature;
    }

    public WSDLProperty[] getProperties() {
        WSDLProperty[] arr = new WSDLProperty[this.properties.size()];
        new ArrayList(this.properties.values()).toArray(arr);
        return arr;
    }

    public void addProperty(WSDLProperty property) {
        this.log.trace((Object)("addProperty: " + property));
        String uri = property.getURI();
        this.properties.put(uri, property);
    }

    public WSDLProperty getProperty(String uri) {
        WSDLProperty property = (WSDLProperty)this.properties.get(uri);
        return property;
    }
}

