/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.server.ServletEndpointContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.Constants;
import org.jboss.ws.WSException;
import org.jboss.ws.binding.BindingException;
import org.jboss.ws.handler.ServerHandlerChain;
import org.jboss.ws.jaxrpc.SOAPFaultExceptionHelper;
import org.jboss.ws.metadata.ServerEndpointMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedHandlerMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedInitParamMetaData;
import org.jboss.ws.server.HeaderSource;
import org.jboss.ws.server.ServiceEndpointInfo;
import org.jboss.ws.server.ServiceEndpointInvoker;
import org.jboss.ws.server.ServiceEndpointMetrics;
import org.jboss.ws.server.WSDLRequestHandler;
import org.jboss.ws.soap.MessageContextAssociation;
import org.jboss.ws.soap.MessageFactoryImpl;
import org.jboss.ws.soap.SAAJElementWriter;
import org.jboss.ws.soap.SOAPElementImpl;
import org.jboss.ws.soap.SOAPMessageContextImpl;
import org.jboss.ws.soap.SOAPMessageImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceEndpoint {
    private static Logger log = Logger.getLogger(ServiceEndpoint.class);
    private static Logger msgLog = Logger.getLogger((String)"jbossws.SOAPMessage");
    protected ServiceEndpointInfo seInfo;
    protected ServiceEndpointMetrics seMetrics;

    public ServiceEndpoint(ServiceEndpointInfo seInfo) {
        this.seInfo = seInfo;
        this.seInfo.setState(State.CREATED);
        this.seMetrics = new ServiceEndpointMetrics(seInfo.getServiceEndpointID());
    }

    public ServiceEndpointInfo getServiceEndpointInfo() {
        return this.seInfo;
    }

    public ServiceEndpointMetrics getServiceEndpointMetrics() {
        return this.seMetrics;
    }

    public void create() throws Exception {
        this.seInfo.setState(State.CREATED);
    }

    public void start() throws Exception {
        ServerEndpointMetaData epMetaData = this.seInfo.getServerEndpointMetaData();
        UnifiedMetaData wsMetaData = epMetaData.getServiceMetaData().getUnifiedMetaData();
        wsMetaData.eagerInitialize();
        this.seMetrics.start();
        this.seInfo.setState(State.STARTED);
    }

    public void stop() {
        this.seMetrics.stop();
        this.seInfo.setState(State.STOPED);
        log.debug((Object)("Stop Endpoint" + this.seMetrics));
    }

    public void destroy() {
        this.seInfo.setState(State.DESTROYED);
    }

    public void handleWSDLRequest(OutputStream outStream, URL requestURL, String resourcePath) throws IOException {
        ServiceEndpointInfo sepInfo = this.getServiceEndpointInfo();
        ServerEndpointMetaData epMetaData = sepInfo.getServerEndpointMetaData();
        String urlString = requestURL.toExternalForm();
        String requestURI = requestURL.getPath();
        String hostPath = urlString.substring(0, urlString.indexOf(requestURI));
        WSDLRequestHandler wsdlRequestHandler = new WSDLRequestHandler(epMetaData);
        Document document = wsdlRequestHandler.getDocumentForPath(hostPath, requestURI, resourcePath);
        OutputStreamWriter writer = new OutputStreamWriter(outStream);
        new DOMWriter((Writer)writer).setPrettyprint(true).print((Node)document.getDocumentElement());
        outStream.flush();
        outStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SOAPMessage handleRequest(HeaderSource headerSource, ServletEndpointContext context, InputStream inputStream) throws BindingException {
        boolean popMessageContext = false;
        SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
        if (msgContext == null) {
            msgContext = new SOAPMessageContextImpl();
            MessageContextAssociation.pushMessageContext(msgContext);
            popMessageContext = true;
        }
        ServerEndpointMetaData epMetaData = this.seInfo.getServerEndpointMetaData();
        msgContext.setEndpointMetaData(epMetaData);
        long beginProcessing = 0L;
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        State state = this.seInfo.getState();
        if (state != State.STARTED) {
            QName faultCode = Constants.SOAP11_FAULT_CODE_SERVER;
            String faultString = "Endpoint cannot handle requests in state: " + (Object)((Object)state);
            throw new SOAPFaultException(faultCode, faultString, null, null);
        }
        log.debug((Object)("BEGIN handleRequest: " + this.seInfo.getServiceEndpointID()));
        beginProcessing = this.seMetrics.processRequestMessage();
        if (this.seInfo.getJaxRpcHandlerChain() == null) {
            this.initHandlerChain(UnifiedHandlerMetaData.HandlerType.PRE);
            this.initHandlerChain(UnifiedHandlerMetaData.HandlerType.JAXRPC);
            this.initHandlerChain(UnifiedHandlerMetaData.HandlerType.POST);
        }
        MessageFactoryImpl msgFactory = new MessageFactoryImpl();
        msgFactory.setStyle(epMetaData.getStyle());
        MimeHeaders headers = headerSource != null ? headerSource.getMimeHeaders() : null;
        SOAPMessageImpl reqMessage = (SOAPMessageImpl)msgFactory.createMessage(headers, inputStream);
        msgContext.setMessage(reqMessage);
        if (msgLog.isDebugEnabled()) {
            SOAPEnvelope soapEnv = reqMessage.getSOAPPart().getEnvelope();
            String envStr = SAAJElementWriter.printSOAPElement((SOAPElementImpl)((Object)soapEnv), true);
            msgLog.debug((Object)("Incomming SOAPMessage\n" + envStr));
        }
        ClassLoader classLoader = epMetaData.getClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        ServiceEndpointInvoker seInvoker = this.seInfo.getInvoker();
        SOAPMessage resMessage = seInvoker.invoke(this.seInfo, context);
        this.postProcessResponse(headerSource, resMessage);
        SOAPMessage sOAPMessage = resMessage;
        Object var19_22 = null;
        try {
            SOAPMessage soapMessage = msgContext.getMessage();
            if (soapMessage != null && soapMessage.getSOAPPart().getEnvelope() != null) {
                if (soapMessage.getSOAPPart().getEnvelope().getBody().getFault() != null) {
                    this.seMetrics.processFaultMessage(beginProcessing);
                } else {
                    this.seMetrics.processResponseMessage(beginProcessing);
                }
            }
        }
        catch (Exception ex2) {
            log.error((Object)"Cannot process metrics", (Throwable)ex2);
        }
        if (popMessageContext) {
            MessageContextAssociation.popMessageContext();
        }
        Thread.currentThread().setContextClassLoader(ctxClassLoader);
        log.debug((Object)("END handleRequest: " + this.seInfo.getServiceEndpointID()));
        return sOAPMessage;
        catch (Exception ex) {
            SOAPMessage sOAPMessage2;
            try {
                SOAPMessage resMessage2 = msgContext.getMessage();
                if (resMessage2 == null || !((SOAPMessageImpl)resMessage2).isFaultMessage()) {
                    resMessage2 = SOAPFaultExceptionHelper.exceptionToFaultMessage(ex);
                    msgContext.setMessage(resMessage2);
                }
                this.postProcessResponse(headerSource, resMessage2);
                sOAPMessage2 = resMessage2;
                Object var19_23 = null;
            }
            catch (Throwable throwable) {
                Object var19_24 = null;
                try {
                    SOAPMessage soapMessage = msgContext.getMessage();
                    if (soapMessage != null && soapMessage.getSOAPPart().getEnvelope() != null) {
                        if (soapMessage.getSOAPPart().getEnvelope().getBody().getFault() != null) {
                            this.seMetrics.processFaultMessage(beginProcessing);
                        } else {
                            this.seMetrics.processResponseMessage(beginProcessing);
                        }
                    }
                }
                catch (Exception ex2) {
                    log.error((Object)"Cannot process metrics", (Throwable)ex2);
                }
                if (popMessageContext) {
                    MessageContextAssociation.popMessageContext();
                }
                Thread.currentThread().setContextClassLoader(ctxClassLoader);
                log.debug((Object)("END handleRequest: " + this.seInfo.getServiceEndpointID()));
                throw throwable;
            }
            try {
                SOAPMessage soapMessage = msgContext.getMessage();
                if (soapMessage != null && soapMessage.getSOAPPart().getEnvelope() != null) {
                    if (soapMessage.getSOAPPart().getEnvelope().getBody().getFault() != null) {
                        this.seMetrics.processFaultMessage(beginProcessing);
                    } else {
                        this.seMetrics.processResponseMessage(beginProcessing);
                    }
                }
            }
            catch (Exception ex2) {
                log.error((Object)"Cannot process metrics", (Throwable)ex2);
            }
            if (popMessageContext) {
                MessageContextAssociation.popMessageContext();
            }
            Thread.currentThread().setContextClassLoader(ctxClassLoader);
            log.debug((Object)("END handleRequest: " + this.seInfo.getServiceEndpointID()));
            return sOAPMessage2;
        }
    }

    private void postProcessResponse(HeaderSource headerSource, SOAPMessage resMessage) {
        try {
            if (headerSource != null) {
                resMessage.saveChanges();
                headerSource.setMimeHeaders(resMessage.getMimeHeaders());
            }
            if (msgLog.isDebugEnabled()) {
                resMessage.saveChanges();
                SOAPEnvelope soapEnv = resMessage.getSOAPPart().getEnvelope();
                String envStr = SAAJElementWriter.printSOAPElement((SOAPElementImpl)((Object)soapEnv), true);
                msgLog.debug((Object)("Outgoing SOAPMessage\n" + envStr));
            }
        }
        catch (Exception ex) {
            throw new JAXRPCException("Cannot create or send response message", ex);
        }
    }

    private void initHandlerChain(UnifiedHandlerMetaData.HandlerType type) {
        HashSet<String> handlerRoles = new HashSet<String>();
        ArrayList<HandlerInfo> infos = new ArrayList<HandlerInfo>();
        ServerEndpointMetaData sepMetaData = this.seInfo.getServerEndpointMetaData();
        for (UnifiedHandlerMetaData handlerMetaData : sepMetaData.getHandlers(type)) {
            Class<?> hClass;
            handlerRoles.addAll(Arrays.asList(handlerMetaData.getSoapRoles()));
            String handlerClass = handlerMetaData.getHandlerClass();
            try {
                ClassLoader classLoader = sepMetaData.getClassLoader();
                hClass = classLoader.loadClass(handlerClass);
            }
            catch (ClassNotFoundException e) {
                throw new WSException("Cannot load handler class: " + handlerClass);
            }
            HashMap<String, String> hConfig = new HashMap<String, String>();
            UnifiedInitParamMetaData[] params = handlerMetaData.getInitParams();
            for (int j = 0; j < params.length; ++j) {
                UnifiedInitParamMetaData param = params[j];
                hConfig.put(param.getParamName(), param.getParamValue());
            }
            QName[] hHeaders = handlerMetaData.getSoapHeaders();
            HandlerInfo info = new HandlerInfo(hClass, hConfig, hHeaders);
            log.debug((Object)("Adding server side handler to service '" + sepMetaData.getName() + "': " + info));
            infos.add(info);
        }
        this.initHandlerChain(infos, handlerRoles, type);
    }

    public void initHandlerChain(List<HandlerInfo> infos, Set<String> handlerRoles, UnifiedHandlerMetaData.HandlerType type) {
        log.debug((Object)("Init handler chain with [" + infos.size() + "] handlers"));
        ServerHandlerChain handlerChain = new ServerHandlerChain(infos, handlerRoles, type);
        if (type == UnifiedHandlerMetaData.HandlerType.PRE) {
            this.seInfo.setPreHandlerChain(handlerChain);
        } else if (type == UnifiedHandlerMetaData.HandlerType.JAXRPC) {
            this.seInfo.setJaxRpcHandlerChain(handlerChain);
        } else if (type == UnifiedHandlerMetaData.HandlerType.POST) {
            this.seInfo.setPostHandlerChain(handlerChain);
        }
        if (handlerChain.getState() == 1) {
            handlerChain.init(null);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.seInfo.toString());
        buffer.append("\n state=" + (Object)((Object)this.seInfo.getState()));
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        CREATED,
        STARTED,
        STOPED,
        DESTROYED;

    }
}

