/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.server;

import javax.management.ObjectName;
import org.jboss.ws.WSException;
import org.jboss.ws.deployment.UnifiedDeploymentInfo;
import org.jboss.ws.handler.ServerHandlerChain;
import org.jboss.ws.metadata.ServerEndpointMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedApplicationMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedBeanMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedMessageDrivenMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedSessionMetaData;
import org.jboss.ws.server.ServiceEndpoint;
import org.jboss.ws.server.ServiceEndpointInvoker;

public class ServiceEndpointInfo {
    private UnifiedDeploymentInfo udi;
    private Type type;
    private ServerEndpointMetaData sepMetaData;
    private ServiceEndpointInvoker seInvoker;
    private ServerHandlerChain preHandlerChain;
    private ServerHandlerChain jaxrpcHandlerChain;
    private ServerHandlerChain postHandlerChain;
    private ServiceEndpoint.State state;

    public ServiceEndpointInfo(UnifiedDeploymentInfo udi, ServerEndpointMetaData sepMetaData) {
        this.udi = udi;
        this.sepMetaData = sepMetaData;
        if (udi.type == UnifiedDeploymentInfo.Type.JSR109_JSE || udi.type == UnifiedDeploymentInfo.Type.JSR181_JSE) {
            this.type = Type.JSE;
        } else if (udi.type == UnifiedDeploymentInfo.Type.JSR109_EJB21 || udi.type == UnifiedDeploymentInfo.Type.JSR181_EJB21) {
            String ejbName = sepMetaData.getLinkName();
            if (ejbName == null) {
                throw new WSException("Cannot obtain ejb-link from port component");
            }
            UnifiedApplicationMetaData applMetaData = (UnifiedApplicationMetaData)udi.metaData;
            UnifiedBeanMetaData beanMetaData = applMetaData.getBeanByEjbName(ejbName);
            if (beanMetaData == null) {
                throw new WSException("Cannot obtain ejb meta data for: " + ejbName);
            }
            if (beanMetaData instanceof UnifiedSessionMetaData) {
                this.type = Type.SLSB21;
            } else if (beanMetaData instanceof UnifiedMessageDrivenMetaData) {
                this.type = Type.MDB21;
            }
        } else if (udi.type == UnifiedDeploymentInfo.Type.JSR181_EJB3) {
            this.type = Type.SLSB30;
        }
        if (this.type == null) {
            throw new WSException("Unsupported endpoint type");
        }
    }

    public ServerEndpointMetaData getServerEndpointMetaData() {
        return this.sepMetaData;
    }

    public ObjectName getServiceEndpointID() {
        return this.sepMetaData.getServiceEndpointID();
    }

    public UnifiedDeploymentInfo getUnifiedDeploymentInfo() {
        return this.udi;
    }

    public Type getType() {
        return this.type;
    }

    public ServerHandlerChain getPreHandlerChain() {
        return this.preHandlerChain;
    }

    public void setPreHandlerChain(ServerHandlerChain preHandlerChain) {
        this.preHandlerChain = preHandlerChain;
    }

    public ServerHandlerChain getJaxRpcHandlerChain() {
        return this.jaxrpcHandlerChain;
    }

    public void setJaxRpcHandlerChain(ServerHandlerChain handlerChain) {
        this.jaxrpcHandlerChain = handlerChain;
    }

    public ServerHandlerChain getPostHandlerChain() {
        return this.postHandlerChain;
    }

    public void setPostHandlerChain(ServerHandlerChain postHandlerChain) {
        this.postHandlerChain = postHandlerChain;
    }

    public ServiceEndpointInvoker getInvoker() {
        return this.seInvoker;
    }

    public void setInvoker(ServiceEndpointInvoker seInvoker) {
        this.seInvoker = seInvoker;
    }

    public ServiceEndpoint.State getState() {
        return this.state;
    }

    public void setState(ServiceEndpoint.State state) {
        this.state = state;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("[id=" + this.getServiceEndpointID() + "state=" + (Object)((Object)this.state) + "]");
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        JSE,
        SLSB21,
        SLSB30,
        MDB21;

    }
}

