/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.server;

import java.lang.reflect.Method;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.server.ServiceLifecycle;
import javax.xml.rpc.server.ServletEndpointContext;
import javax.xml.rpc.soap.SOAPFaultException;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.binding.EndpointInvocation;
import org.jboss.ws.metadata.ServerEndpointMetaData;
import org.jboss.ws.server.ServiceEndpointInfo;
import org.jboss.ws.server.ServiceEndpointInvoker;

public class ServiceEndpointInvokerJSE
extends ServiceEndpointInvoker {
    private Logger log = Logger.getLogger(ServiceEndpointInvokerJSE.class);

    public void initServiceEndpoint(ServiceEndpointInfo seInfo) throws ServiceException {
    }

    public Class loadServiceEndpoint(ServiceEndpointInfo seInfo) throws ClassNotFoundException {
        ServerEndpointMetaData epMetaData = seInfo.getServerEndpointMetaData();
        ClassLoader cl = epMetaData.getClassLoader();
        String seiImplName = epMetaData.getServiceEndpointImplName();
        Class<?> seiImplClass = cl.loadClass(seiImplName);
        return seiImplClass;
    }

    public Object createServiceEndpoint(ServiceEndpointInfo seInfo, Object endpointContext, Class seiImplClass) throws IllegalAccessException, InstantiationException, ServiceException {
        Object seiImpl = seiImplClass.newInstance();
        if (seiImpl instanceof ServiceLifecycle) {
            if (!(endpointContext instanceof ServletEndpointContext)) {
                throw new WSException("Invalid endpoint context: " + endpointContext);
            }
            ServiceLifecycle serviceLifecycle = (ServiceLifecycle)seiImpl;
            ServletEndpointContext servletEndpointContext = (ServletEndpointContext)endpointContext;
            serviceLifecycle.init(servletEndpointContext);
        }
        return seiImpl;
    }

    public void invokeServiceEndpoint(ServiceEndpointInfo seInfo, Object seiImpl, EndpointInvocation epInv) throws SOAPFaultException {
        this.log.debug((Object)("invokeServiceEndpoint: " + epInv.getJavaMethod().getName()));
        try {
            Class<?> implClass = seiImpl.getClass();
            Method seiMethod = epInv.getJavaMethod();
            Method implMethod = this.getImplMethod(implClass, seiMethod);
            Object[] args = epInv.getRequestPayload();
            Object retObj = implMethod.invoke(seiImpl, args);
            epInv.setReturnValue(retObj);
        }
        catch (Exception e) {
            this.handleInvocationException(e);
        }
    }

    public void destroyServiceEndpoint(ServiceEndpointInfo seInfo, Object seiImpl) {
        if (seiImpl instanceof ServiceLifecycle) {
            ((ServiceLifecycle)seiImpl).destroy();
        }
    }
}

