/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.soap.SOAPElement;
import org.jboss.ws.soap.SOAPContentElement;
import org.jboss.ws.soap.SOAPElementImpl;

public class SAAJElementWriter {
    private PrintWriter out;
    private boolean canonical;
    private boolean prettyprint;
    private boolean writeXMLDeclaration;
    private String charsetName;
    private boolean wroteXMLDeclaration;

    public SAAJElementWriter(Writer w) {
        this.out = new PrintWriter(w);
    }

    public SAAJElementWriter(OutputStream stream) {
        try {
            this.out = new PrintWriter(new OutputStreamWriter(stream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public SAAJElementWriter(OutputStream stream, String charsetName) {
        try {
            this.out = new PrintWriter(new OutputStreamWriter(stream, charsetName));
            this.charsetName = charsetName;
            this.writeXMLDeclaration = true;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported encoding: " + charsetName);
        }
    }

    public static String printSOAPElement(SOAPElementImpl element, boolean prettyprint) {
        StringWriter strw = new StringWriter();
        new SAAJElementWriter(strw).setPrettyprint(prettyprint).print(element);
        return strw.toString();
    }

    public boolean isCanonical() {
        return this.canonical;
    }

    public SAAJElementWriter setCanonical(boolean canonical) {
        this.canonical = canonical;
        return this;
    }

    public boolean isPrettyprint() {
        return this.prettyprint;
    }

    public SAAJElementWriter setPrettyprint(boolean prettyprint) {
        this.prettyprint = prettyprint;
        return this;
    }

    public boolean isWriteXMLDeclaration() {
        return this.writeXMLDeclaration;
    }

    public SAAJElementWriter setWriteXMLDeclaration(boolean writeXMLDeclaration) {
        this.writeXMLDeclaration = writeXMLDeclaration;
        return this;
    }

    public void print(SOAPElementImpl element) {
        this.printInternal(element);
    }

    private void printInternal(SOAPElementImpl element) {
        if (element == null) {
            return;
        }
        if (!this.wroteXMLDeclaration && this.writeXMLDeclaration && !this.canonical) {
            this.out.print("<?xml version='1.0'");
            if (this.charsetName != null) {
                this.out.print(" encoding='" + this.charsetName + "'");
            }
            this.out.println("?>");
            this.wroteXMLDeclaration = true;
        }
        SAAJElementWriter.writeElement(element, this.out, this.prettyprint);
        this.out.flush();
    }

    private static void writeElement(SOAPElementImpl element, PrintWriter out, boolean pretty) {
        String endTag = element.write(out, pretty);
        if (!(element instanceof SOAPContentElement)) {
            Iterator it = element.getChildElements();
            while (it.hasNext()) {
                Object child = it.next();
                if (!(child instanceof SOAPElement)) continue;
                SOAPElementImpl childElement = (SOAPElementImpl)child;
                SAAJElementWriter.writeElement(childElement, out, pretty);
            }
        }
        if (endTag != null) {
            out.write(endTag);
        }
    }
}

