/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.jboss.logging.Logger;
import org.jboss.ws.Constants;
import org.jboss.ws.soap.NameImpl;
import org.jboss.ws.soap.SOAPBodyElementDoc;
import org.jboss.ws.soap.SOAPElementImpl;
import org.jboss.ws.soap.SOAPFactoryImpl;
import org.jboss.ws.soap.SOAPFaultImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPBodyImpl
extends SOAPElementImpl
implements SOAPBody {
    private static Logger log = Logger.getLogger(SOAPBodyImpl.class);

    public SOAPBodyImpl(String prefix, String namespace) {
        super("Body", prefix, namespace);
    }

    public SOAPElement addChildElement(SOAPElement child) throws SOAPException {
        if (!(child instanceof SOAPBodyElement)) {
            child = this.isFault(child) ? this.convertToSOAPFault(child) : this.convertToBodyElement(child);
        }
        child = super.addChildElement(child);
        return child;
    }

    private boolean isFault(Node node) {
        return "Fault".equals(node.getLocalName()) && this.getNamespaceURI().equals(node.getNamespaceURI());
    }

    private SOAPElement convertToSOAPFault(Node node) {
        if (!(node instanceof SOAPElementImpl)) {
            throw new IllegalArgumentException("SOAPElementImpl expected");
        }
        SOAPElementImpl element = (SOAPElementImpl)node;
        element.detachNode();
        return new SOAPFaultImpl(element);
    }

    private SOAPBodyElementDoc convertToBodyElement(Node node) {
        if (!(node instanceof SOAPElementImpl)) {
            throw new IllegalArgumentException("SOAPElementImpl expected");
        }
        SOAPElementImpl element = (SOAPElementImpl)node;
        element.detachNode();
        return new SOAPBodyElementDoc(element);
    }

    public SOAPBodyElement addBodyElement(Name name) throws SOAPException {
        SOAPBodyElementDoc child = new SOAPBodyElementDoc(name);
        return (SOAPBodyElement)this.addChildElement(child);
    }

    public SOAPBodyElement addDocument(Document doc) throws SOAPException {
        Element rootElement = doc.getDocumentElement();
        SOAPFactoryImpl soapFactory = new SOAPFactoryImpl();
        SOAPElementImpl soapElement = soapFactory.createElement(rootElement, true);
        return (SOAPBodyElement)this.addChildElement(soapElement);
    }

    public SOAPFault addFault() throws SOAPException {
        if (this.hasFault()) {
            throw new SOAPException("A SOAPBody may contain at most one SOAPFault child element");
        }
        return this.addFault(new NameImpl(Constants.SOAP11_FAULT_CODE_SERVER), "Generic server fault");
    }

    public SOAPFault addFault(Name faultCode, String faultString) throws SOAPException {
        if (this.hasFault()) {
            throw new SOAPException("A SOAPBody may contain at most one SOAPFault child element");
        }
        SOAPFaultImpl soapFault = new SOAPFaultImpl(this.getNamespaceURI());
        soapFault = (SOAPFaultImpl)this.addChildElement(soapFault);
        soapFault.setFaultCode(faultCode);
        soapFault.setFaultString(faultString);
        return soapFault;
    }

    public SOAPFault addFault(Name faultCode, String faultString, Locale locale) throws SOAPException {
        if (this.hasFault()) {
            throw new SOAPException("A SOAPBody may contain at most one SOAPFault child element");
        }
        SOAPFaultImpl soapFault = new SOAPFaultImpl(this.getNamespaceURI());
        soapFault.setFaultCode(faultCode);
        soapFault.setFaultString(faultString, locale);
        this.addChildElement(soapFault);
        return soapFault;
    }

    public SOAPFault getFault() {
        Iterator it = this.getChildElements(new NameImpl("Fault", "env", this.getSOAPEnvelope().getNamespaceURI()));
        return it.hasNext() ? (SOAPFault)it.next() : null;
    }

    public boolean hasFault() {
        return this.getChildElements(Constants.SOAP11_FAULT).hasNext();
    }

    public Node appendChild(Node newChild) throws DOMException {
        if (!(newChild instanceof SOAPBodyElement) && !(newChild instanceof DocumentFragment)) {
            newChild = this.isFault(newChild) ? this.convertToSOAPFault(newChild) : this.convertToBodyElement(newChild);
        }
        return super.appendChild(newChild);
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (!(newChild instanceof SOAPBodyElement) && !(newChild instanceof DocumentFragment)) {
            newChild = this.isFault(newChild) ? this.convertToSOAPFault(newChild) : this.convertToBodyElement(newChild);
        }
        return super.insertBefore(newChild, refChild);
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (!(newChild instanceof SOAPBodyElement) && !(newChild instanceof DocumentFragment)) {
            newChild = this.isFault(newChild) ? this.convertToSOAPFault(newChild) : this.convertToBodyElement(newChild);
        }
        return super.replaceChild(newChild, oldChild);
    }

    public String write(Writer writer, boolean pretty) {
        try {
            writer.write("<");
            writer.write(this.getParentElement().getPrefix() + ":Body");
            Iterator nsPrefixes = this.getNamespacePrefixes();
            while (nsPrefixes.hasNext()) {
                String prefix = (String)nsPrefixes.next();
                writer.write(" xmlns:" + prefix + "='" + this.getNamespaceURI(prefix) + "'");
            }
            Iterator attNames = this.getAllAttributes();
            while (attNames.hasNext()) {
                NameImpl name = (NameImpl)attNames.next();
                String attPrefix = name.getPrefix() != null ? name.getPrefix() : "";
                String attFqn = attPrefix.length() > 0 ? attPrefix + ":" + name.getLocalName() : name.getLocalName();
                writer.write(" " + attFqn);
                writer.write("='" + this.getAttributeValue(name) + "'");
            }
            writer.write(">");
            if (pretty) {
                writer.write("\n");
            }
            return "</" + this.getParentElement().getPrefix() + ":Body>";
        }
        catch (IOException e) {
            throw new JAXRPCException(e);
        }
    }
}

