/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.addressing.EndpointReference;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.ws.binding.soap.SOAPMessageMarshaller;
import org.jboss.ws.binding.soap.SOAPMessageUnMarshaller;
import org.jboss.ws.soap.EndpointInfo;
import org.jboss.ws.soap.SAAJElementWriter;
import org.jboss.ws.soap.SOAPElementImpl;

public class SOAPConnectionImpl
extends SOAPConnection {
    private static Logger log = Logger.getLogger(SOAPConnectionImpl.class);
    private static Logger msgLog = Logger.getLogger((String)"jbossws.SOAPMessage");
    private Map<String, Object> config = new HashMap<String, Object>();
    private static Map<String, String> metadataMap = new HashMap<String, String>();
    private static Map<String, String> configMap;
    private boolean closed;

    public SOAPConnectionImpl() {
        this.config.put("ENABLE_LEASE", false);
    }

    public SOAPMessage call(SOAPMessage reqMessage, Object endpoint) throws SOAPException {
        return this.call(reqMessage, endpoint, false);
    }

    public SOAPMessage call(SOAPMessage reqMessage, Object endpoint, boolean oneway) throws SOAPException {
        Client remotingClient;
        InvokerLocator locator;
        Map<String, Object> callProps;
        String targetAddress;
        if (reqMessage == null) {
            throw new IllegalArgumentException("Given SOAPMessage cannot be null");
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("Given endpoint cannot be null");
        }
        if (this.closed) {
            throw new SOAPException("SOAPConnection is already closed");
        }
        if (endpoint instanceof EndpointInfo) {
            EndpointInfo epInfo = (EndpointInfo)endpoint;
            targetAddress = epInfo.getTargetAddress();
            callProps = epInfo.getProperties();
            if (callProps.containsKey("org.jboss.ws.timeout")) {
                Object timeout = callProps.get("org.jboss.ws.timeout");
                int qmIndex = targetAddress.indexOf("?");
                targetAddress = targetAddress + (qmIndex < 0 ? "?" : "&") + "timeout=" + timeout;
            }
        } else if (endpoint instanceof EndpointReference) {
            EndpointReference epr = (EndpointReference)endpoint;
            targetAddress = epr.getAddress().toString();
            callProps = null;
        } else {
            targetAddress = endpoint.toString();
            callProps = null;
        }
        try {
            log.debug((Object)("Get locator for: " + endpoint));
            locator = new InvokerLocator(targetAddress);
        }
        catch (MalformedURLException e) {
            throw new SOAPException("Malformed endpoint address", e);
        }
        Map metadata = this.getRemotingMetaData(reqMessage, targetAddress, callProps);
        try {
            remotingClient = new Client(locator, "saaj", this.config);
            remotingClient.setMarshaller((Marshaller)new SOAPMessageMarshaller());
            remotingClient.setUnMarshaller((UnMarshaller)(!oneway ? new SOAPMessageUnMarshaller() : null));
        }
        catch (Exception e) {
            throw new SOAPException("Could not setup remoting client", e);
        }
        try {
            if (msgLog.isDebugEnabled()) {
                SOAPEnvelope soapReqEnv = reqMessage.getSOAPPart().getEnvelope();
                String envStr = SAAJElementWriter.printSOAPElement((SOAPElementImpl)((Object)soapReqEnv), true);
                msgLog.debug((Object)("Remoting meta data: " + metadata));
                msgLog.debug((Object)("Outgoing SOAPMessage\n" + envStr));
            }
            SOAPMessage resMessage = null;
            if (oneway) {
                remotingClient.invokeOneway((Object)reqMessage, metadata, false);
            } else {
                resMessage = (SOAPMessage)remotingClient.invoke((Object)reqMessage, metadata);
            }
            if (resMessage != null && msgLog.isDebugEnabled()) {
                SOAPEnvelope soapResEnv = resMessage.getSOAPPart().getEnvelope();
                String envStr = SAAJElementWriter.printSOAPElement((SOAPElementImpl)((Object)soapResEnv), true);
                msgLog.debug((Object)("Incomming Response SOAPMessage\n" + envStr));
            }
            return resMessage;
        }
        catch (Throwable t) {
            throw new SOAPException("Could not transmit message", t);
        }
    }

    public void close() throws SOAPException {
        if (this.closed) {
            throw new SOAPException("SOAPConnection is already closed");
        }
        this.closed = true;
    }

    private Map getRemotingMetaData(SOAPMessage reqMessage, String targetAddress, Map callProps) throws SOAPException {
        MimeHeaders mimeHeaders = reqMessage.getMimeHeaders();
        String[] action = mimeHeaders.getHeader("SOAPAction");
        if (action != null && action.length > 0) {
            String soapAction = action[0];
            if (!soapAction.startsWith("\"") || !soapAction.endsWith("\"")) {
                soapAction = "\"" + soapAction + "\"";
            }
            mimeHeaders.setHeader("SOAPAction", soapAction);
        } else {
            mimeHeaders.setHeader("SOAPAction", "\"\"");
        }
        if (reqMessage.saveRequired()) {
            reqMessage.saveChanges();
        }
        HashMap<String, Properties> metadata = new HashMap<String, Properties>();
        Properties props = new Properties();
        metadata.put("HEADER", props);
        Iterator i = mimeHeaders.getAllHeaders();
        while (i.hasNext()) {
            MimeHeader header = (MimeHeader)i.next();
            String currentValue = props.getProperty(header.getName());
            if (currentValue != null) {
                props.put(header.getName(), currentValue + "," + header.getValue());
                continue;
            }
            props.put(header.getName(), header.getValue());
        }
        if (callProps != null) {
            Iterator it = callProps.entrySet().iterator();
            String authType = (String)callProps.get("org.jboss.ws.authType");
            if (authType == null) {
                authType = "org.jboss.ws.authType.basic";
            }
            while (it.hasNext()) {
                String remotingKey;
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                if (metadataMap.containsKey(key)) {
                    remotingKey = metadataMap.get(key);
                    if (key.equals("javax.xml.rpc.security.auth.username") || key.equals("javax.xml.rpc.security.auth.password")) {
                        if (authType.equals("org.jboss.ws.authType.basic")) {
                            metadata.put(remotingKey, (Properties)val);
                        } else {
                            log.warn((Object)("Ignore '" + key + "' with auth typy: " + authType));
                        }
                    } else {
                        metadata.put(remotingKey, (Properties)val);
                    }
                }
                if (!configMap.containsKey(key)) continue;
                remotingKey = configMap.get(key);
                this.config.put(remotingKey, val);
            }
        }
        return metadata;
    }

    static {
        metadataMap.put("javax.xml.rpc.security.auth.username", "http.basic.username");
        metadataMap.put("javax.xml.rpc.security.auth.password", "http.basic.password");
        configMap = new HashMap<String, String>();
        configMap.put("org.jboss.ws.keyStore", "org.jboss.remoting.keyStore");
        configMap.put("org.jboss.ws.keyStorePassword", "org.jboss.remoting.keyStorePassword");
        configMap.put("org.jboss.ws.keyStoreType", "org.jboss.remoting.keyStoreType");
        configMap.put("org.jboss.ws.trustStore", "org.jboss.remoting.trustStore");
        configMap.put("org.jboss.ws.trustStorePassword", "org.jboss.remoting.trustStorePassword");
        configMap.put("org.jboss.ws.trustStoreType", "org.jboss.remoting.trustStoreType");
    }
}

