/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.jboss.ws.soap.NameImpl;
import org.jboss.ws.soap.SOAPElementImpl;
import org.jboss.ws.soap.SOAPHeaderElementImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

public class SOAPHeaderImpl
extends SOAPElementImpl
implements SOAPHeader {
    public SOAPHeaderImpl(String prefix, String namespace) {
        super("Header", prefix, namespace);
    }

    private SOAPHeaderElementImpl convertToHeaderElement(Node node) {
        if (!(node instanceof SOAPElementImpl)) {
            throw new IllegalArgumentException("SOAPElement expected");
        }
        SOAPElementImpl element = (SOAPElementImpl)node;
        element.detachNode();
        return new SOAPHeaderElementImpl(element);
    }

    public SOAPElement addChildElement(SOAPElement child) throws SOAPException {
        if (!(child instanceof SOAPHeaderElement)) {
            child = this.convertToHeaderElement(child);
        }
        return super.addChildElement(child);
    }

    public SOAPHeaderElement addHeaderElement(Name name) throws SOAPException {
        if (name == null || name.getURI().length() == 0 || name.getPrefix().length() == 0) {
            throw new SOAPException("Invalid SOAPHeaderElement name: " + name);
        }
        SOAPHeaderElementImpl headerElement = new SOAPHeaderElementImpl(name);
        this.addChildElement(headerElement);
        return headerElement;
    }

    public Iterator examineAllHeaderElements() {
        ArrayList<SOAPHeaderElement> list = new ArrayList<SOAPHeaderElement>();
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            SOAPHeaderElement shElement = (SOAPHeaderElement)it.next();
            list.add(shElement);
        }
        return list.iterator();
    }

    public Iterator examineHeaderElements(String actor) {
        if (actor == null) {
            throw new IllegalArgumentException("Invalid actor: " + actor);
        }
        ArrayList<SOAPHeaderElement> list = new ArrayList<SOAPHeaderElement>();
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            SOAPHeaderElement shElement = (SOAPHeaderElement)it.next();
            if (!actor.equals(shElement.getActor())) continue;
            list.add(shElement);
        }
        return list.iterator();
    }

    public Iterator examineMustUnderstandHeaderElements(String actor) {
        if (actor == null) {
            throw new IllegalArgumentException("Invalid actor: " + actor);
        }
        ArrayList<SOAPHeaderElement> list = new ArrayList<SOAPHeaderElement>();
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            SOAPHeaderElement shElement = (SOAPHeaderElement)it.next();
            if (!actor.equals(shElement.getActor()) || !shElement.getMustUnderstand()) continue;
            list.add(shElement);
        }
        return list.iterator();
    }

    public Iterator extractAllHeaderElements() {
        ArrayList<SOAPHeaderElement> list = new ArrayList<SOAPHeaderElement>();
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            SOAPHeaderElement shElement = (SOAPHeaderElement)it.next();
            this.removeChild(shElement);
            list.add(shElement);
        }
        return list.iterator();
    }

    public Iterator extractHeaderElements(String actor) {
        if (actor == null) {
            throw new IllegalArgumentException("Invalid actor: " + actor);
        }
        ArrayList<SOAPHeaderElement> list = new ArrayList<SOAPHeaderElement>();
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            SOAPHeaderElement shElement = (SOAPHeaderElement)it.next();
            if (!actor.equals(shElement.getActor())) continue;
            this.removeChild(shElement);
            list.add(shElement);
        }
        return list.iterator();
    }

    public Node appendChild(Node newChild) throws DOMException {
        if (!(newChild instanceof SOAPHeaderElementImpl) && !(newChild instanceof DocumentFragment)) {
            newChild = this.convertToHeaderElement(newChild);
        }
        return super.appendChild(newChild);
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (!(newChild instanceof SOAPHeaderElementImpl) && !(newChild instanceof DocumentFragment)) {
            newChild = this.convertToHeaderElement(newChild);
        }
        return super.insertBefore(newChild, refChild);
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (!(newChild instanceof SOAPHeaderElementImpl) && !(newChild instanceof DocumentFragment)) {
            newChild = this.convertToHeaderElement(newChild);
        }
        return super.replaceChild(newChild, oldChild);
    }

    public String write(Writer writer, boolean pretty) {
        try {
            writer.write(60);
            writer.write(this.getParentElement().getPrefix() + ":Header");
            Iterator it = this.getNamespacePrefixes();
            while (it.hasNext()) {
                String prefix = (String)it.next();
                writer.write(" xmlns:" + prefix + "='" + this.getNamespaceURI(prefix) + "'");
            }
            Iterator attNames = this.getAllAttributes();
            while (attNames.hasNext()) {
                NameImpl name = (NameImpl)attNames.next();
                String attPrefix = name.getPrefix() != null ? name.getPrefix() : "";
                String attFqn = attPrefix.length() > 0 ? attPrefix + ":" + name.getLocalName() : name.getLocalName();
                writer.write(" " + attFqn);
                writer.write("='" + this.getAttributeValue(name) + "'");
            }
            boolean hasChildren = this.getChildNodes().getLength() > 0;
            String endTag = null;
            if (hasChildren) {
                writer.write(62);
                endTag = "</" + this.getParentElement().getPrefix() + ":Header>";
            } else {
                writer.write("/>");
            }
            if (pretty) {
                writer.write("\n");
            }
            return endTag;
        }
        catch (IOException e) {
            throw new JAXRPCException(e);
        }
    }
}

