/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import com.ctc.wstx.stax.WstxInputFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.jaxrpc.Style;
import org.jboss.ws.soap.NameImpl;
import org.jboss.ws.soap.SAAJEnvelopeBuilder;
import org.jboss.ws.soap.SOAPBodyElementDoc;
import org.jboss.ws.soap.SOAPContentElement;
import org.jboss.ws.soap.SOAPEnvelopeImpl;
import org.jboss.ws.soap.SOAPFaultImpl;
import org.jboss.ws.soap.SOAPHeaderElementImpl;
import org.jboss.ws.soap.SOAPMessageImpl;
import org.jboss.ws.soap.SOAPPartImpl;
import org.jboss.xb.binding.NamespaceRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class STAXEnvelopeBuilder
implements SAAJEnvelopeBuilder {
    private static final String END_ELEMENT_BRACKET = "</";
    private static final String EMPTY_STRING = "";
    private static final String CLOSING_BRACKET = ">";
    private static final String START_ELEMENT_BRACKET = "<";
    private static final String HEADER_ELEMENT_NAME = "Header";
    private static final String BODY_ELEMENT_NAME = "Body";
    private static final String FAULT_ELEMENT_NAME = "Fault";
    private Part currentPart = Part.ENVELOPE;
    private Part previousPart = null;
    private boolean ignoreParseException = false;
    private Style style;
    private SOAPMessage soapMessage;
    private SOAPPartImpl soapPart;
    private SOAPEnvelopeImpl soapEnv;
    private NamespaceRegistry namespaceRegistry;
    private StringBuffer fragmentBuffer;
    private QName fragmentRootCursor = null;
    private QName currentRootElement = null;
    private XMLStreamReader reader;
    private static XMLInputFactory factory;

    public STAXEnvelopeBuilder() {
        this.resetFragmentBuffer();
    }

    private void resetFragmentBuffer() {
        this.fragmentBuffer = new StringBuffer();
        this.fragmentBuffer.ensureCapacity(2048);
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 1; ++i) {
            STAXEnvelopeBuilder builder = new STAXEnvelopeBuilder();
            builder.setSOAPMessage(new SOAPMessageImpl());
            builder.setStyle(Style.DOCUMENT);
            File source = new File("C:/dev/prj/Stax_JBoss/resource/req8.xml");
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));
            long start = System.currentTimeMillis();
            SOAPEnvelope soapEnv = builder.build(in);
            System.out.println(System.currentTimeMillis() - start + " ms");
            System.out.println(DOMWriter.printNode((Node)soapEnv, (boolean)true));
            ((InputStream)in).close();
        }
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public void setSOAPMessage(SOAPMessage soapMessage) {
        this.soapMessage = soapMessage;
    }

    public void setIgnoreParseException(boolean b) {
        this.ignoreParseException = b;
    }

    public SOAPEnvelope build(InputStream in) throws IOException, SOAPException {
        try {
            this.reader = STAXEnvelopeBuilder.getFactoryInstance().createXMLStreamReader(in);
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to create stream reader:" + e.getMessage());
        }
        try {
            this.soapPart = (SOAPPartImpl)this.soapMessage.getSOAPPart();
            while (this.reader.hasNext()) {
                if (this.reader.isStartElement()) {
                    this.processStartElement();
                } else if (this.reader.isCharacters()) {
                    this.processCharacters();
                } else if (this.reader.isEndElement()) {
                    this.processEndElement();
                }
                this.reader.next();
            }
        }
        catch (XMLStreamException e) {
            if (!this.ignoreParseException) {
                throw new IOException("Failed to parse stream: " + e.getMessage());
            }
        }
        catch (SOAPException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                if (this.reader != null) {
                    this.reader.close();
                }
            }
            catch (XMLStreamException e) {}
        }
        return this.soapEnv;
    }

    private static synchronized XMLInputFactory getFactoryInstance() {
        if (null == factory) {
            System.setProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
            factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
            ((WstxInputFactory)factory).configureForSpeed();
        }
        return factory;
    }

    private void processCharacters() throws SOAPException {
        if (this.fragmentRootCursor != null) {
            this.consumeCharacters();
        }
    }

    private void consumeCharacters() throws SOAPException {
        String text = STAXEnvelopeBuilder.normalize(this.reader.getText());
        if (!this.atPartMargin() && !this.reader.isWhiteSpace()) {
            this.fragmentBuffer.append(text);
            if (Part.FAULT == this.currentPart) {
                String localName = this.currentRootElement.getLocalPart();
                SOAPFault fault = this.soapEnv.getBody().getFault();
                if ("faultcode".equalsIgnoreCase(localName)) {
                    fault.setFaultCode(text);
                } else if ("faultactor".equalsIgnoreCase(localName)) {
                    fault.setFaultActor(text);
                } else if ("faultstring".equalsIgnoreCase(localName)) {
                    fault.setFaultString(text);
                }
            }
        }
    }

    private void processEndElement() throws SOAPException {
        if (this.fragmentRootCursor != null) {
            this.consumeEndElement();
        }
    }

    private void consumeEndElement() throws SOAPException {
        QName qName = this.reader.getName();
        this.fragmentBuffer.append(END_ELEMENT_BRACKET);
        this.fragmentBuffer.append(this.getFQElementName(qName));
        this.fragmentBuffer.append(CLOSING_BRACKET);
        if (this.fragmentRootCursor != null && this.fragmentRootCursor.equals(qName)) {
            this.flushBuffer();
            this.fragmentRootCursor = null;
        }
    }

    private void flushBuffer() throws SOAPException {
        if (Part.HEADER == this.currentPart) {
            SOAPHeader soapHeader = this.soapEnv.getHeader();
            SOAPContentElement lastHeaderElement = (SOAPContentElement)soapHeader.getChildNodes().item(soapHeader.getChildNodes().getLength() - 1);
            lastHeaderElement.setXMLFragment(this.fragmentBuffer.toString());
        } else if (Part.BODY == this.currentPart) {
            SOAPBody soapBody = this.soapEnv.getBody();
            SOAPContentElement lastBodyElement = (SOAPContentElement)soapBody.getChildNodes().item(soapBody.getChildNodes().getLength() - 1);
            lastBodyElement.setXMLFragment(this.fragmentBuffer.toString());
        } else if (Part.FAULT == this.currentPart) {
            SOAPBody soapBody = this.soapEnv.getBody();
            SOAPContentElement faultElement = (SOAPContentElement)((Object)soapBody.getFault());
            faultElement.setXMLFragment(this.fragmentBuffer.toString());
        }
        System.out.println(this.fragmentBuffer.toString());
        this.resetFragmentBuffer();
    }

    private void processStartElement() throws SOAPException {
        QName qName;
        this.currentRootElement = qName = this.reader.getName();
        this.togglePartMargin(qName);
        SOAPElement destElement = null;
        if (Part.ENVELOPE == this.currentPart) {
            this.soapEnv = new SOAPEnvelopeImpl(this.soapPart, qName.getNamespaceURI());
            this.namespaceRegistry = this.soapEnv.getNamespaceRegistry();
            destElement = this.soapEnv;
        } else if (Part.HEADER == this.currentPart) {
            if (this.atPartMargin()) {
                SOAPHeader soapHeader;
                destElement = soapHeader = this.soapEnv.getHeader();
                this.previousPart = Part.HEADER;
            } else {
                if (this.fragmentRootCursor == null) {
                    NameImpl name = new NameImpl(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
                    SOAPHeaderElementImpl headerElement = new SOAPHeaderElementImpl(name);
                    this.soapEnv.getHeader().addChildElement(headerElement);
                    destElement = headerElement;
                    this.fragmentRootCursor = qName;
                }
                this.consumeStartElement();
            }
        } else if (Part.BODY == this.currentPart) {
            SOAPBody soapBody = this.soapEnv.getBody();
            if (this.atPartMargin()) {
                destElement = soapBody;
                this.previousPart = Part.BODY;
            } else {
                NameImpl bodyElementName = new NameImpl(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
                if (this.fragmentRootCursor == null) {
                    SOAPBodyElementDoc docBodyElement = new SOAPBodyElementDoc(bodyElementName);
                    docBodyElement = (SOAPBodyElementDoc)soapBody.addChildElement(docBodyElement);
                    destElement = docBodyElement;
                    this.fragmentRootCursor = qName;
                }
                this.consumeStartElement();
            }
        } else if (Part.FAULT == this.currentPart) {
            if (this.atPartMargin()) {
                SOAPBody soapBody = this.soapEnv.getBody();
                SOAPFaultImpl soapFault = new SOAPFaultImpl(this.soapEnv.getNamespaceURI());
                soapBody.addChildElement(soapFault);
                destElement = soapFault;
                this.previousPart = Part.FAULT;
            }
            if (this.fragmentRootCursor == null) {
                this.fragmentRootCursor = qName;
            }
            this.consumeStartElement();
        }
        if (this.fragmentRootCursor == null) {
            this.copyAttributes(destElement);
            this.registerNameSpaces(this.namespaceRegistry);
        }
    }

    private void togglePartMargin(QName qName) {
        if (qName.getLocalPart().equalsIgnoreCase(HEADER_ELEMENT_NAME)) {
            this.previousPart = this.currentPart;
            this.currentPart = Part.HEADER;
        } else if (qName.getLocalPart().equalsIgnoreCase(BODY_ELEMENT_NAME)) {
            this.previousPart = this.currentPart;
            this.currentPart = Part.BODY;
        } else if (qName.getLocalPart().equalsIgnoreCase(FAULT_ELEMENT_NAME)) {
            this.previousPart = this.currentPart;
            this.currentPart = Part.FAULT;
        }
    }

    private void consumeStartElement() {
        QName qName = this.reader.getName();
        this.fragmentBuffer.append(START_ELEMENT_BRACKET);
        this.fragmentBuffer.append(this.getFQElementName(qName));
        for (int x = 0; x < this.reader.getNamespaceCount(); ++x) {
            if (this.reader.getNamespacePrefix(x) != null) {
                this.fragmentBuffer.append(" xmlns:");
                this.fragmentBuffer.append(this.reader.getNamespacePrefix(x)).append("='");
                this.fragmentBuffer.append(this.reader.getNamespaceURI(x)).append("'");
                continue;
            }
            if (this.reader.getNamespaceURI(x) == null) continue;
            this.fragmentBuffer.append(" xmlns='");
            this.fragmentBuffer.append(this.reader.getNamespaceURI(x)).append("'");
        }
        if (this.reader.getAttributeCount() > 0) {
            for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
                QName attQName = this.reader.getAttributeName(i);
                this.fragmentBuffer.append(" ").append(this.getFQElementName(attQName));
                this.fragmentBuffer.append("='").append(this.reader.getAttributeValue(i)).append("'");
            }
        }
        this.fragmentBuffer.append(CLOSING_BRACKET);
    }

    private String getFQElementName(QName qName) {
        return !qName.getPrefix().equals(EMPTY_STRING) ? qName.getPrefix() + ":" + qName.getLocalPart() : qName.getLocalPart();
    }

    private void registerNameSpaces(NamespaceRegistry reg) {
        for (int i = 0; i < this.reader.getNamespaceCount(); ++i) {
            String prefix = this.reader.getNamespacePrefix(i);
            String uri = this.reader.getNamespaceURI(i);
            reg.registerURI(uri, prefix);
            this.soapEnv.addNamespaceDeclaration(prefix, uri);
        }
    }

    private void copyAttributes(Element destElement) {
        if (this.reader.getAttributeCount() == 0) {
            return;
        }
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            destElement.setAttributeNS(this.reader.getAttributeNamespace(i), this.reader.getAttributeLocalName(i), this.reader.getAttributeValue(i));
        }
    }

    private boolean atPartMargin() {
        return this.previousPart != this.currentPart;
    }

    private static String normalize(String valueStr) {
        int i;
        boolean found = false;
        block9: for (i = 0; i < valueStr.length(); ++i) {
            switch (valueStr.charAt(i)) {
                case '\"': 
                case '&': 
                case '<': 
                case '>': {
                    found = true;
                    break block9;
                }
                default: {
                    continue block9;
                }
            }
        }
        if (!found) {
            return valueStr;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(valueStr.substring(0, i));
        while (i < valueStr.length()) {
            char c = valueStr.charAt(i);
            switch (c) {
                case '<': {
                    builder.append("&lt;");
                    break;
                }
                case '>': {
                    builder.append("&gt;");
                    break;
                }
                case '&': {
                    builder.append("&amp;");
                    break;
                }
                case '\"': {
                    builder.append("&quot;");
                    break;
                }
                default: {
                    builder.append(c);
                }
            }
            ++i;
        }
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Part {
        ENVELOPE,
        HEADER,
        BODY,
        FAULT,
        RPC_PAYLOAD,
        DOC_PAYLOAD,
        BARE_PAYLOAD;

    }
}

