/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import javax.xml.soap.Text;
import org.jboss.ws.soap.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class TextImpl
extends NodeImpl
implements Text {
    public TextImpl(Node node) {
        super(node);
    }

    public boolean isComment() {
        String value = this.getNodeValue().trim();
        return value.startsWith("<!--") && value.endsWith("-->");
    }

    public String getValue() {
        return this.getNodeValue();
    }

    public void setValue(String value) {
        this.setNodeValue(value);
    }

    public org.w3c.dom.Text splitText(int offset) throws DOMException {
        if (offset < 0 || offset > this.getNodeValue().length()) {
            throw new IllegalArgumentException("Invalid offset [" + offset + "] for '" + this.getNodeValue() + "'");
        }
        String before = this.getNodeValue().substring(0, offset + 1);
        this.setNodeValue(before);
        String after = this.getNodeValue().substring(offset + 1);
        TextImpl txtNode = new TextImpl(this.domNode.getOwnerDocument().createTextNode(after));
        Node parent = this.getParentNode();
        if (parent != null) {
            Node sibling = this.getNextSibling();
            if (sibling == null) {
                parent.appendChild(txtNode);
            } else {
                parent.insertBefore(txtNode, sibling);
            }
        }
        return txtNode;
    }

    public int getLength() {
        return this.getNodeValue().length();
    }

    public void deleteData(int offset, int count) throws DOMException {
        String value = this.getNodeValue().substring(0, offset + 1);
        this.setNodeValue(value);
    }

    public String getData() throws DOMException {
        return this.getNodeValue();
    }

    public String substringData(int offset, int count) throws DOMException {
        return this.getNodeValue().substring(offset, offset + count);
    }

    public void replaceData(int offset, int count, String arg) throws DOMException {
        StringBuilder buffer = new StringBuilder(this.getNodeValue());
        buffer.replace(offset, offset + count, arg);
        this.setNodeValue(buffer.toString());
    }

    public void insertData(int offset, String arg) throws DOMException {
        StringBuilder buffer = new StringBuilder(this.getNodeValue());
        buffer.insert(offset, arg);
        this.setNodeValue(buffer.toString());
    }

    public void appendData(String arg) throws DOMException {
        this.setNodeValue(this.getNodeValue() + arg);
    }

    public void setData(String data) throws DOMException {
        this.setNodeValue(data);
    }

    public boolean isElementContentWhitespace() {
        return false;
    }

    public String getWholeText() {
        return null;
    }

    public org.w3c.dom.Text replaceWholeText(String content) throws DOMException {
        return null;
    }
}

