/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.mail.internet.MimeMultipart;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import org.jboss.ws.soap.attachment.ContentHandlerRegistry;

public class AttachmentPartImpl
extends AttachmentPart {
    private MimeHeaders mimeHeaders = new MimeHeaders();
    private DataHandler dataHandler;
    private String cachedContentId;
    private String cachedContentType;
    private String cachedContentLocation;

    public AttachmentPartImpl() {
    }

    public AttachmentPartImpl(DataHandler handler) {
        this.dataHandler = handler;
    }

    private void clearHeaderCache() {
        this.cachedContentId = null;
        this.cachedContentType = null;
        this.cachedContentLocation = null;
    }

    public void addMimeHeader(String name, String value) {
        this.clearHeaderCache();
        this.mimeHeaders.addHeader(name, value);
    }

    public void clearContent() {
        this.dataHandler = null;
    }

    public Iterator getAllMimeHeaders() {
        this.clearHeaderCache();
        return this.mimeHeaders.getAllHeaders();
    }

    public Object getContent() throws SOAPException {
        if (this.dataHandler == null) {
            throw new SOAPException("No content available");
        }
        try {
            return this.dataHandler.getContent();
        }
        catch (IOException e) {
            throw new SOAPException(e);
        }
    }

    public DataHandler getDataHandler() throws SOAPException {
        if (this.dataHandler == null) {
            throw new SOAPException("No data handler on attachment");
        }
        return this.dataHandler;
    }

    public Iterator getMatchingMimeHeaders(String[] names) {
        this.clearHeaderCache();
        return this.mimeHeaders.getMatchingHeaders(names);
    }

    public String[] getMimeHeader(String name) {
        return this.mimeHeaders.getHeader(name);
    }

    public String getFirstMimeHeader(String header) {
        String[] values = this.mimeHeaders.getHeader(header.toLowerCase());
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Iterator getNonMatchingMimeHeaders(String[] names) {
        this.clearHeaderCache();
        return this.mimeHeaders.getNonMatchingHeaders(names);
    }

    public int getSize() throws SOAPException {
        if (this.dataHandler == null) {
            return 0;
        }
        int count = 0;
        int ret = 0;
        byte[] buffer = new byte[256];
        try {
            InputStream stream = this.dataHandler.getInputStream();
            do {
                count += ret;
            } while ((ret = stream.read(buffer)) != -1);
        }
        catch (IOException e) {
            throw new SOAPException(e);
        }
        return count;
    }

    public void removeAllMimeHeaders() {
        this.clearHeaderCache();
        this.mimeHeaders.removeAllHeaders();
    }

    public void removeMimeHeader(String name) {
        this.clearHeaderCache();
        this.mimeHeaders.removeHeader(name);
    }

    public void setContent(Object object, String contentType) {
        if (object instanceof MimeMultipart) {
            contentType = ((MimeMultipart)object).getContentType();
        }
        this.dataHandler = new DataHandler(object, contentType);
        this.setContentType(contentType);
    }

    public void setDataHandler(DataHandler dataHandler) {
        if (dataHandler == null) {
            throw new IllegalArgumentException("Null data handler");
        }
        this.dataHandler = dataHandler;
        this.setContentType(dataHandler.getContentType());
    }

    public void setMimeHeader(String name, String value) {
        this.clearHeaderCache();
        this.mimeHeaders.setHeader(name, value);
    }

    public String getContentId() {
        if (this.cachedContentId == null) {
            this.cachedContentId = this.getFirstMimeHeader("Content-Id");
        }
        return this.cachedContentId;
    }

    public String getContentLocation() {
        if (this.cachedContentLocation == null) {
            this.cachedContentLocation = this.getFirstMimeHeader("Content-Location");
        }
        return this.cachedContentLocation;
    }

    public String getContentType() {
        if (this.cachedContentType == null) {
            this.cachedContentType = this.getFirstMimeHeader("Content-Type");
        }
        return this.cachedContentType;
    }

    public void setContentId(String contentId) {
        this.setMimeHeader("Content-Id", contentId);
        this.cachedContentId = contentId;
    }

    public void setContentLocation(String contentLocation) {
        this.setMimeHeader("Content-Location", contentLocation);
        this.cachedContentLocation = contentLocation;
    }

    public void setContentType(String contentType) {
        this.setMimeHeader("Content-Type", contentType);
        this.cachedContentType = contentType;
    }

    static {
        ContentHandlerRegistry.register();
    }
}

