/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.TypeMapping;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.FaultMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.tools.helpers.JavaToWSDLHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaToWSDL11 {
    private static final Logger log = Logger.getLogger(JavaToWSDL11.class);
    private final String wsdlNamespace = "http://schemas.xmlsoap.org/wsdl/";
    private HashMap<String, Boolean> features = new HashMap();
    private Map<String, String> packageNamespaceMap = null;
    private TypeMapping typeMapping = null;
    private JavaWsdlMapping javaWsdlMapping = null;
    private UnifiedMetaData umd = null;
    private boolean qualifiedElements = false;

    public JavaToWSDL11() {
        log.debug((Object)"Creating JavaToWSDL11 instance");
    }

    public void addFeature(String name, boolean value) {
        this.features.put(name, new Boolean(value));
    }

    public void addFeatures(Map<String, Boolean> map) {
        this.features.putAll(map);
    }

    public boolean getFeature(String name) {
        Boolean val = this.features.get(name);
        if (val != null) {
            return val;
        }
        throw new WSException("Feature unrecognized");
    }

    public void setPackageNamespaceMap(Map<String, String> map) {
        this.packageNamespaceMap = map;
    }

    public TypeMapping getTypeMapping() {
        if (this.typeMapping == null) {
            throw new WSException("TypeMapping has not been generated");
        }
        return this.typeMapping;
    }

    public void setUnifiedMetaData(UnifiedMetaData um) {
        this.umd = um;
    }

    public WSDLDefinitions generate(Class endpoint) {
        JBossXSModel schemaModel;
        WSDLDefinitions wsdl = new WSDLDefinitions();
        wsdl.setWsdlNamespace(this.wsdlNamespace);
        if (this.umd != null) {
            JavaToWSDLHelper helper = new JavaToWSDLHelper(wsdl, "http://schemas.xmlsoap.org/wsdl/");
            try {
                helper.setFeatures(this.features);
                helper.setPackageNamespaceMap(this.packageNamespaceMap);
                this.handleJavaToWSDLGeneration(helper, endpoint.getName());
                this.typeMapping = helper.getTypeMapping();
            }
            catch (IOException e) {
                log.error((Object)"Error during Java->WSDL generation:", (Throwable)e);
            }
        }
        if (this.qualifiedElements && (schemaModel = wsdl.getWsdlTypes().getSchemaModel()) != null) {
            schemaModel.setQualifiedElements(true);
        }
        return wsdl;
    }

    public boolean isQualifiedElements() {
        return this.qualifiedElements;
    }

    public void setQualifiedElements(boolean qualifiedElements) {
        this.qualifiedElements = qualifiedElements;
    }

    public JavaWsdlMapping getJavaWsdlMapping() {
        return this.javaWsdlMapping;
    }

    private void handleJavaToWSDLGeneration(JavaToWSDLHelper helper, String endpointName) throws IOException {
        if (this.umd == null) {
            throw new WSException("Unified Meta Data Model is null");
        }
        List<ServiceMetaData> servicelist = this.umd.getServices();
        block0: for (ServiceMetaData smd : servicelist) {
            List<EndpointMetaData> endpoints = smd.getEndpoints();
            for (EndpointMetaData endpt : endpoints) {
                if (!endpointName.equals(endpt.getServiceEndpointInterfaceName())) continue;
                QName endptName = endpt.getName();
                String intfName = endptName.getLocalPart();
                helper.appendDefinitions(endptName.getNamespaceURI());
                if (intfName.endsWith("Port")) {
                    intfName = intfName.substring(0, intfName.length() - 4);
                }
                List<OperationMetaData> ops = endpt.getOperations();
                for (OperationMetaData op : ops) {
                    ParameterMetaData pmd2;
                    List<ParameterMetaData> pmds = op.getParameters();
                    for (ParameterMetaData pmd2 : pmds) {
                        helper.generateTypesForXSD(pmd2);
                    }
                    List<FaultMetaData> fmds = op.getFaults();
                    for (FaultMetaData fmd : fmds) {
                        helper.generateTypesForXSD(fmd);
                    }
                    pmd2 = op.getReturnParameter();
                    if (pmd2 != null) {
                        helper.generateTypesForXSD(pmd2);
                    }
                    helper.generateInterfaces(op, intfName);
                    helper.generateBindings(op, intfName + "Binding");
                }
                helper.generateServices(endpt, intfName);
                this.javaWsdlMapping = helper.getJavaWsdlMapping();
                continue block0;
            }
        }
    }
}

