/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.metadata.wsdl.NCName;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLDefinitionsFactory;
import org.jboss.ws.metadata.wsdl.WSDLException;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
import org.jboss.ws.tools.NamespacePackageMapping;
import org.jboss.ws.tools.ToolsUtils;
import org.jboss.ws.tools.XSDTypeToJava;
import org.jboss.ws.tools.interfaces.WSDLToJavaIntf;
import org.jboss.ws.utils.JavaUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLToJava
implements WSDLToJavaIntf {
    private String newline = "\n";
    protected LiteralTypeMapping typeMapping = null;
    protected WSDLDefinitions wsdl = null;
    protected WSDLUtils utils = WSDLUtils.getInstance();
    protected boolean annotate = false;
    protected Map<String, String> namespacePackageMap = null;
    private String seiPkgName = "";
    private String directoryToGenerate = "";
    private String style;
    private boolean unwrap = false;

    @Override
    public WSDLDefinitions convertWSDL2Java(URL wsdlfileurl) throws WSDLException {
        this.checkTypeMapping();
        WSDLDefinitionsFactory wsdlFactory = WSDLDefinitionsFactory.newInstance();
        this.wsdl = wsdlFactory.parse(wsdlfileurl);
        return this.wsdl;
    }

    @Override
    public boolean getFeature(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Illegal null argument:name");
        }
        if (name.equalsIgnoreCase("http://www.jboss.org/wstools/Use_Annotations")) {
            return this.annotate;
        }
        throw new WSException("Feature:" + name + " not recognized");
    }

    @Override
    public void setFeature(String name, boolean value) {
        if (name == null) {
            throw new IllegalArgumentException("Illegal null argument:name");
        }
        if (name.equalsIgnoreCase("http://www.jboss.org/wstools/Use_Annotations")) {
            this.annotate = value;
        }
    }

    @Override
    public void generateSEI(URL wsdlFile, File dir, boolean annotate) throws IOException {
        this.checkTypeMapping();
        WSDLDefinitions wsdl = this.convertWSDL2Java(wsdlFile);
        this.annotate = annotate;
        this.directoryToGenerate = dir.getAbsolutePath();
        this.generateSEI(wsdl, dir);
    }

    @Override
    public void generateSEI(WSDLDefinitions wsdl, File dir) throws IOException {
        String packageName;
        this.checkTypeMapping();
        this.directoryToGenerate = dir.getAbsolutePath();
        this.wsdl = wsdl;
        this.style = this.utils.getWSDLStyle(wsdl);
        String targetNS = wsdl.getTargetNamespace();
        String string = packageName = this.namespacePackageMap != null ? this.namespacePackageMap.get(targetNS) : null;
        if (packageName == null || packageName.length() == 0) {
            packageName = NamespacePackageMapping.getJavaPackageName(targetNS);
        }
        this.seiPkgName = packageName;
        File dirloc = this.utils.createPackage(dir.getAbsolutePath(), packageName);
        this.createSEI(dirloc, wsdl);
    }

    @Override
    public void setPackageNamespaceMap(Map<String, String> map) {
        Set<String> keys = map.keySet();
        Iterator<String> iter = keys.iterator();
        while (iter != null && iter.hasNext()) {
            if (this.namespacePackageMap == null) {
                this.namespacePackageMap = new HashMap<String, String>();
            }
            String pkg = iter.next();
            this.namespacePackageMap.put(map.get(pkg), pkg);
        }
    }

    @Override
    public void setTypeMapping(LiteralTypeMapping tm) {
        this.typeMapping = tm;
    }

    private boolean shouldUnwrap() {
        return this.unwrap && "Document/Literal".equals(this.style);
    }

    private void unwrapRequest(StringBuilder buf, XSTypeDefinition xt) throws IOException {
        if (!(xt instanceof XSComplexTypeDefinition)) {
            throw new WSException("Tried to unwrap a non-complex type.");
        }
        XSComplexTypeDefinition wrapper = (XSComplexTypeDefinition)xt;
        XSParticle particle = wrapper.getParticle();
        XSTerm term = particle.getTerm();
        if (!(term instanceof XSModelGroup)) {
            throw new WSException("Expected model group, could not unwrap");
        }
        this.unwrapRequestParticles(buf, (XSModelGroup)term);
        this.generateJavaSource(wrapper, this.wsdl.getWsdlTypes().getSchemaModel(), wrapper.getName());
    }

    private int unwrapRequestParticles(StringBuilder buf, XSModelGroup group) throws IOException {
        if (group.getCompositor() != 1) {
            throw new WSException("Only a sequence type can be unwrapped.");
        }
        int elementCount = 0;
        XSObjectList particles = group.getParticles();
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            XSTerm term = particle.getTerm();
            if (term instanceof XSModelGroup) {
                elementCount += this.unwrapRequestParticles(buf, (XSModelGroup)term);
                continue;
            }
            if (!(term instanceof XSElementDeclaration)) continue;
            if (elementCount++ > 0) {
                buf.append(", ");
            }
            XSElementDeclaration element = (XSElementDeclaration)term;
            QName xmlName = new QName(element.getNamespace(), element.getName());
            QName xmlType = new QName(element.getTypeDefinition().getNamespace(), element.getTypeDefinition().getName());
            JBossXSModel xsmodel = this.wsdl.getWsdlTypes().getSchemaModel();
            boolean array = particle.getMaxOccursUnbounded() || particle.getMaxOccurs() > 1;
            this.generateParameter(buf, null, xmlName, xmlType, xsmodel, element.getTypeDefinition(), array, !element.getNillable());
            buf.append(" ").append(this.getMethodParam(xmlName));
        }
        return elementCount;
    }

    private String unwrapResponse(XSTypeDefinition xt) throws IOException {
        if (!(xt instanceof XSComplexTypeDefinition)) {
            throw new WSException("Tried to unwrap a non-complex type.");
        }
        XSComplexTypeDefinition wrapper = (XSComplexTypeDefinition)xt;
        XSParticle particle = wrapper.getParticle();
        XSTerm term = particle.getTerm();
        if (!(term instanceof XSModelGroup)) {
            throw new WSException("Expected model group, could not unwrap");
        }
        String returnType = this.unwrapResponseParticles((XSModelGroup)term);
        this.generateJavaSource(wrapper, this.wsdl.getWsdlTypes().getSchemaModel(), wrapper.getName());
        return returnType;
    }

    private String unwrapResponseParticles(XSModelGroup group) throws IOException {
        if (group.getCompositor() != 1) {
            throw new WSException("Only a sequence type can be unwrapped.");
        }
        XSObjectList particles = group.getParticles();
        String returnType = null;
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            XSTerm term = particle.getTerm();
            if (term instanceof XSModelGroup) {
                returnType = this.unwrapResponseParticles((XSModelGroup)term);
                if (returnType == null) continue;
                return returnType;
            }
            if (!(term instanceof XSElementDeclaration)) continue;
            XSElementDeclaration element = (XSElementDeclaration)term;
            QName xmlName = new QName(element.getNamespace(), element.getName());
            QName xmlType = new QName(element.getTypeDefinition().getNamespace(), element.getTypeDefinition().getName());
            JBossXSModel xsmodel = this.wsdl.getWsdlTypes().getSchemaModel();
            boolean array = particle.getMaxOccursUnbounded() || particle.getMaxOccurs() > 1;
            StringBuilder buf = new StringBuilder();
            this.generateParameter(buf, null, xmlName, xmlType, xsmodel, element.getTypeDefinition(), array, !element.getNillable());
            return buf.toString();
        }
        return null;
    }

    private void appendMethods(WSDLInterface intf, StringBuilder buf) throws IOException {
        buf.append(this.newline);
        String itfname = intf.getName().toString();
        WSDLInterfaceOperation[] ops = intf.getOperations();
        if (ops == null || ops.length == 0) {
            throw new IllegalArgumentException("Interface " + itfname + " doesn't have operations");
        }
        int len = ops != null ? ops.length : 0;
        for (int i = 0; i < len; ++i) {
            int lenOuts;
            XSTypeDefinition xt;
            JBossXSModel xsmodel;
            QName xmlType;
            QName xmlName;
            WSDLInterfaceOperation op = ops[i];
            WSDLInterfaceOperationOutput[] outs = op.getOutputs();
            String returnType = this.getReturnType(outs);
            buf.append("  public " + returnType + "  ");
            buf.append(ToolsUtils.firstLetterLowerCase(op.getName().toString()));
            buf.append("(");
            WSDLInterfaceOperationInput[] ins = op.getInputs();
            int inlen = ins != null ? ins.length : 0;
            for (int j = 0; j < inlen; ++j) {
                if (j > 0) {
                    buf.append(",");
                }
                WSDLInterfaceOperationInput in = ins[j];
                xmlName = in.getElement();
                xmlType = in.getXMLType();
                xsmodel = this.wsdl.getWsdlTypes().getSchemaModel();
                xt = xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
                if (this.shouldUnwrap()) {
                    this.unwrapRequest(buf, xt);
                    break;
                }
                this.generateParameter(buf, in, xmlName, xmlType, xsmodel, xt, false, true);
                buf.append(" ").append(this.getMethodParam(xmlName));
            }
            int n = lenOuts = outs != null ? outs.length : 0;
            if (!this.shouldUnwrap() && lenOuts > 1) {
                for (int m = 1; m < lenOuts; ++m) {
                    if (this.isInOutHolder(outs[m])) continue;
                    buf.append(",");
                    xmlName = outs[m].getElement();
                    xmlType = outs[m].getXMLType();
                    xsmodel = this.wsdl.getWsdlTypes().getSchemaModel();
                    xt = xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
                    boolean primitive = true;
                    WrappedArray wrappedArray = new WrappedArray(xt);
                    String arraySuffix = "";
                    if (wrappedArray.unwrap()) {
                        xt = wrappedArray.xt;
                        xmlType = wrappedArray.xmlType;
                        primitive = !wrappedArray.nillable;
                        arraySuffix = wrappedArray.suffix;
                    }
                    if (xt instanceof XSSimpleTypeDefinition) {
                        xmlType = SchemaUtils.handleSimpleType((XSSimpleTypeDefinition)xt);
                    }
                    Class cls = this.getJavaType(xmlType, primitive);
                    buf.append(this.utils.getHolder(cls).getName()).append(" ").append(this.getMethodParam(xmlName));
                }
            }
            buf.append(") throws ");
            WSDLInterfaceOperationOutfault[] outfaults = op.getOutfaults();
            for (int k = 0; k < outfaults.length; ++k) {
                Class cl;
                WSDLInterfaceOperationOutfault fault = outfaults[k];
                QName faultqname = fault.getRef();
                WSDLInterfaceFault intfFault = fault.getWsdlInterfaceOperation().getWsdlInterface().getFault(new NCName(faultqname.getLocalPart()));
                JBossXSModel xsmodel2 = this.wsdl.getWsdlTypes().getSchemaModel();
                QName faultXMLName = intfFault.getXmlName();
                QName faultXMLType = intfFault.getXmlType();
                XSElementDeclaration xe = xsmodel2.getElementDeclaration(faultXMLName.getLocalPart(), faultXMLName.getNamespaceURI());
                XSTypeDefinition xt2 = xe.getTypeDefinition();
                if (!xt2.getAnonymous()) {
                    xt2 = xsmodel2.getTypeDefinition(xt2.getName(), xt2.getNamespace());
                }
                if (xt2 instanceof XSComplexTypeDefinition) {
                    this.generateJavaSource((XSComplexTypeDefinition)xt2, xsmodel2, faultXMLName.getLocalPart(), true);
                }
                if ((cl = this.getJavaType(faultXMLType, false)) == null) {
                    buf.append(this.seiPkgName + "." + this.cleanUpFaultName(faultXMLType.getLocalPart()));
                } else {
                    buf.append(cl.getName());
                }
                buf.append(",");
            }
            buf.append(" java.rmi.RemoteException");
            buf.append(";");
            buf.append(this.newline);
        }
    }

    private void generateParameter(StringBuilder buf, WSDLInterfaceOperationInput in, QName xmlName, QName xmlType, JBossXSModel xsmodel, XSTypeDefinition xt, boolean array, boolean primitive) throws IOException {
        String arraySuffix;
        WrappedArray wrappedArray = new WrappedArray(xt);
        String string = arraySuffix = array ? "[]" : "";
        if (wrappedArray.unwrap()) {
            xt = wrappedArray.xt;
            xmlType = wrappedArray.xmlType;
            primitive = !wrappedArray.nillable;
            arraySuffix = wrappedArray.suffix;
        }
        if (xt instanceof XSSimpleTypeDefinition) {
            xmlType = SchemaUtils.handleSimpleType((XSSimpleTypeDefinition)xt);
        }
        Class cl = this.getJavaType(xmlType, primitive);
        if (in != null) {
            cl = this.checkNeedHolder(in, cl);
        }
        if (cl != null) {
            buf.append(JavaUtils.getSourceName(cl) + arraySuffix);
        } else {
            String className = xmlType.getLocalPart();
            if (className.charAt(0) == '>') {
                className = className.substring(1);
            }
            className = this.utils.firstLetterUpperCase(className);
            buf.append(this.seiPkgName + "." + className + arraySuffix);
            if (xt instanceof XSComplexTypeDefinition) {
                this.generateJavaSource((XSComplexTypeDefinition)xt, xsmodel, xmlName.getLocalPart());
            }
        }
    }

    private void createSEIFile(WSDLInterface intf, File loc) throws IOException {
        String fname = this.utils.chopPortType(intf.getName().toString());
        if (this.wsdl.getService(new NCName(fname)) != null) {
            fname = fname + "_PortType";
        }
        StringBuilder buf = new StringBuilder();
        this.utils.writeJbossHeader(buf);
        buf.append("package " + this.seiPkgName + ";" + this.newline);
        buf.append("public interface  " + fname + " extends java.rmi.Remote" + this.newline + "{" + this.newline);
        this.appendMethods(intf, buf);
        buf.append("}" + this.newline);
        File sei = this.utils.createPhysicalFile(loc, fname);
        FileWriter writer = new FileWriter(sei);
        writer.write(buf.toString());
        writer.flush();
        writer.close();
    }

    private void createSEI(File loc, WSDLDefinitions wsdl) {
        WSDLInterface[] intarr = wsdl.getInterfaces();
        if (intarr == null || intarr.length == 0) {
            throw new IllegalArgumentException("Interfaces cannot be zero");
        }
        for (WSDLInterface intf : intarr) {
            try {
                this.createSEIFile(intf, loc);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getReturnType(WSDLInterfaceOperationOutput[] outs) throws IOException {
        if (outs == null || outs.length == 0) {
            return "void ";
        }
        WSDLInterfaceOperationOutput out = outs[0];
        QName xmlType = out.getXMLType();
        QName xmlName = out.getElement();
        JBossXSModel xsmodel = this.wsdl.getWsdlTypes().getSchemaModel();
        XSTypeDefinition xt = xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
        if (this.shouldUnwrap()) {
            return this.unwrapResponse(xt);
        }
        boolean primitive = true;
        WrappedArray wrappedArray = new WrappedArray(xt);
        String arraySuffix = "";
        if (wrappedArray.unwrap()) {
            xt = wrappedArray.xt;
            xmlType = wrappedArray.xmlType;
            primitive = !wrappedArray.nillable;
            arraySuffix = wrappedArray.suffix;
        }
        if (xt instanceof XSSimpleTypeDefinition) {
            xmlType = SchemaUtils.handleSimpleType((XSSimpleTypeDefinition)xt);
        }
        Class cls = this.getJavaType(xmlType, primitive);
        if (xt instanceof XSComplexTypeDefinition) {
            this.generateJavaSource((XSComplexTypeDefinition)xt, xsmodel, xmlName.getLocalPart());
        }
        if (cls == null) {
            String className = xmlType.getLocalPart();
            if (className.charAt(0) == '>') {
                className = className.substring(1);
            }
            className = this.utils.firstLetterUpperCase(className);
            return this.seiPkgName + "." + className + arraySuffix;
        }
        if (this.isInOutHolder(out)) {
            return "void";
        }
        if (this.isOutHolder(out)) {
            return this.utils.getHolder(cls).getName();
        }
        if (cls.isArray()) {
            return JavaUtils.getSourceName(cls);
        }
        return cls.getName() + arraySuffix;
    }

    private String cleanUpFaultName(String faultname) {
        boolean endsfault = faultname.endsWith("Fault");
        if (endsfault) {
            int index = faultname.lastIndexOf("Fault");
            faultname = faultname.substring(0, index);
        } else {
            boolean endsError = faultname.endsWith("Error");
            if (endsError) {
                int index = faultname.lastIndexOf("Error");
                faultname = faultname.substring(0, index);
            }
        }
        return faultname;
    }

    private Class checkNeedHolder(WSDLInterfaceOperationInput win, Class cls) {
        QName el;
        WSDLInterfaceOperation op = win.getWsdlOperation();
        WSDLInterfaceOperationOutput out = op.getOutput(el = win.getElement());
        if (out != null) {
            cls = this.utils.getHolder(cls);
        }
        return cls;
    }

    private void checkTypeMapping() {
        if (this.typeMapping == null) {
            throw new WSException("TypeMapping has not been set.");
        }
    }

    private boolean isInOutHolder(WSDLInterfaceOperationOutput wout) {
        QName el;
        WSDLInterfaceOperation op = wout.getWsdlOperation();
        WSDLInterfaceOperationInput inp = op.getInput(el = wout.getElement());
        return inp != null;
    }

    private boolean isOutHolder(WSDLInterfaceOperationOutput wout) {
        if (this.isInOutHolder(wout)) {
            return false;
        }
        WSDLInterfaceOperationOutput[] ops = wout.getWsdlOperation().getOutputs();
        return ops != null && ops.length > 1;
    }

    private Class getJavaType(QName qname, boolean primitive) {
        Class<SOAPElement> cls = this.typeMapping.getJavaType(qname, primitive);
        if (qname.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") && "anyType".equals(qname.getLocalPart()) && cls == Element.class) {
            cls = SOAPElement.class;
        }
        return cls;
    }

    private String getMethodParam(QName qn) {
        return ToolsUtils.firstLetterLowerCase(qn.getLocalPart());
    }

    private File getLocationForJavaGeneration() {
        return new File(this.directoryToGenerate + "/" + this.seiPkgName.replace(".", "/"));
    }

    private void generateJavaSource(XSComplexTypeDefinition xt, JBossXSModel xsmodel, String containingElement) throws IOException {
        this.generateJavaSource(xt, xsmodel, containingElement, false);
    }

    private void generateJavaSource(XSComplexTypeDefinition xt, JBossXSModel xsmodel, String containingElement, boolean exception) throws IOException {
        XSDTypeToJava xtj = new XSDTypeToJava();
        xtj.setTypeMapping(this.typeMapping);
        xtj.createJavaFile(xt, containingElement, this.getLocationForJavaGeneration(), this.seiPkgName, xsmodel, exception);
    }

    @Override
    public boolean isUnwrap() {
        return this.unwrap;
    }

    @Override
    public void setUnwrap(boolean unwrap) {
        this.unwrap = unwrap;
    }

    private class WrappedArray {
        public QName xmlType;
        public XSTypeDefinition xt;
        public String suffix;
        public boolean nillable;

        public WrappedArray(XSTypeDefinition xt) {
            this.xt = xt;
        }

        public boolean unwrap() {
            if (!"Document/Literal".equals(WSDLToJava.this.style)) {
                XSElementDeclaration unwrapped = SchemaUtils.unwrapArrayType(this.xt);
                StringBuilder builder = new StringBuilder();
                while (unwrapped != null) {
                    this.xt = unwrapped.getTypeDefinition();
                    this.nillable = unwrapped.getNillable();
                    builder.append("[]");
                    unwrapped = SchemaUtils.unwrapArrayType(this.xt);
                }
                if (builder.length() > 0) {
                    this.xmlType = new QName(this.xt.getNamespace(), this.xt.getName());
                    this.suffix = builder.toString();
                    return true;
                }
            }
            return false;
        }
    }
}

