/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.tools.Configuration;
import org.jboss.ws.tools.config.ToolsSchemaConfigReader;
import org.jboss.ws.tools.helpers.ToolsHelper;

public class WSTools {
    private static Logger log = Logger.getLogger(WSTools.class);
    private Configuration config;
    private String outputDir = ".";

    public static void main(String[] args) throws IOException {
        WSTools tools = new WSTools();
        tools.generate(args);
    }

    public void generate(String[] args) throws IOException {
        boolean knownArgument = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-config".equals(arg)) {
                this.readToolsConfiguration(args[i + 1]);
                knownArgument = true;
                ++i;
                continue;
            }
            if ("-dest".equals(arg)) {
                this.outputDir = args[i + 1];
                knownArgument = true;
                ++i;
                continue;
            }
            if (!"-classpath".equals(arg) && !"-cp".equals(arg)) continue;
            StringTokenizer st = new StringTokenizer(args[i + 1], File.pathSeparator);
            int tokens = st.countTokens();
            URL[] urls = new URL[tokens];
            for (int j = 0; j < tokens; ++j) {
                String token = st.nextToken();
                urls[j] = new File(token).toURL();
            }
            ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
            URLClassLoader urlLoader = new URLClassLoader(urls, ctxLoader);
            Thread.currentThread().setContextClassLoader(urlLoader);
            knownArgument = true;
            ++i;
        }
        if (!knownArgument) {
            System.out.println("Usage: wstools (-classpath|-cp) <classpath> -config <config> [-dest <destination path>]");
            System.exit(1);
        }
        if (this.config == null) {
            throw new IllegalArgumentException("wstools config not found");
        }
        this.process();
    }

    private void process() throws IOException {
        ToolsHelper helper = new ToolsHelper();
        if (this.config == null) {
            throw new WSException("Configuration is null");
        }
        boolean processed = false;
        if (this.config.getJavaToWSDLConfig(false) != null) {
            helper.handleJavaToWSDLGeneration(this.config, this.outputDir);
            processed = true;
        }
        if (this.config.getWSDLToJavaConfig(false) != null) {
            helper.handleWSDLToJavaGeneration(this.config, this.outputDir);
            processed = true;
        }
        if (!processed) {
            throw new WSException("Nothing done, Configuration source must have JavaToWSDL or WSDLToJava specified");
        }
    }

    private void readToolsConfiguration(String filename) throws IOException {
        log.debug((Object)("Config file name=" + filename));
        ToolsSchemaConfigReader configReader = new ToolsSchemaConfigReader();
        this.config = configReader.readConfig(filename);
    }
}

