/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.helpers;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.metadata.jaxrpcmapping.ExceptionMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.ws.metadata.jaxrpcmapping.MethodParamPartsMapping;
import org.jboss.ws.metadata.jaxrpcmapping.PackageMapping;
import org.jboss.ws.metadata.jaxrpcmapping.PortMapping;
import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointMethodMapping;
import org.jboss.ws.metadata.jaxrpcmapping.ServiceInterfaceMapping;
import org.jboss.ws.metadata.jaxrpcmapping.VariableMapping;
import org.jboss.ws.metadata.jaxrpcmapping.WsdlMessageMapping;
import org.jboss.ws.metadata.jaxrpcmapping.WsdlReturnValueMapping;
import org.jboss.ws.metadata.wsdl.NCName;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationPart;
import org.jboss.ws.metadata.wsdl.WSDLProperty;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLTypes;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
import org.jboss.ws.tools.ToolsUtils;
import org.jboss.ws.utils.JavaUtils;
import org.w3c.dom.Element;

public class MappingFileGeneratorHelper {
    private static final Logger log = Logger.getLogger(MappingFileGeneratorHelper.class);
    private WSDLDefinitions wsdlDefinitions = null;
    private String serviceName = null;
    private String packageName = null;
    private Class serviceEndpointInterface = null;
    private String typeNamespace = null;
    private Set<String> registeredTypes = new HashSet<String>();
    private LiteralTypeMapping typeMapping = null;
    private String wsdlStyle;
    private WSDLUtils utils = WSDLUtils.getInstance();
    private boolean unwrap = false;
    private List<XSTypeDefinition> queueTypes = new ArrayList<XSTypeDefinition>();

    public MappingFileGeneratorHelper(WSDLDefinitions wsdl, String sname, String pname, Class seiClass, String tns, LiteralTypeMapping ltm, boolean unwrap) {
        this.wsdlDefinitions = wsdl;
        this.serviceName = sname;
        this.packageName = pname;
        this.serviceEndpointInterface = seiClass;
        this.typeNamespace = tns;
        this.typeMapping = ltm;
        this.wsdlStyle = this.utils.getWSDLStyle(wsdl);
        this.unwrap = unwrap;
        this.checkEssentials();
    }

    public PackageMapping constructPackageMapping(JavaWsdlMapping jwm, String packageType, String ns) {
        PackageMapping pk = new PackageMapping(jwm);
        pk.setPackageType(packageType);
        pk.setNamespaceURI(ns);
        return pk;
    }

    public ServiceInterfaceMapping constructServiceInterfaceMapping(JavaWsdlMapping jwm, WSDLService ser) {
        String javaServiceName = this.serviceName = ser.getName().toString();
        if (this.wsdlDefinitions.getInterface(new NCName(this.serviceName)) != null) {
            javaServiceName = javaServiceName + "_Service";
        }
        if (this.serviceName == null || this.serviceName.length() == 0) {
            throw new IllegalArgumentException("MappingFileGenerator:Service Name is null");
        }
        String targetNS = this.wsdlDefinitions.getTargetNamespace();
        String prefix = "serviceNS";
        ServiceInterfaceMapping sim = new ServiceInterfaceMapping(jwm);
        sim.setServiceInterface(this.packageName + "." + javaServiceName);
        sim.setWsdlServiceName(new QName(targetNS, this.serviceName, prefix));
        WSDLEndpoint[] endpoints = ser.getEndpoints();
        int lenendpoints = 0;
        if (endpoints != null) {
            lenendpoints = endpoints.length;
        }
        for (int j = 0; j < lenendpoints; ++j) {
            WSDLEndpoint endpt = endpoints[j];
            String portname = endpt.getName().toString();
            PortMapping pm = new PortMapping(sim);
            pm.setPortName(portname);
            pm.setJavaPortName(portname);
            sim.addPortMapping(pm);
        }
        return sim;
    }

    public void constructServiceEndpointInterfaceMapping(JavaWsdlMapping jwm, WSDLService ser) {
        this.serviceName = ser.getName().toString();
        if (this.serviceName == null || this.serviceName.length() == 0) {
            throw new IllegalArgumentException("MappingFileGenerator:Service Name is null");
        }
        String targetNS = this.wsdlDefinitions.getTargetNamespace();
        WSDLEndpoint[] endpoints = ser.getEndpoints();
        int lenendpoints = 0;
        if (endpoints != null) {
            lenendpoints = endpoints.length;
        }
        for (int j = 0; j < lenendpoints; ++j) {
            String portName;
            WSDLEndpoint endpt = endpoints[j];
            QName binding = endpt.getBinding();
            WSDLBinding wsdlbind = this.wsdlDefinitions.getBinding(new NCName(binding.getLocalPart()));
            String bindName = wsdlbind.getName().toString();
            String portTypeName = wsdlbind.getInterfaceName().getLocalPart();
            WSDLInterface wsdlintf = this.wsdlDefinitions.getInterface(new NCName(portTypeName));
            String javaPortName = portName = wsdlintf.getName().toString();
            if (this.wsdlDefinitions.getService(new NCName(portName)) != null) {
                javaPortName = javaPortName + "_PortType";
            }
            ServiceEndpointInterfaceMapping seim = new ServiceEndpointInterfaceMapping(jwm);
            seim.setServiceEndpointInterface(this.packageName + "." + javaPortName);
            seim.setWsdlPortType(new QName(targetNS, portName, "portTypeNS"));
            seim.setWsdlBinding(new QName(targetNS, bindName, "bindingNS"));
            this.constructServiceEndpointMethodMapping(seim, wsdlintf);
            jwm.addServiceEndpointInterfaceMappings(seim);
        }
    }

    public void constructServiceEndpointMethodMapping(ServiceEndpointInterfaceMapping seim, WSDLInterface intf) {
        String portName = intf.getName().toString();
        String targetNS = this.wsdlDefinitions.getTargetNamespace();
        WSDLInterfaceOperation[] wioparr = intf.getOperations();
        int len = 0;
        if (wioparr != null) {
            len = wioparr.length;
        }
        for (int j = 0; j < len; ++j) {
            WSDLInterfaceOperation wiop = wioparr[j];
            String opname = wiop.getName().toString();
            ServiceEndpointMethodMapping semm = new ServiceEndpointMethodMapping(seim);
            semm.setJavaMethodName(ToolsUtils.firstLetterLowerCase(opname));
            semm.setWsdlOperation(opname);
            semm.setWrappedElement(this.shouldUnwrap());
            this.constructMethodParamPartsMapping(semm, wiop);
            seim.addServiceEndpointMethodMapping(semm);
            WSDLInterfaceOperationOutput[] wiopoutarr = wiop.getOutputs();
            WSDLInterfaceOperationPart wiout = null;
            if (wiopoutarr != null && wiopoutarr.length > 0) {
                wiout = wiopoutarr[0];
            }
            if (wiout == null) continue;
            QName xmlName = wiout.getElement();
            QName xmlType = wiout.getXMLType();
            WSDLProperty wprop = wiout.getProperty("http://www.jboss.org/jbossws/messagename");
            QName messageName = new QName(targetNS, wprop.getValue(), "wsdlMsgNS");
            if (this.shouldUnwrap()) {
                JBossXSModel schemaModel = this.wsdlDefinitions.getWsdlTypes().getSchemaModel();
                XSTypeDefinition xt = schemaModel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
                this.unwrapResponse(semm, messageName, xt);
                continue;
            }
            if (wiop.getInputByPartName(xmlName.getLocalPart()) != null) continue;
            String javaType = this.getJavaTypeAsString(xmlName, xmlType, false, true);
            if (!this.isDocStyle() && "void".equals(javaType)) continue;
            WsdlReturnValueMapping wrvm = new WsdlReturnValueMapping(semm);
            wrvm.setMethodReturnValue(javaType);
            wrvm.setWsdlMessage(messageName);
            wprop = wiout.getProperty("http://www.jboss.org/jbossws/partname");
            wrvm.setWsdlMessagePartName(wprop.getValue());
            semm.setWsdlReturnValueMapping(wrvm);
        }
    }

    public void constructMethodParamPartsMapping(ServiceEndpointMethodMapping semm, WSDLInterfaceOperation wiop) {
        WSDLInterfaceOperationOutput[] outs;
        int lenOuts;
        String portName = wiop.getWsdlInterface().getName().toString();
        String opname = wiop.getName().toString();
        WSDLInterfaceOperationInput[] wiopinarr = wiop.getInputs();
        int lenwiopin = wiopinarr != null ? wiopinarr.length : 0;
        for (int k = 0; k < lenwiopin; ++k) {
            WSDLInterfaceOperationInput win = wiopinarr[k];
            QName xmlName = win.getElement();
            QName xmlType = win.getXMLType();
            String wsdlMessageName = "";
            wsdlMessageName = win.getProperty("http://www.jboss.org/jbossws/messagename").getValue();
            String partName = win.getProperty("http://www.jboss.org/jbossws/partname").getValue();
            String paramMode = "";
            paramMode = wiop.getOutputByPartName(partName) != null ? "INOUT" : "IN";
            if (this.shouldUnwrap()) {
                JBossXSModel schemaModel = this.wsdlDefinitions.getWsdlTypes().getSchemaModel();
                XSTypeDefinition xt = schemaModel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
                this.unwrapRequest(semm, wsdlMessageName, xt);
                break;
            }
            MethodParamPartsMapping mpin = this.getMethodParamPartsMapping(semm, xmlName, xmlType, k, wsdlMessageName, paramMode, partName, false, true);
            semm.addMethodParamPartsMapping(mpin);
        }
        int n = lenOuts = (outs = wiop.getOutputs()) != null ? outs.length : 0;
        if (lenOuts > 1) {
            for (int m = 1; m < lenOuts; ++m) {
                WSDLInterfaceOperationOutput out = outs[m];
                if (this.isInOutHolder(out)) continue;
                QName xmlName = out.getElement();
                QName xmlType = out.getXMLType();
                MethodParamPartsMapping mpm = this.getMethodParamPartsMapping(semm, xmlName, xmlType, lenwiopin + m - 1, out.getProperty("http://www.jboss.org/jbossws/messagename").getValue(), "OUT", xmlName.getLocalPart(), false, true);
                semm.addMethodParamPartsMapping(mpm);
            }
        }
    }

    public void constructJavaXmlTypeMapping(JavaWsdlMapping jwm) {
        WSDLInterface[] intfArr = this.wsdlDefinitions.getInterfaces();
        int len = intfArr != null ? intfArr.length : 0;
        for (int i = 0; i < len; ++i) {
            WSDLInterface wi = intfArr[i];
            WSDLInterfaceOperation[] ops = wi.getOperations();
            int lenOps = ops.length;
            for (int j = 0; j < lenOps; ++j) {
                Object jxtm = null;
                WSDLInterfaceOperation op = ops[j];
                for (WSDLInterfaceOperationInput input : op.getInputs()) {
                    XSTypeDefinition xt = this.getXSType(input);
                    this.addJavaXMLTypeMap(xt, input.getElement().getLocalPart(), jwm, !this.isDocStyle());
                }
                for (WSDLInterfaceOperationOutput output : op.getOutputs()) {
                    XSTypeDefinition xt = this.getXSType(output);
                    this.addJavaXMLTypeMap(xt, output.getElement().getLocalPart(), jwm, !this.isDocStyle());
                }
                for (WSDLInterfaceFault fault : wi.getFaults()) {
                    QName xmlType = fault.getXmlType();
                    QName xmlName = fault.getXmlName();
                    WSDLTypes types = this.wsdlDefinitions.getWsdlTypes();
                    JBossXSModel xsmodel = types.getSchemaModel();
                    XSTypeDefinition xt = xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
                    this.addJavaXMLTypeMap(xt, xmlName.getLocalPart(), jwm, true);
                    ExceptionMapping exceptionMapping = new ExceptionMapping(jwm);
                    exceptionMapping.setExceptionType(this.getJavaTypeAsString(null, xmlType, false, true));
                    exceptionMapping.setWsdlMessage(new QName(this.wsdlDefinitions.getTargetNamespace(), fault.getName().toString()));
                    jwm.addExceptionMappings(exceptionMapping);
                }
            }
        }
    }

    private void unwrapRequest(ServiceEndpointMethodMapping methodMapping, String messageName, XSTypeDefinition xt) {
        if (!(xt instanceof XSComplexTypeDefinition)) {
            throw new WSException("Tried to unwrap a non-complex type.");
        }
        XSComplexTypeDefinition wrapper = (XSComplexTypeDefinition)xt;
        XSParticle particle = wrapper.getParticle();
        XSTerm term = particle.getTerm();
        if (!(term instanceof XSModelGroup)) {
            throw new WSException("Expected model group, could not unwrap");
        }
        this.unwrapRequestParticles(methodMapping, messageName, (XSModelGroup)term);
    }

    private int unwrapRequestParticles(ServiceEndpointMethodMapping methodMapping, String messageName, XSModelGroup group) {
        if (group.getCompositor() != 1) {
            throw new WSException("Only a sequence type can be unwrapped.");
        }
        int elementCount = 0;
        XSObjectList particles = group.getParticles();
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            XSTerm term = particle.getTerm();
            if (term instanceof XSModelGroup) {
                elementCount += this.unwrapRequestParticles(methodMapping, messageName, (XSModelGroup)term);
                continue;
            }
            if (!(term instanceof XSElementDeclaration)) continue;
            XSElementDeclaration element = (XSElementDeclaration)term;
            QName xmlName = new QName(element.getNamespace(), element.getName());
            QName xmlType = new QName(element.getTypeDefinition().getNamespace(), element.getTypeDefinition().getName());
            boolean array = particle.getMaxOccursUnbounded() || particle.getMaxOccurs() > 1;
            MethodParamPartsMapping parts = this.getMethodParamPartsMapping(methodMapping, xmlName, xmlType, elementCount, messageName, "IN", xmlName.getLocalPart(), array, !element.getNillable());
            methodMapping.addMethodParamPartsMapping(parts);
            ++elementCount;
        }
        return elementCount;
    }

    private void unwrapResponse(ServiceEndpointMethodMapping methodMapping, QName messageName, XSTypeDefinition xt) {
        if (!(xt instanceof XSComplexTypeDefinition)) {
            throw new WSException("Tried to unwrap a non-complex type.");
        }
        XSComplexTypeDefinition wrapper = (XSComplexTypeDefinition)xt;
        XSParticle particle = wrapper.getParticle();
        XSTerm term = particle.getTerm();
        if (!(term instanceof XSModelGroup)) {
            throw new WSException("Expected model group, could not unwrap");
        }
        this.unwrapResponseParticles(methodMapping, messageName, (XSModelGroup)term);
    }

    private boolean unwrapResponseParticles(ServiceEndpointMethodMapping methodMapping, QName messageName, XSModelGroup group) {
        if (group.getCompositor() != 1) {
            throw new WSException("Only a sequence type can be unwrapped.");
        }
        XSObjectList particles = group.getParticles();
        Object returnType = null;
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            XSTerm term = particle.getTerm();
            if (term instanceof XSModelGroup) {
                if (!this.unwrapResponseParticles(methodMapping, messageName, (XSModelGroup)term)) continue;
                return true;
            }
            if (!(term instanceof XSElementDeclaration)) continue;
            XSElementDeclaration element = (XSElementDeclaration)term;
            QName xmlName = new QName(element.getNamespace(), element.getName());
            QName xmlType = new QName(element.getTypeDefinition().getNamespace(), element.getTypeDefinition().getName());
            boolean array = particle.getMaxOccursUnbounded() || particle.getMaxOccurs() > 1;
            StringBuilder buf = new StringBuilder();
            String javaType = this.getJavaTypeAsString(xmlName, xmlType, array, !element.getNillable());
            WsdlReturnValueMapping wrvm = new WsdlReturnValueMapping(methodMapping);
            wrvm.setMethodReturnValue(javaType);
            wrvm.setWsdlMessage(messageName);
            wrvm.setWsdlMessagePartName(xmlName.getLocalPart());
            methodMapping.setWsdlReturnValueMapping(wrvm);
            return true;
        }
        return false;
    }

    private void checkEssentials() {
        if (this.typeMapping == null) {
            throw new WSException("typeMapping is null");
        }
    }

    private XSTypeDefinition getXSType(WSDLInterfaceOperationPart part) {
        WSDLInterfaceOperation op = part.getWsdlOperation();
        String zeroarg1 = null;
        Object zeroarg2 = null;
        WSDLProperty prop1 = op.getProperty("http://www.jboss.org/jbossws/zero-args");
        if (prop1 != null) {
            zeroarg1 = prop1.getValue();
        }
        if (zeroarg1 != null && zeroarg2 != null && !zeroarg1.equals(zeroarg2)) {
            return null;
        }
        if (zeroarg1 != null && "true".equals(zeroarg1)) {
            return null;
        }
        QName xmlType = part.getXMLType();
        WSDLTypes types = this.wsdlDefinitions.getWsdlTypes();
        JBossXSModel xsmodel = types.getSchemaModel();
        return xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
    }

    private void addJavaXMLTypeMap(XSTypeDefinition xt, String containingElement, JavaWsdlMapping jwm, boolean skipWrapperArray) {
        JavaXmlTypeMapping jxtm = null;
        if (xt instanceof XSComplexTypeDefinition) {
            XSTerm xterm;
            XSParticle xp;
            XSModelGroup xm = null;
            XSComplexTypeDefinition xc = (XSComplexTypeDefinition)xt;
            if (xc.getContentType() != 0 && (xp = xc.getParticle()) != null && (xterm = xp.getTerm()) instanceof XSModelGroup) {
                xm = (XSModelGroup)xterm;
            }
            if (!skipWrapperArray || !this.isRepresentsArray(xt)) {
                XSObjectList attributeUses;
                XSSimpleTypeDefinition simple;
                String javaType;
                jxtm = new JavaXmlTypeMapping(jwm);
                String localName = xt.getName();
                if (localName == null) {
                    javaType = this.getJavaTypeAsString(null, new QName(containingElement), false, true);
                    localName = ">" + containingElement;
                    jxtm.setAnonymousTypeQName(new QName(xt.getNamespace(), localName, "typeNS"));
                } else {
                    javaType = this.getJavaTypeAsString(null, new QName(localName), false, true);
                    jxtm.setRootTypeQName(new QName(xt.getNamespace(), xt.getName(), "typeNS"));
                }
                if (this.registeredTypes.contains(javaType)) {
                    return;
                }
                jxtm.setJavaType(javaType);
                jxtm.setQNameScope("complexType");
                this.registeredTypes.add(javaType);
                jwm.addJavaXmlTypeMappings(jxtm);
                if (xm != null) {
                    this.addVariableMappingMap(xm, jxtm, javaType);
                }
                if ((simple = xc.getSimpleType()) != null) {
                    this.addJavaXMLTypeMap((XSTypeDefinition)simple, xc.getName(), jwm, skipWrapperArray);
                }
                if ((attributeUses = xc.getAttributeUses()) != null) {
                    this.addAttributeMappings(attributeUses, jxtm);
                }
            }
            if (xm != null) {
                this.addGroup(xm, jwm);
            }
        }
    }

    private void addVariableMappingMap(XSModelGroup xm, JavaXmlTypeMapping jxtm, String javaType) {
        XSObjectList xo = xm.getParticles();
        int len = xo != null ? xo.getLength() : 0;
        for (int i = 0; i < len; ++i) {
            XSTerm xsterm = ((XSParticle)xo.item(i)).getTerm();
            if (xsterm instanceof XSModelGroup) {
                this.addVariableMappingMap((XSModelGroup)xsterm, jxtm, javaType);
                continue;
            }
            if (!(xsterm instanceof XSElementDeclaration)) continue;
            XSElementDeclaration xe = (XSElementDeclaration)xsterm;
            VariableMapping vm = new VariableMapping(jxtm);
            String name = xe.getName();
            vm.setJavaVariableName(Introspector.decapitalize(name));
            vm.setXmlElementName(name);
            jxtm.addVariableMapping(vm);
        }
    }

    private void addAttributeMappings(XSObjectList attributes, JavaXmlTypeMapping jxtm) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            XSAttributeUse obj = (XSAttributeUse)attributes.item(i);
            XSAttributeDeclaration att = obj.getAttrDeclaration();
            XSSimpleTypeDefinition simple = att.getTypeDefinition();
            this.addJavaXMLTypeMap((XSTypeDefinition)simple, "none", jxtm.getJavaWsdlMapping(), true);
            VariableMapping vm = new VariableMapping(jxtm);
            String name = att.getName();
            vm.setXmlAttributeName(name);
            vm.setJavaVariableName(Introspector.decapitalize(name));
            jxtm.addVariableMapping(vm);
        }
    }

    private void addGroup(XSModelGroup xm, JavaWsdlMapping jwm) {
        XSObjectList xo = xm.getParticles();
        int len = xo != null ? xo.getLength() : 0;
        for (int i = 0; i < len; ++i) {
            XSTerm xsterm = ((XSParticle)xo.item(i)).getTerm();
            if (xsterm instanceof XSModelGroup) {
                this.addGroup((XSModelGroup)xsterm, jwm);
                continue;
            }
            if (!(xsterm instanceof XSElementDeclaration)) continue;
            XSElementDeclaration xe = (XSElementDeclaration)xsterm;
            XSTypeDefinition typeDefinition = xe.getTypeDefinition();
            this.addJavaXMLTypeMap(typeDefinition, xe.getName(), jwm, true);
        }
    }

    private Method[] getMethodsGivenOperationName(Class clazz, String opname) {
        ArrayList<Method> alist = new ArrayList<Method>();
        for (Method m : clazz.getDeclaredMethods()) {
            if (!opname.equals(m.getName())) continue;
            alist.add(m);
        }
        Method[] marr = new Method[alist.size()];
        alist.toArray(marr);
        return marr;
    }

    private String getJavaTypeAsString(QName xmlName, QName xmlType, boolean array, boolean primitive) {
        String arraySuffix;
        String jtype = null;
        String string = arraySuffix = array ? "[]" : "";
        if (!this.isDocStyle()) {
            JBossXSModel xsmodel = this.wsdlDefinitions.getWsdlTypes().getSchemaModel();
            XSTypeDefinition xt = xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
            XSElementDeclaration unwrapped = SchemaUtils.unwrapArrayType(xt);
            StringBuilder builder = new StringBuilder();
            while (unwrapped != null) {
                xt = unwrapped.getTypeDefinition();
                primitive = !unwrapped.getNillable();
                builder.append("[]");
                unwrapped = SchemaUtils.unwrapArrayType(xt);
            }
            if (builder.length() > 0) {
                xmlType = new QName(xt.getNamespace(), xt.getName());
                arraySuffix = builder.toString();
            }
        }
        Class<SOAPElement> javaType = this.typeMapping.getJavaType(xmlType, primitive);
        if (xmlType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") && "anyType".equals(xmlType.getLocalPart()) && javaType == Element.class) {
            javaType = SOAPElement.class;
        }
        if ((javaType = this.makeCustomDecisions(javaType, xmlName, xmlType)) == null) {
            log.debug((Object)("Typemapping lookup failed for " + xmlName));
            log.debug((Object)"Falling back to identifier generation");
            String className = xmlType.getLocalPart();
            if (className.charAt(0) == '>') {
                className = className.substring(1);
            }
            jtype = this.packageName + "." + this.utils.firstLetterUpperCase(className);
        } else {
            jtype = javaType.isArray() ? JavaUtils.getSourceName(javaType) : javaType.getName();
        }
        return jtype + arraySuffix;
    }

    private boolean isDocStyle() {
        return "Document/Literal".equals(this.wsdlStyle);
    }

    private boolean isPublicField(Class javaType, String fieldname) {
        Field[] fldarr = this.utils.getPublicFields(javaType);
        int len = fldarr != null ? fldarr.length : 0;
        for (int i = 0; i < len; ++i) {
            Field fld = fldarr[i];
            if (!fieldname.equals(fld.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isRepresentsArray(XSTypeDefinition xst) {
        boolean bool = false;
        if (xst instanceof XSComplexTypeDefinition) {
            XSModelGroup xm;
            XSObjectList xo;
            XSComplexTypeDefinition xc = (XSComplexTypeDefinition)xst;
            if (xc.getContentType() == 0) {
                return false;
            }
            XSParticle xsp = xc.getParticle();
            if (xsp == null) {
                return false;
            }
            XSTerm xsterm = xsp.getTerm();
            if (xsterm instanceof XSModelGroup && (xo = (xm = (XSModelGroup)xsterm).getParticles()).getLength() == 1) {
                XSParticle xp = (XSParticle)xo.item(0);
                bool = xp.getMaxOccursUnbounded() || xp.getMaxOccurs() > 1;
            }
        }
        return bool;
    }

    private Class makeCustomDecisions(Class javaType, QName xmlName, QName xmlType) {
        if (javaType != null && xmlType != null && Byte[].class == javaType && "http://www.w3.org/2001/XMLSchema".equals(xmlType.getNamespaceURI()) && "base64Binary".equals(xmlType.getLocalPart())) {
            javaType = byte[].class;
        }
        return javaType;
    }

    private boolean shouldUnwrap() {
        return this.unwrap && "Document/Literal".equals(this.wsdlStyle);
    }

    private boolean isInOutHolder(WSDLInterfaceOperationOutput wout) {
        QName el;
        WSDLInterfaceOperation op = wout.getWsdlOperation();
        WSDLInterfaceOperationInput inp = op.getInput(el = wout.getElement());
        return inp != null;
    }

    private MethodParamPartsMapping getMethodParamPartsMapping(ServiceEndpointMethodMapping semm, QName xmlName, QName xmlType, int paramPosition, String wsdlMessageName, String paramMode, String wsdlMessagePartName, boolean array, boolean primitive) {
        String targetNS = this.wsdlDefinitions.getTargetNamespace();
        MethodParamPartsMapping mppm = new MethodParamPartsMapping(semm);
        mppm.setParamPosition(paramPosition);
        String javaType = this.getJavaTypeAsString(xmlName, xmlType, array, primitive);
        mppm.setParamType(javaType);
        WsdlMessageMapping wmm = new WsdlMessageMapping(mppm);
        wmm.setParameterMode(paramMode);
        String wsdlNS = "wsdlMsgNS";
        wmm.setWsdlMessage(new QName(targetNS, wsdlMessageName, wsdlNS));
        wmm.setWsdlMessagePartName(wsdlMessagePartName);
        mppm.setWsdlMessageMapping(wmm);
        return mppm;
    }
}

