/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.util.file.JarUtils;
import org.jboss.ws.integration.other.GenericServiceEndpointPublisher;

public class wspublish {
    protected final Logger log = Logger.getLogger(wspublish.class);
    public static final String DEFAULT_TOMCAT_SERVICE_ENDPOINT_SERVLET = "org.jboss.ws.integration.other.GenericServiceEndpointServlet";

    public URL process(URL warURL, File destDir, String servletName) throws IOException {
        if (warURL == null) {
            throw new IllegalArgumentException("Invalid war URL: " + warURL);
        }
        if (destDir == null || !destDir.isDirectory()) {
            throw new IllegalArgumentException("Invalid destintion dir: " + destDir);
        }
        if (servletName == null) {
            servletName = DEFAULT_TOMCAT_SERVICE_ENDPOINT_SERVLET;
        }
        InputStream in = warURL.openStream();
        String warName = new File(warURL.getFile()).getName();
        File tmpDir = new File("./wspublish/" + warName);
        tmpDir.mkdirs();
        this.log.debug((Object)("Extracting war to: " + tmpDir));
        JarUtils.unjar((InputStream)in, (File)tmpDir);
        in.close();
        GenericServiceEndpointPublisher publisher = new GenericServiceEndpointPublisher();
        publisher.setServiceEndpointServlet(servletName);
        publisher.rewriteWebXML(tmpDir.toURL());
        File outFile = new File(destDir.getCanonicalPath() + "/" + warName);
        outFile.getParentFile().mkdirs();
        this.log.info((Object)("Writing war to: " + outFile.toURL()));
        FileOutputStream fos = new FileOutputStream(outFile);
        JarUtils.jar((OutputStream)fos, (File[])tmpDir.listFiles());
        fos.close();
        return outFile.toURL();
    }

    public static void main(String[] args) throws Exception {
        URL warURL = null;
        File destDir = null;
        String servletName = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-url".equals(arg)) {
                warURL = wspublish.getURL(args[i + 1]);
                ++i;
                continue;
            }
            if ("-dest".equals(arg)) {
                destDir = new File(args[i + 1]);
                ++i;
                continue;
            }
            if (!"-servlet".equals(arg)) continue;
            servletName = args[i + 1];
            ++i;
        }
        if (warURL == null || destDir == null) {
            System.out.println("Usage: wspublish -url warURL -dest webappsDir [-servlet servletName]");
            System.exit(1);
        }
        new wspublish().process(warURL, destDir, servletName);
    }

    private static URL getURL(String urlStr) {
        URL warURL = null;
        try {
            warURL = new URL(urlStr);
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        try {
            warURL = new File(urlStr).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return warURL;
    }
}

