/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.utils;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jboss.ws.WSException;
import org.jboss.ws.utils.IOUtils;
import org.jboss.ws.utils.JavaUtils;

public class MimeUtils {
    private static Map<String, Class> mime2class = new HashMap<String, Class>();
    private static Map<Class, String> class2mime = new HashMap<Class, String>();

    public static QName convertMimeTypeToXmlType(String mimeType) {
        StringBuilder mimeName = new StringBuilder(mimeType);
        int pos = mimeName.indexOf("/");
        if (pos == -1) {
            return null;
        }
        mimeName.setCharAt(pos, '_');
        return new QName("http://www.jboss.org/jbossws/attachment/mimetype", mimeName.toString());
    }

    public static String getBaseMimeType(String mimeType) {
        ContentType contentType;
        if (mimeType == null) {
            return null;
        }
        try {
            contentType = new ContentType(mimeType);
        }
        catch (ParseException e) {
            return null;
        }
        return contentType.getBaseType();
    }

    public static boolean isMemberOf(String mimeType, Set mimeTypes) {
        if (mimeTypes.contains(mimeType)) {
            return true;
        }
        try {
            if (mimeTypes.contains(new ContentType(mimeType).getPrimaryType() + "/*")) {
                return true;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return false;
    }

    public static Class resolveClass(String mimeType) {
        Class<DataHandler> cl = mime2class.get(mimeType);
        if (null == cl) {
            cl = DataHandler.class;
        }
        return cl;
    }

    public static String resolveMimeType(Object obj) {
        String mimeType = obj instanceof MimeMultipart ? ((MimeMultipart)obj).getContentType() : MimeUtils.resolveMimeType(obj.getClass());
        return mimeType;
    }

    public static String resolveMimeType(Class clazz) {
        String mimeType = "application/octet-stream";
        for (Class cl : class2mime.keySet()) {
            if (!JavaUtils.isAssignableFrom(cl, clazz)) continue;
            mimeType = class2mime.get(cl);
        }
        return mimeType;
    }

    public static ByteArrayConverter getConverterForJavaType(Class targetClazz) {
        ByteArrayConverter converter = null;
        if (JavaUtils.isAssignableFrom(Image.class, targetClazz)) {
            converter = new ImageConverter();
        } else if (JavaUtils.isAssignableFrom(Source.class, targetClazz)) {
            converter = new SourceConverter();
        } else if (JavaUtils.isAssignableFrom(String.class, targetClazz)) {
            converter = new StringConverter();
        } else if (JavaUtils.isAssignableFrom(InputStream.class, targetClazz)) {
            converter = new StreamConverter();
        }
        if (null == converter) {
            throw new WSException("No ByteArrayConverter for class: " + targetClazz.getName());
        }
        return converter;
    }

    public static ByteArrayConverter getConverterForContentType(String contentType) {
        ByteArrayConverter converter = null;
        if (contentType != null) {
            if ("image/jpeg".equals(contentType) || "image/jpg".equals(contentType)) {
                converter = new ImageConverter();
            } else if ("text/xml".equals(contentType) || "application/xml".equals(contentType)) {
                converter = new SourceConverter();
            } else if ("text/plain".equals(contentType)) {
                converter = new StringConverter();
            } else if ("application/octet-stream".equals(contentType)) {
                converter = new StreamConverter();
            }
        }
        if (null == converter) {
            throw new WSException("No ByteArrayConverter for content type: " + contentType);
        }
        return converter;
    }

    static {
        mime2class.put("text/plain", String.class);
        mime2class.put("image/jpeg", Image.class);
        mime2class.put("text/xml", Source.class);
        mime2class.put("application/xml", Source.class);
        mime2class.put("application/octet-stream", DataHandler.class);
        class2mime.put(Image.class, "image/jpeg");
        class2mime.put(Source.class, "text/xml");
        class2mime.put(String.class, "text/plain");
    }

    public static interface ByteArrayConverter {
        public Object readFrom(InputStream var1);

        public void writeTo(Object var1, OutputStream var2);
    }

    public static class StreamConverter
    implements ByteArrayConverter {
        public Object readFrom(InputStream in) {
            return in;
        }

        public void writeTo(Object obj, OutputStream out) {
            if (obj instanceof InputStream) {
                try {
                    IOUtils.copyStream(out, (InputStream)obj);
                }
                catch (IOException e) {
                    throw new WSException("Failed to convert " + obj.getClass());
                }
            }
        }
    }

    public static class StringConverter
    implements ByteArrayConverter {
        public Object readFrom(InputStream in) {
            String converted = null;
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                StringBuilder sb = new StringBuilder();
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line + "\n");
                }
                br.close();
                converted = sb.toString();
            }
            catch (IOException e) {
                throw new WSException("Failed to convert java.lang.String");
            }
            return converted;
        }

        public void writeTo(Object obj, OutputStream out) {
            if (obj instanceof String) {
                String s = (String)obj;
                try {
                    out.write(s.getBytes("UTF-8"));
                }
                catch (IOException e) {
                    throw new WSException("Failed to convert " + obj.getClass());
                }
            } else {
                throw new WSException("Unable to convert " + obj.getClass());
            }
        }
    }

    public static class SourceConverter
    implements ByteArrayConverter {
        public Object readFrom(InputStream in) {
            return new StreamSource(in);
        }

        public void writeTo(Object obj, OutputStream out) {
            if (obj instanceof StreamSource) {
                StreamSource s = (StreamSource)obj;
                try {
                    IOUtils.copyStream(out, s.getInputStream());
                }
                catch (IOException e) {
                    throw new WSException("Failed to convert " + obj.getClass());
                }
            } else {
                throw new WSException("Unable to convert " + obj.getClass());
            }
        }
    }

    public static class ImageConverter
    implements ByteArrayConverter {
        public Object readFrom(InputStream in) {
            BufferedImage converted = null;
            try {
                BufferedImage bim;
                JPEGImageDecoder dec = JPEGCodec.createJPEGDecoder((InputStream)in);
                converted = bim = dec.decodeAsBufferedImage();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return converted;
        }

        public void writeTo(Object obj, OutputStream out) {
            if (obj instanceof BufferedImage) {
                JPEGImageEncoder enc = JPEGCodec.createJPEGEncoder((OutputStream)out);
                try {
                    enc.encode((BufferedImage)obj);
                }
                catch (IOException e) {
                    throw new WSException("Failed to convert " + obj.getClass());
                }
            } else {
                throw new WSException("Unable to convert " + obj.getClass());
            }
        }
    }
}

