/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.wsse;

import org.jboss.ws.wsse.SecurityAdaptor;
import org.jboss.ws.wsse.SecurityAdaptorFactory;
import org.jboss.ws.wsse.SecurityStore;
import org.jboss.ws.wsse.SimplePrincipal;
import org.jboss.ws.wsse.TokenOperation;
import org.jboss.ws.wsse.WSSecurityException;
import org.jboss.ws.wsse.element.SecurityHeader;
import org.jboss.ws.wsse.element.Token;
import org.jboss.ws.wsse.element.UsernameToken;
import org.w3c.dom.Document;

public class ReceiveUsernameOperation
implements TokenOperation {
    private SecurityHeader header;
    private SecurityStore store;

    public ReceiveUsernameOperation(SecurityHeader header, SecurityStore store) {
        this.header = header;
        this.store = store;
    }

    public void process(Document message, Token token) throws WSSecurityException {
        UsernameToken user = (UsernameToken)token;
        SecurityAdaptorFactory factory = SecurityAdaptorFactory.getInstance();
        SecurityAdaptor securityAdaptor = factory.getSecurityAdaptor();
        securityAdaptor.setPrincipal(new SimplePrincipal(user.getUsername()));
        securityAdaptor.setCredential(user.getPassword());
    }
}

