/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.wsse;

import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.wsse.SecurityAdaptor;

public class SecurityAdaptorFactory {
    private static final Logger log = Logger.getLogger(SecurityAdaptorFactory.class);
    public static final String DEFAULT_FACTORY = "org.jboss.ws.integration.SecurityAdaptorFactoryImpl";
    private static SecurityAdaptorFactory delegate;

    public static SecurityAdaptorFactory getInstance() {
        if (delegate == null) {
            ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> factoryClass = ctxLoader.loadClass(DEFAULT_FACTORY);
                delegate = (SecurityAdaptorFactory)factoryClass.newInstance();
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception e) {
                throw new WSException("Cannot load: org.jboss.ws.integration.SecurityAdaptorFactoryImpl", e);
            }
        }
        return delegate;
    }

    public SecurityAdaptor getSecurityAdaptor() {
        return delegate.getSecurityAdaptor();
    }
}

