/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.xop;

import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMUtils;
import org.jboss.ws.WSException;
import org.jboss.ws.soap.MessageContextAssociation;
import org.jboss.ws.soap.NameImpl;
import org.jboss.ws.soap.SOAPMessageContextImpl;
import org.jboss.ws.soap.SOAPMessageImpl;
import org.jboss.ws.utils.JavaUtils;
import org.jboss.ws.utils.MimeUtils;
import org.jboss.ws.xop.SimpleDataSource;
import org.jboss.ws.xop.XOPMarshallerImpl;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.jboss.xb.binding.sunday.xop.XOPObject;
import org.w3c.dom.Node;

public class XOPContext {
    private static final Logger log = Logger.getLogger(XOPContext.class);
    private static final String NS_XOP_JBOSSWS = "http://org.jboss.ws/xop";

    public static boolean isXOPPackage() {
        boolean isXOP = false;
        SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
        if (msgContext != null) {
            SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getMessage();
            isXOP = soapMessage != null && soapMessage.isXOPMessage();
        }
        return isXOP;
    }

    public static boolean isMTOMEnabled() {
        SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
        boolean mtomEnabled = msgContext.getProperty("org.jboss.ws.mtom.enabled") == null ? true : ((String)msgContext.getProperty("org.jboss.ws.mtom.enabled")).equalsIgnoreCase("true");
        return mtomEnabled;
    }

    public static void inlineXOPData(SOAPElement xopElement) {
        String ns = xopElement.getNamespaceURI() != null ? xopElement.getNamespaceURI() : "";
        String localName = xopElement.getLocalName();
        if (ns.equals("http://www.w3.org/2004/08/xop/include") && localName.equals("Include")) {
            XOPContext.replaceXOPInclude(xopElement.getParentElement(), xopElement);
        } else {
            Iterator it = DOMUtils.getChildElements((Node)xopElement);
            while (it.hasNext()) {
                SOAPElement childElement = (SOAPElement)it.next();
                String childNS = childElement.getNamespaceURI() != null ? childElement.getNamespaceURI() : "";
                String childName = childElement.getLocalName();
                if (childNS.equals("http://www.w3.org/2004/08/xop/include") && childName.equals("Include")) {
                    XOPContext.replaceXOPInclude(xopElement, childElement);
                    continue;
                }
                XOPContext.inlineXOPData(childElement);
            }
        }
    }

    public static void restoreXOPData(SOAPElement xopElement) {
        String contentType = xopElement.getAttributeNS(NS_XOP_JBOSSWS, "content-type");
        if (contentType != null && contentType.length() > 0) {
            XOPContext.replaceBase64Representation(xopElement, contentType);
            xopElement.removeAttribute(new NameImpl(new QName(NS_XOP_JBOSSWS, "content-type")));
        } else {
            Iterator it = DOMUtils.getChildElements((Node)xopElement);
            while (it.hasNext()) {
                SOAPElement childElement = (SOAPElement)it.next();
                XOPContext.restoreXOPData(childElement);
            }
        }
    }

    private static void replaceBase64Representation(SOAPElement xopElement, String contentType) {
        SOAPElement parentElement = xopElement.getParentElement();
        log.debug((Object)("Replace base64 representation on element [xmlName=" + parentElement.getLocalName() + "]"));
        String base64 = xopElement.getValue();
        byte[] data = SimpleTypeBindings.unmarshalBase64((String)base64);
        MimeUtils.ByteArrayConverter converter = MimeUtils.getConverterForContentType(contentType);
        Object converted = converter.readFrom(new ByteArrayInputStream(data));
        XOPObject xopObject = new XOPObject(converted);
        xopObject.setContentType(contentType);
        XOPMarshallerImpl xopMarshaller = new XOPMarshallerImpl();
        String cid = xopMarshaller.addMtomAttachment(xopObject, xopElement.getNamespaceURI(), xopElement.getLocalName());
        Node child = xopElement.getFirstChild();
        xopElement.removeChild(child);
        try {
            SOAPElement xopInclude = xopElement.addChildElement("Include", "xop", "http://www.w3.org/2004/08/xop/include");
            xopInclude.setAttribute("href", cid);
            log.debug((Object)("Restored xop:Include element on {" + xopElement.getNamespaceURI() + "}" + xopElement.getLocalName()));
        }
        catch (SOAPException e) {
            throw new WSException("Failed to create XOP include element", e);
        }
    }

    private static void replaceXOPInclude(SOAPElement parent, SOAPElement xopIncludeElement) {
        AttachmentPart removedPart;
        byte[] data;
        String contentType;
        log.debug((Object)("Replace xop:Include on element [xmlName=" + parent.getLocalName() + "]"));
        String cid = xopIncludeElement.getAttribute("href");
        try {
            AttachmentPart part = XOPContext.getAttachmentByCID(cid);
            DataHandler dh = part.getDataHandler();
            contentType = dh.getContentType();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            dh.writeTo((OutputStream)bout);
            data = bout.toByteArray();
        }
        catch (Exception e) {
            throw new WSException("Failed to inline XOP data", e);
        }
        String base64 = SimpleTypeBindings.marshalBase64((byte[])data);
        parent.removeChild(xopIncludeElement);
        parent.setValue(base64);
        parent.setAttributeNS(NS_XOP_JBOSSWS, "content-type", contentType);
        log.debug((Object)("Created base64 representation for content-type " + contentType));
        SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
        SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getMessage();
        if (cid.startsWith("cid:")) {
            cid = cid.substring(4);
        }
        if (null == (removedPart = soapMessage.removeAttachmentByContentId(cid = '<' + cid + '>'))) {
            throw new WSException("Unable to remove attachment part " + cid);
        }
        log.debug((Object)("Removed attachment part " + cid));
    }

    public static AttachmentPart getAttachmentByCID(String cid) throws SOAPException {
        AttachmentPart part;
        SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
        SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getMessage();
        if (cid.startsWith("cid:")) {
            cid = cid.substring(4);
        }
        if ((part = soapMessage.getAttachmentByContentId(cid = '<' + cid + '>')) == null) {
            throw new WSException("Cannot find attachment part for: " + cid);
        }
        return part;
    }

    public static DataHandler createDataHandler(XOPObject xopObject) {
        DataHandler dataHandler;
        Object o = xopObject.getContent();
        if (o instanceof DataHandler) {
            dataHandler = (DataHandler)o;
        } else if (xopObject.getContentType() != null) {
            dataHandler = new DataHandler(o, xopObject.getContentType());
        } else if (!XOPContext.getContentTypeForClazz(o.getClass()).equals("application/octet-stream")) {
            dataHandler = new DataHandler(o, XOPContext.getContentTypeForClazz(o.getClass()));
        } else {
            SimpleDataSource ds = new SimpleDataSource(o, "application/octet-stream");
            dataHandler = new DataHandler((DataSource)ds);
        }
        return dataHandler;
    }

    public static String getContentTypeForClazz(Class clazz) {
        if (JavaUtils.isAssignableFrom(Image.class, clazz)) {
            return "image/jpeg";
        }
        if (JavaUtils.isAssignableFrom(Source.class, clazz)) {
            return "application/xml";
        }
        if (JavaUtils.isAssignableFrom(String.class, clazz)) {
            return "text/plain";
        }
        return "application/octet-stream";
    }
}

