/*
 * Decompiled with CFR 0.152.
 */
package servletunit.struts;

import junit.framework.TestCase;
import servletunit.struts.Common;

public class TestPathFunctions
extends TestCase {
    public void testStripSessionId() {
        String path = "/my/path;jsessionid=123456789";
        path = Common.stripJSessionID(path);
        TestPathFunctions.assertEquals((String)"/my/path", (String)path);
    }

    public void testStripLongSessionId() {
        String path = "/my/path;jsessionid=99999999999999999999999999999999999999999999999999999999999";
        path = Common.stripJSessionID(path);
        TestPathFunctions.assertEquals((String)"/my/path", (String)path);
    }

    public void testStripSessionIdWithQueryString() {
        String path = "/my/path;jsessionid=123456789?param=\"true\"";
        path = Common.stripJSessionID(path);
        TestPathFunctions.assertEquals((String)"/my/path?param=\"true\"", (String)path);
    }
}

