/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.conf;

import com.tandbergtv.workflow.adaptor.conf.AdaptorConfigurationException;
import com.tandbergtv.workflow.adaptor.conf.DispatcherConfigurationImpl;
import com.tandbergtv.workflow.adaptor.conf.HandlerConfigurationImpl;
import com.tandbergtv.workflow.adaptor.conf.IConfigurationLoaderStrategy;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.conf.IMessageProcessorConfiguration;
import com.tandbergtv.workflow.adaptor.conf.MessageProcessorConfigurationImpl;
import com.tandbergtv.workflow.comm.DeviceType;
import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.ISource;
import com.tandbergtv.workflow.comm.TCPDevice;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConfigurationLoaderStrategy
implements IConfigurationLoaderStrategy {
    private static final String CONFIGURATION_ROOT_XPATH = "//adaptor-config/message";
    private static final String HANDLER_PARAMETER_XPATH = "/handler/parameter";
    private static final String DISPATCHER_PARAMETER_XPATH = "/dispatcher/parameter";
    private static final String DESTINATION_XPATH = "/addressing/destination";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String DESTINATION_TYPE_ATTR = "type";
    private static final String IP = "ip";
    private static final String PORT = "port";
    private String CONFIG_FILE = "adaptor-config/adaptor-config.xml";
    private Document configDoc = null;
    private static final Logger logger = Logger.getLogger(XMLConfigurationLoaderStrategy.class);

    XMLConfigurationLoaderStrategy() {
        String prefix = this.getClass().getPackage().getName();
        String resource = prefix.replace('.', '/') + "/" + this.CONFIG_FILE;
        InputStream stream = null;
        try {
            stream = this.getClass().getClassLoader().getResourceAsStream(resource);
            this.configDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream);
        }
        catch (IOException e) {
            throw new AdaptorConfigurationException("Failed to read configuration file - " + resource + ", maybe you haven't bundled it in the JAR?");
        }
        catch (Exception ex) {
            throw new AdaptorConfigurationException("Failed to parse configuration file - " + resource);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
    }

    @Override
    public IMessageProcessorConfiguration getConfiguration(IMessageUID uid) {
        IMessageProcessorConfiguration conf = null;
        String expression = "//adaptor-config/message[@UID='" + uid.getUID() + "']";
        try {
            conf = this.readConfiguration(this.configDoc, expression);
        }
        catch (Exception e) {
            throw new AdaptorConfigurationException("Failed to read configuration", e);
        }
        return conf;
    }

    public synchronized IMessageUID getMessageUID(String uid) {
        String name;
        String expression = "//adaptor-config/message[@UID='" + uid + "']";
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            Element e = (Element)xpath.evaluate(expression, this.configDoc, XPathConstants.NODE);
            if (e == null) {
                throw new RuntimeException("Message uid " + uid + " not found");
            }
            name = e.getAttribute(NAME_ATTRIBUTE);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Failed to parse document", e);
        }
        return new MessageUIDImpl(uid, name);
    }

    @Override
    public List<IDestination> getDestinations(IMessageUID uid) {
        ArrayList<IDestination> destinations = new ArrayList<IDestination>();
        String expression = "//adaptor-config/message[@UID='" + uid.getUID() + "']";
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nodes = (NodeList)xpath.evaluate(expression + DESTINATION_XPATH, this.configDoc, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element e = (Element)nodes.item(i);
                String type = e.getAttributes().getNamedItem(DESTINATION_TYPE_ATTR).getTextContent();
                IDestination destination = this.getDestination(e, type);
                destinations.add(destination);
            }
        }
        catch (Exception e) {
            throw new AdaptorConfigurationException("Failed to read configuration", e);
        }
        return destinations;
    }

    private IMessageProcessorConfiguration readConfiguration(Node document, String prefix) throws XPathExpressionException {
        IHandlerConfiguration handlerConf = this.getHandlerConfiguration(document, prefix);
        IDispatcherConfiguration dispatcherConf = this.getDispatcherConfiguration(document, prefix);
        return new MessageProcessorConfigurationImpl(handlerConf, dispatcherConf);
    }

    private IHandlerConfiguration getHandlerConfiguration(Node document, String prefix) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String expression = prefix + HANDLER_PARAMETER_XPATH;
        NodeList nodes = (NodeList)xpath.evaluate(expression, document, XPathConstants.NODESET);
        HandlerConfigurationImpl conf = new HandlerConfigurationImpl();
        logger.debug((Object)"Handler parameters:");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getAttributes().getNamedItem(NAME_ATTRIBUTE).getNodeValue();
            String value = node.getAttributes().getNamedItem(VALUE_ATTRIBUTE).getNodeValue();
            logger.debug((Object)("\t" + name + ", " + value));
            conf.addParameter(name, value);
        }
        return conf;
    }

    private IDispatcherConfiguration getDispatcherConfiguration(Node document, String prefix) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String expression = prefix + DISPATCHER_PARAMETER_XPATH;
        NodeList nodes = (NodeList)xpath.evaluate(expression, document, XPathConstants.NODESET);
        DispatcherConfigurationImpl conf = new DispatcherConfigurationImpl();
        logger.debug((Object)"Dispatcher parameters:");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getAttributes().getNamedItem(NAME_ATTRIBUTE).getNodeValue();
            String value = node.getAttributes().getNamedItem(VALUE_ATTRIBUTE).getNodeValue();
            logger.debug((Object)("\t" + name + ", " + value));
            conf.addParameter(name, value);
        }
        return conf;
    }

    private IDestination getDestination(Element e, String type) {
        ISource destination = null;
        if (DeviceType.HTTP.toString().equalsIgnoreCase(type)) {
            Node child = e.getElementsByTagName("url").item(0);
            String url = child.getTextContent();
            destination = new HTTPDevice(url);
        } else if (DeviceType.TCP.toString().equalsIgnoreCase(type)) {
            Node child = e.getElementsByTagName("host").item(0);
            String ip = child.getAttributes().getNamedItem(IP).getTextContent();
            String port = child.getAttributes().getNamedItem(PORT).getTextContent();
            destination = new TCPDevice(ip, Integer.parseInt(port));
        }
        return destination;
    }
}

