/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.comm;

import com.tandbergtv.workflow.adaptor.AdaptorFactory;
import com.tandbergtv.workflow.adaptor.AdaptorRequestImpl;
import com.tandbergtv.workflow.adaptor.IAdaptorRequest;
import com.tandbergtv.workflow.adaptor.IAdaptorResponse;
import com.tandbergtv.workflow.comm.CommunicationException;
import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.TCPDevice;
import com.tandbergtv.workflow.message.AbstractMessage;
import com.tandbergtv.workflow.message.HTTPMessage;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.TCPMessage;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.MessageConverter;
import com.tandbergtv.workflow.messageprocessor.CommandManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Router {
    private static Logger logger = Logger.getLogger(Router.class);

    public static IMessage sendToWFS(IMessage messageRequest) throws CommunicationException {
        if (!(messageRequest instanceof HTTPMessage) && !(messageRequest instanceof TCPMessage)) {
            throw new CommunicationException("Cannot handle requests other than TCP or HTTP");
        }
        logger.debug((Object)("Sending message " + messageRequest + " to WFS"));
        AbstractMessage messageResponse = null;
        WorkflowMessage wfsMessageRequest = null;
        try {
            wfsMessageRequest = MessageConverter.toWorkflowMessage(messageRequest);
            logger.debug((Object)("Message UID " + wfsMessageRequest + "sending to message processor"));
            WorkflowMessage wfsMessageResponse = CommandManager.createAndExecute((WorkflowMessage)wfsMessageRequest);
            logger.debug((Object)("Response received : " + wfsMessageResponse));
            if (messageRequest instanceof HTTPMessage) {
                messageResponse = MessageConverter.toHTTPMessage(wfsMessageResponse);
            } else if (messageRequest instanceof TCPMessage) {
                messageResponse = MessageConverter.toTCPMessage(wfsMessageResponse);
            }
        }
        catch (Exception ex) {
            throw new CommunicationException(ex.getMessage(), ex);
        }
        logger.debug((Object)("Response from Commnication component : " + messageResponse));
        return messageResponse;
    }

    public static WorkflowMessage sendToAdaptor(WorkflowMessage wfsMessageRequest, List<IDestination> destinations) throws CommunicationException {
        try {
            if (destinations == null || destinations.isEmpty()) {
                throw new CommunicationException("List of destinations is either null or empty");
            }
            logger.debug((Object)("Request: " + wfsMessageRequest));
            WorkflowMessage wfsMessageResponse = null;
            for (IDestination destination : destinations) {
                AbstractMessage messageRequest = null;
                if (destination instanceof TCPDevice) {
                    messageRequest = MessageConverter.toTCPMessage(wfsMessageRequest);
                } else if (destination instanceof HTTPDevice) {
                    messageRequest = MessageConverter.toHTTPMessage(wfsMessageRequest);
                } else {
                    throw new CommunicationException("TCP or HTTP Devices are only supported");
                }
                ArrayList<IDestination> listOfDestinations = new ArrayList<IDestination>();
                listOfDestinations.add(destination);
                AdaptorRequestImpl request = new AdaptorRequestImpl((IMessage)messageRequest, listOfDestinations);
                IAdaptorResponse response = AdaptorFactory.newInstance().getGenericAdaptor(null).transmit((IAdaptorRequest)request);
                IMessage messageResponse = response.getMessage();
                wfsMessageResponse = MessageConverter.toWorkflowMessage(messageResponse);
            }
            logger.debug((Object)("Response: " + wfsMessageResponse));
            return wfsMessageResponse;
        }
        catch (Exception ex) {
            throw new CommunicationException("Sending to Adaptor failed", ex);
        }
    }
}

