/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message;

import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.ISource;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageAttachment;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.IPayload;

public abstract class AbstractMessage
implements IMessage {
    private IMessageKey key;
    private IMessageUID uid;
    private IMessageAttachment attachment;
    private ISource source;
    private IDestination responseDestination;
    private IPayload payload;

    protected AbstractMessage() {
    }

    protected AbstractMessage(IMessageUID uid) {
        this(uid, null);
    }

    protected AbstractMessage(IMessageUID uid, IPayload payload) {
        this(uid, null, payload);
    }

    protected AbstractMessage(IMessageKey key, IMessageUID uid, IPayload payload) {
        this(key, uid, null, payload);
    }

    protected AbstractMessage(IMessageUID uid, IMessageAttachment attachment, IPayload payload) {
        this(null, uid, attachment, null, null, payload);
    }

    protected AbstractMessage(IMessageKey key, IMessageUID uid, ISource source, IPayload payload) {
        this(key, uid, null, source, null, payload);
    }

    protected AbstractMessage(IMessageKey key, IMessageUID uid, IMessageAttachment attachment, ISource source, IDestination responseDestination, IPayload payload) {
        this.key = key;
        this.uid = uid;
        this.attachment = attachment;
        this.source = source;
        this.responseDestination = responseDestination;
        this.payload = payload;
    }

    public IMessageUID getMessageUID() {
        return this.uid;
    }

    public IMessageAttachment getAttachment() {
        return this.attachment;
    }

    public void addAttachment(IMessageAttachment attachment) {
        this.attachment = attachment;
    }

    public IPayload getPayload() {
        return this.payload;
    }

    public IMessageKey getKey() {
        return this.key;
    }

    public ISource getSource() {
        return this.source;
    }

    public IDestination getResponseDestination() {
        return this.responseDestination;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Message [").append(this.uid).append("], payload=").append(this.payload);
        if (this.attachment != null) {
            buf.append(", attachment=").append(this.attachment);
        }
        return buf.toString();
    }

    public void setAttachment(IMessageAttachment attachment) {
        this.attachment = attachment;
    }

    public void setKey(IMessageKey key) {
        this.key = key;
    }

    public void setPayload(IPayload payload) {
        this.payload = payload;
    }

    public void setSource(ISource source) {
        this.source = source;
    }

    public void setResponseDestination(IDestination responseDestination) {
        this.responseDestination = responseDestination;
    }

    public void setMessageUID(IMessageUID uid) {
        this.uid = uid;
    }

    public boolean isAsync() {
        return this.key != null && this.key.toString().trim().length() > 0 && this.responseDestination != null;
    }
}

