/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message;

import com.tandbergtv.workflow.message.AbstractMessage;
import com.tandbergtv.workflow.message.HTTPAttachment;
import com.tandbergtv.workflow.message.HTTPMethod;
import com.tandbergtv.workflow.message.HTTPPayload;
import com.tandbergtv.workflow.message.IMessageAttachment;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.IProtocolDependentMessage;

public class HTTPMessage
extends AbstractMessage
implements IProtocolDependentMessage {
    private static final String PROTOCOL_NAME = "HTTP";
    private HTTPMethod method;

    public HTTPMessage() {
    }

    public HTTPMessage(IMessageUID uid) {
        super(uid);
    }

    public HTTPMessage(IMessageUID uid, HTTPPayload payload) {
        super(uid, payload);
    }

    public HTTPMessage(IMessageKey key, IMessageUID uid, HTTPPayload payload) {
        super(key, uid, (IPayload)payload);
    }

    public HTTPMessage(IMessageUID uid, HTTPAttachment attachment, HTTPPayload payload) {
        super(uid, attachment, (IPayload)payload);
    }

    public HTTPMessage(IMessageUID uid, HTTPAttachment attachment, HTTPPayload payload, HTTPMethod method) {
        super(uid, attachment, (IPayload)payload);
        this.method = method;
    }

    public void addAttachment(IMessageAttachment attachment) {
        if (attachment != null && !(attachment instanceof HTTPAttachment)) {
            throw new RuntimeException("Only HTTP attachments are supported");
        }
        super.addAttachment(attachment);
    }

    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    public HTTPMethod getMethod() {
        return this.method;
    }

    public void setMethod(HTTPMethod method) {
        this.method = method;
    }
}

