/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message;

import com.tandbergtv.workflow.comm.ISource;
import com.tandbergtv.workflow.message.AbstractMessage;
import com.tandbergtv.workflow.message.IMessageAttachment;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.WorkflowPayload;

public class WorkflowMessage
extends AbstractMessage {
    private MessageType type;

    public WorkflowMessage() {
        this(null);
    }

    public WorkflowMessage(IMessageUID uid) {
        this(uid, MessageType.control);
    }

    public WorkflowMessage(IMessageUID uid, MessageType type) {
        this(uid, type, new WorkflowPayload());
    }

    public WorkflowMessage(IMessageKey key, IMessageUID uid, MessageType type) {
        this(key, uid, type, null);
    }

    public WorkflowMessage(IMessageUID uid, WorkflowPayload payload) {
        this(uid, MessageType.control, payload);
    }

    public WorkflowMessage(IMessageKey key, IMessageUID uid, WorkflowPayload payload) {
        this(key, uid, MessageType.control, payload);
    }

    public WorkflowMessage(IMessageUID uid, MessageType type, WorkflowPayload payload) {
        super(uid, payload);
        this.type = type;
    }

    public WorkflowMessage(IMessageKey key, IMessageUID uid, MessageType type, WorkflowPayload payload) {
        this(key, uid, (ISource)null, payload);
        this.type = type;
    }

    public WorkflowMessage(IMessageUID uid, IMessageAttachment attachment, WorkflowPayload payload) {
        super(uid, attachment, (IPayload)payload);
    }

    public WorkflowMessage(IMessageKey key, IMessageUID uid, ISource source, WorkflowPayload payload) {
        super(key, uid, source, payload);
    }

    public WorkflowMessage(IMessageKey key, IMessageUID uid, IMessageAttachment attachment, ISource source, WorkflowPayload payload) {
        super(key, uid, attachment, source, null, payload);
    }

    public MessageType getType() {
        return this.type;
    }

    public void setType(MessageType type) {
        this.type = type;
    }

    public String getValue(String name) {
        WorkflowPayload payload = (WorkflowPayload)this.getPayload();
        return payload == null ? null : payload.getValue(name);
    }

    public void putValue(String name, String value) {
        WorkflowPayload payload = (WorkflowPayload)this.getPayload();
        payload.putValue(name, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageType {
        control,
        ack,
        nack,
        notification,
        error;

    }
}

