/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.util;

import com.tandbergtv.workflow.message.HTTPAttachment;
import com.tandbergtv.workflow.message.HTTPMessage;
import com.tandbergtv.workflow.message.HTTPPayload;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageAttachment;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.TCPMessage;
import com.tandbergtv.workflow.message.TCPPayload;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.MarshalException;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class MessageConverter {
    private static final Logger logger = Logger.getLogger(MessageConverter.class);

    public static WorkflowMessage toWorkflowMessage(IMessage message) throws MarshalException {
        if (!(message.getPayload() instanceof StringPayload)) {
            throw new MarshalException("Payloads other than StringPayload are not supported");
        }
        StringPayload payload = (StringPayload)message.getPayload();
        Document messageDocument = MessageConverter.toDocument(payload.getContent());
        WorkflowMessage wfsMessage = Unmarshaller.unmarshal(messageDocument);
        wfsMessage.setMessageUID(message.getMessageUID());
        IMessageAttachment messageAttachment = message.getAttachment();
        if (messageAttachment != null) {
            if (!(message instanceof HTTPMessage)) {
                throw new MarshalException("Attachments other than HTTPMessage are not supported");
            }
            if (messageAttachment instanceof HTTPAttachment) {
                wfsMessage.setAttachment(messageAttachment);
            } else {
                logger.warn((Object)"Attachment found is not a http attachment hence not converted");
            }
        }
        return wfsMessage;
    }

    public static HTTPMessage toHTTPMessage(WorkflowMessage wfsMessage) throws MarshalException, TransformerException, TransformerConfigurationException {
        HTTPMessage httpMessage = null;
        Document messageDocument = Marshaller.newMarshaller().marshal(wfsMessage);
        HTTPPayload httpPayload = new HTTPPayload(MessageConverter.toString(messageDocument));
        httpMessage = new HTTPMessage(wfsMessage.getMessageUID(), httpPayload);
        httpMessage.setKey(wfsMessage.getKey());
        httpMessage.setResponseDestination(wfsMessage.getResponseDestination());
        httpMessage.setSource(wfsMessage.getSource());
        IMessageAttachment messageAttachment = wfsMessage.getAttachment();
        if (messageAttachment != null) {
            if (messageAttachment instanceof HTTPAttachment) {
                httpMessage.setAttachment(messageAttachment);
            } else {
                logger.warn((Object)"Attachment found is not a http attachment hence not converted");
            }
        }
        return httpMessage;
    }

    public static TCPMessage toTCPMessage(WorkflowMessage wfsMessage) throws MarshalException, TransformerException, TransformerConfigurationException {
        TCPMessage tcpMessage = null;
        Document messageDocument = Marshaller.newMarshaller().marshal(wfsMessage);
        TCPPayload tcpPayload = new TCPPayload(MessageConverter.toString(messageDocument));
        tcpMessage = new TCPMessage(wfsMessage.getMessageUID(), tcpPayload);
        tcpMessage.setKey(wfsMessage.getKey());
        tcpMessage.setResponseDestination(wfsMessage.getResponseDestination());
        tcpMessage.setSource(wfsMessage.getSource());
        IMessageAttachment messageAttachment = wfsMessage.getAttachment();
        if (messageAttachment != null) {
            throw new MarshalException("Attachment is not supported for TCPMessage");
        }
        return tcpMessage;
    }

    public static String toString(Document doc) throws TransformerException, TransformerConfigurationException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StringWriter stringWriter = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(stringWriter));
        return stringWriter.getBuffer().toString();
    }

    public static Document toDocument(String xmlString) throws MarshalException {
        Document d = null;
        try {
            InputSource is = new InputSource(new StringReader(xmlString));
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            d = db.parse(is);
        }
        catch (Exception ex) {
            throw new MarshalException("Error converting message to Document", ex);
        }
        return d;
    }
}

