/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.util;

import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.IDevice;
import com.tandbergtv.workflow.comm.ISource;
import com.tandbergtv.workflow.comm.TCPDevice;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import com.tandbergtv.workflow.message.MessageUIDFactory;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.message.util.AbstractTree;
import com.tandbergtv.workflow.message.util.MarshalException;
import com.tandbergtv.workflow.message.util.Scalar;
import com.tandbergtv.workflow.message.util.Tree;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Unmarshaller {
    private static final Logger logger = Logger.getLogger(Unmarshaller.class);

    public static WorkflowMessage unmarshal(Document document) throws MarshalException {
        WorkflowMessage wfsMessage = null;
        try {
            Element root = document.getDocumentElement();
            String UID = root.getAttribute("UID");
            String type = root.getAttribute("Type");
            String messageKeyString = root.getAttribute("RequestKey");
            logger.debug((Object)("uid, type, requestkey=" + UID + " " + type + " " + messageKeyString));
            wfsMessage = Unmarshaller.createWorkflowMessage(UID, type, messageKeyString);
            Unmarshaller.unmarshalProperties(document, wfsMessage);
            Unmarshaller.unmarshalMultiLevelParameters(document, wfsMessage);
        }
        catch (Exception e) {
            throw new MarshalException("Failed to unmarshal the document", e);
        }
        return wfsMessage;
    }

    private static void unmarshalMultiLevelParameters(Document doc, WorkflowMessage wfsMessage) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Element parameterListElement = (Element)xpath.evaluate("//MessageBody/ParameterList", doc, XPathConstants.NODE);
        if (parameterListElement != null && parameterListElement.getChildNodes().getLength() > 0) {
            WorkflowPayload payload = new WorkflowPayload();
            AbstractTree absTree = payload.getPayload();
            NodeList parameterElements = parameterListElement.getChildNodes();
            for (int i = 0; i < parameterElements.getLength(); ++i) {
                Node node = parameterElements.item(i);
                if (!(node instanceof Element)) continue;
                Element parameterOrList = (Element)node;
                String tag = parameterOrList.getTagName();
                if (tag.equals("Parameter")) {
                    Unmarshaller.unmarshallScalar(parameterOrList, (Tree)absTree);
                    continue;
                }
                if (!tag.equals("List")) continue;
                Unmarshaller.unmarshallTree(parameterOrList, (Tree)absTree);
            }
            wfsMessage.setPayload(payload);
        }
    }

    private static void unmarshallTree(Element element, Tree tree) {
        String elementKey = element.getAttribute("Name");
        Tree absTree = new Tree(elementKey);
        tree.add(absTree);
        NodeList listItems = element.getChildNodes();
        for (int i = 0; i < listItems.getLength(); ++i) {
            Node node = listItems.item(i);
            if (!(node instanceof Element)) continue;
            Element listItem = (Element)node;
            String tag = listItem.getTagName();
            if (tag.equals("Parameter")) {
                Unmarshaller.unmarshallScalar(listItem, absTree);
                continue;
            }
            if (!tag.equals("ListItem")) continue;
            String listItemKey = listItem.getAttribute("Name");
            Tree listItemTree = new Tree(listItemKey);
            ((AbstractTree)absTree).add(listItemTree);
            NodeList listItemParams = listItem.getChildNodes();
            for (int j = 0; j < listItemParams.getLength(); ++j) {
                Node paramNode = listItemParams.item(j);
                if (!(paramNode instanceof Element)) continue;
                Element parameter = (Element)paramNode;
                String paramTag = parameter.getTagName();
                if (paramTag.equals("Parameter")) {
                    Unmarshaller.unmarshallScalar(parameter, listItemTree);
                    continue;
                }
                if (!paramTag.equals("List")) continue;
                Unmarshaller.unmarshallTree(parameter, listItemTree);
            }
        }
    }

    private static void unmarshallScalar(Element parameter, Tree tree) {
        String parameterKey = parameter.getAttribute("Name");
        Element value = (Element)parameter.getElementsByTagName("Value").item(0);
        String parameterValue = value.getTextContent();
        Tree scalar = new Tree(parameterKey);
        ((AbstractTree)scalar).add(new Scalar(parameterValue));
        tree.add(scalar);
    }

    private static void unmarshalProperties(Document doc, WorkflowMessage wfsMessage) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Element sourceElement = (Element)xpath.evaluate("//WFSMessage/Source", doc, XPathConstants.NODE);
        if (sourceElement != null && sourceElement.hasChildNodes()) {
            Element deviceElement = (Element)sourceElement.getFirstChild();
            ISource source = (ISource)Unmarshaller.createDevice(deviceElement);
            wfsMessage.setSource(source);
            logger.debug((Object)("Source Element found: " + source));
        } else {
            logger.debug((Object)"No Source Element found");
        }
        Element responseDestinationElement = (Element)xpath.evaluate("//WFSMessage/ResponseDestination", doc, XPathConstants.NODE);
        if (responseDestinationElement != null && responseDestinationElement.hasChildNodes()) {
            Element deviceElement = (Element)responseDestinationElement.getFirstChild();
            IDestination responseDestination = (IDestination)Unmarshaller.createDevice(deviceElement);
            wfsMessage.setResponseDestination(responseDestination);
            logger.debug((Object)("ResponseDestination Element found: " + responseDestination));
        } else {
            logger.debug((Object)"No ResponseDestination Element found");
        }
    }

    private static IDevice createDevice(Element deviceElement) {
        ISource device = null;
        if (deviceElement.getTagName() == "URL") {
            String url = deviceElement.getTextContent();
            device = new HTTPDevice(url);
        } else if (deviceElement.getTagName() == "Host") {
            String ip = deviceElement.getAttributes().getNamedItem("IP").getTextContent();
            String portString = deviceElement.getAttributes().getNamedItem("Port").getTextContent();
            int port = portString == null ? 0 : Integer.parseInt(portString);
            device = new TCPDevice(ip, port);
        }
        return device;
    }

    private static WorkflowMessage createWorkflowMessage(String UID, String type, String messageKeyString) {
        WorkflowMessage wfsMessage = null;
        IMessageUID messageUID = MessageUIDFactory.getInstance().getMessageUID(UID);
        wfsMessage = new WorkflowMessage(messageUID);
        WorkflowMessage.MessageType messageType = Unmarshaller.getMessageType(type);
        wfsMessage.setType(messageType);
        MessageKeyImpl messageKey = new MessageKeyImpl(messageKeyString);
        wfsMessage.setKey(messageKey);
        return wfsMessage;
    }

    private static WorkflowMessage.MessageType getMessageType(String messageTypeString) {
        logger.debug((Object)("messageTypeString is " + messageTypeString));
        return WorkflowMessage.MessageType.valueOf(messageTypeString);
    }
}

