/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.filesubsystem;

import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.message.util.MarshalException;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.webservice.filesubsystem.FileManager;
import com.tandbergtv.workflow.webservice.filesubsystem.OperationException;
import com.tandbergtv.workflow.webservice.filesubsystem.RequestHandler;
import com.tandbergtv.workflow.webservice.filesubsystem.messagehandler.MessageHandler;
import com.tandbergtv.workflow.webservice.filesubsystem.messagehandler.MessageHandlerConfigurationException;
import com.tandbergtv.workflow.webservice.filesubsystem.messagehandler.MessageHandlerFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.server.ServiceLifecycle;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class FileSubsystemWebservice
implements ServiceLifecycle {
    private static final Logger logger = Logger.getLogger(FileSubsystemWebservice.class);
    private static final String UNKNOWN_UID = "Unknown UID";
    private RequestHandler requestHandler = null;
    private Marshaller marshaller = null;
    private MessageHandlerFactory mhFactory = null;

    public void process(SOAPEnvelope request, SOAPEnvelope response) {
        WorkflowMessage message = null;
        WorkflowMessage result = null;
        String messageUID = null;
        try {
            logger.info((Object)("Received soap request: " + request));
            message = this.requestHandler.parseRequest(request);
            messageUID = message.getMessageUID().getUID();
            logger.info((Object)("Received valid Workflow Message with UID: " + messageUID));
            MessageHandler handler = this.mhFactory.getMessageHandler(messageUID);
            result = message.isAsync() ? this.handleAsyncMessage(handler, message) : handler.handleMessage(message);
        }
        catch (OperationException oe) {
            logger.error((Object)"Failed to Parse the request and read the Workflow Message.", (Throwable)oe);
            result = this.generateNackMessage(message, oe);
        }
        catch (MessageHandlerConfigurationException mhce) {
            logger.error((Object)("Failed to load the Message Handler for the UID: " + messageUID), (Throwable)mhce);
            result = this.generateNackMessage(message, mhce);
        }
        catch (Exception ex) {
            logger.error((Object)"Unexpected error when processing SOAP request for File Subsystem.", (Throwable)ex);
            result = this.generateNackMessage(message, ex);
        }
        try {
            SOAPBody body = response.getBody();
            body.addDocument(this.marshaller.marshal(result));
        }
        catch (SOAPException ex) {
            logger.error((Object)"Failed to add the Workflow Message response to the SOAP response.", (Throwable)ex);
            this.addSOAPFault(response, ex);
        }
        catch (MarshalException ex) {
            logger.error((Object)"Failed to marshal the Workflow Message response.", (Throwable)ex);
            this.addSOAPFault(response, ex);
        }
        catch (Exception ex) {
            logger.error((Object)"Unexpected error when writing the Workflow Message response.", (Throwable)ex);
            this.addSOAPFault(response, ex);
        }
    }

    private WorkflowMessage handleAsyncMessage(final MessageHandler handler, final WorkflowMessage message) {
        logger.debug((Object)("Handling Asynchronous Message: " + message.getMessageUID().getUID()));
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
        service.submit(new Runnable(){

            public void run() {
                WorkflowMessage response = handler.handleMessage(message);
                logger.info((Object)("Response of the operation: " + response));
                FileSubsystemWebservice.this.handleCallBackMessage(message, response);
            }
        });
        service.shutdown();
        logger.debug((Object)"Finished Calling the runnable thread for handling the callback");
        return this.generateAckReceivedMessage(message);
    }

    public void handleCallBackMessage(WorkflowMessage message, WorkflowMessage result) {
        try {
            result.setMessageUID(new MessageUIDImpl("070107"));
            Document resultDoc = Marshaller.newMarshaller().marshal(result);
            IDestination destination = message.getResponseDestination();
            logger.info((Object)("Sending to Destination: " + (HTTPDevice)destination));
            this.send(resultDoc, ((HTTPDevice)destination).getUrl());
        }
        catch (Exception ex) {
            logger.error((Object)"Failed sending the async response", (Throwable)ex);
        }
    }

    private void send(Document doc, String destinationUrl) {
        try {
            logger.debug((Object)("Making SOAP call to " + destinationUrl));
            SOAPMessage message = MessageFactory.newInstance().createMessage();
            MimeHeaders headers = message.getMimeHeaders();
            headers.addHeader("SOAPAction", "");
            SOAPBody requestBody = message.getSOAPBody();
            requestBody.addDocument(doc);
            SOAPConnection connection = SOAPConnectionFactory.newInstance().createConnection();
            SOAPMessage reply = connection.call(message, (Object)destinationUrl);
            SOAPBody body = reply.getSOAPBody();
            if (body.getFault() != null) {
                SOAPFault fault = body.getFault();
                throw new SOAPException("Got a soap fault in the response: " + fault.getFaultString());
            }
            connection.close();
        }
        catch (Exception ex) {
            logger.error((Object)"Could not send SOAP message.", (Throwable)ex);
        }
    }

    public void init(Object context) throws ServiceException {
        logger.debug((Object)"Initializing the File Subsystem Service...");
        try {
            FileManager.getInstance();
            this.requestHandler = RequestHandler.getInstance();
            this.marshaller = Marshaller.newMarshaller();
            this.mhFactory = MessageHandlerFactory.getInstance();
        }
        catch (Exception ex) {
            String msg = "Failed to initialize the File Subsystem Service.";
            logger.error((Object)msg, (Throwable)ex);
            throw new ServiceException(msg, (Throwable)ex);
        }
        logger.info((Object)"Successfully initialized the File Subsystem Service.");
    }

    public void destroy() {
        logger.info((Object)"Successfully shutdown the File Subsystem Service.");
    }

    private WorkflowMessage generateNackMessage(WorkflowMessage message, Throwable ex) {
        WorkflowMessage response = new WorkflowMessage();
        WorkflowPayload payload = new WorkflowPayload();
        response.setPayload(payload);
        response.setType(WorkflowMessage.MessageType.nack);
        if (message != null) {
            response.setMessageUID(message.getMessageUID());
            response.setKey(message.getKey());
        } else {
            response.setMessageUID(new MessageUIDImpl(UNKNOWN_UID));
        }
        payload.putValue("error-message", ex.getMessage());
        StringWriter writer = new StringWriter();
        ex.printStackTrace(new PrintWriter(writer));
        payload.putValue("error-stack", writer.toString());
        return response;
    }

    private WorkflowMessage generateAckReceivedMessage(WorkflowMessage message) {
        WorkflowMessage response = new WorkflowMessage();
        WorkflowPayload payload = new WorkflowPayload();
        response.setPayload(payload);
        response.setType(WorkflowMessage.MessageType.ack);
        if (message != null) {
            response.setMessageUID(message.getMessageUID());
            response.setKey(message.getKey());
        }
        return response;
    }

    private void addSOAPFault(SOAPEnvelope response, Throwable ex) {
        try {
            SOAPBody body = response.getBody();
            SOAPFault fault = body.addFault();
            fault.setFaultString(ex.getMessage());
        }
        catch (SOAPException se) {
            logger.error((Object)"Failed to write the SOAP Fault in the response.", (Throwable)se);
        }
    }
}

