/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.filesubsystem.messagehandler;

import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.webservice.filesubsystem.messagehandler.MessageHandler;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Logger;

public abstract class AbstractMessageHandler
implements MessageHandler {
    private static final Logger logger = Logger.getLogger(AbstractMessageHandler.class);

    public WorkflowMessage handleMessage(WorkflowMessage message) {
        WorkflowMessage response = new WorkflowMessage();
        WorkflowPayload outPayload = new WorkflowPayload();
        response.setPayload(outPayload);
        try {
            this.prepareResponseMessage(message, response);
            this.performOperation(message, response);
            response.setType(WorkflowMessage.MessageType.ack);
        }
        catch (Exception ex) {
            response.setType(WorkflowMessage.MessageType.nack);
            this.handleOperationException(ex, response);
        }
        return response;
    }

    protected abstract void performOperation(WorkflowMessage var1, WorkflowMessage var2) throws Exception;

    protected void handleOperationException(Throwable ex, WorkflowMessage response) {
        this.writeErrorProperties(response, ex);
        logger.error((Object)("Failed to perform File Subsystem Operation: " + ex.getMessage()), ex);
    }

    protected void prepareResponseMessage(WorkflowMessage message, WorkflowMessage response) {
        response.setMessageUID(message.getMessageUID());
        response.setKey(message.getKey());
    }

    protected void writeErrorProperties(WorkflowMessage response, Throwable ex) {
        WorkflowPayload payload = (WorkflowPayload)response.getPayload();
        StringWriter writer = new StringWriter();
        ex.printStackTrace(new PrintWriter(writer));
        payload.putValue("error-message", ex.getMessage());
        payload.putValue("error-stack", writer.toString());
    }
}

