/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.filesubsystem.messagehandler;

import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.util.XMLObjectSerializer;
import com.tandbergtv.workflow.webservice.filesubsystem.entity.SANFolder;
import com.tandbergtv.workflow.webservice.filesubsystem.messagehandler.FileManagementMessageHandler;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;

public class FolderListingMessageHandler
extends FileManagementMessageHandler {
    protected void performOperation(WorkflowMessage message, WorkflowMessage response) throws Exception {
        WorkflowPayload payload = (WorkflowPayload)message.getPayload();
        String folderPath = payload.getValue("Path");
        File[] files = this.getService().getFileList(folderPath, false);
        ArrayList<SANFolder> folderList = new ArrayList<SANFolder>();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                folderList.add(this.createSANFolder(file));
            }
        }
        String xmlResult = XMLObjectSerializer.serializeObject(folderList);
        WorkflowPayload outPayload = (WorkflowPayload)response.getPayload();
        outPayload.putValue("Result", xmlResult);
    }

    private SANFolder createSANFolder(File file) {
        SANFolder sanFolder = new SANFolder();
        sanFolder.setAbsolutePath(file.getAbsolutePath());
        sanFolder.setName(file.getName());
        sanFolder.setLastModified(file.lastModified());
        File[] childFolders = file.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        int childCount = childFolders != null ? childFolders.length : 0;
        sanFolder.setChildFolderCount(childCount);
        return sanFolder;
    }
}

